$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$Global:ErrorActionPreference="SilentlyContinue"
$bInactiveMailboxUsage = "false"
$bIsOverWarningQuota = "false"
$pastDays = 1
if($args.count -ne 2)
{
	Write-Host("Please pass the password admin's role username and password as arguments")
	return
}
$username = $args[0] 
$pwd = $args[1]
$password = $args[1]  | ConvertTo-SecureString -asPlainText -Force 
$cred = New-Object System.Management.Automation.PSCredential($username,$password) # Encrypt creds for use 
# Report Root URL 
$D = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
Write-Host("MailboxActivityReport")
Write-Host("-----------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxActivityDaily?`$orderby=Date desc&`$top=1&`$format=json"
$entry = (Invoke-RestMethod -Credential $cred -Uri $url)
[System.GC]::GetTotalMemory($true) | out-null
#$Date = $entry.d.Date.ToString("yyyy-MM-dd") # don't enable this 
$TenantName = $entry.d.TenantName
$TotalNumberOfActiveMailboxes = $entry.d.TotalNumberOfActiveMailboxes
$AccountCreated = $entry.d.AccountCreated
$AccountDeleted = $entry.d.AccountDeleted
Write-Host($TotalNumberOfActiveMailboxes,$AccountCreated,$AccountDeleted) -Separator ";"


Write-Host("StateMailboxReport")
Write-Host("--------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/StaleMailbox?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$Date = $entry.Date.ToString("yyyy-MM-dd")
	$TenantName = $entry.TenantName
	$ActiveMailboxes = $entry.ActiveMailboxes
	$InactiveMailboxes31To60Days = $entry.InactiveMailboxes31To60Days
	$InactiveMailboxes61To90Days = $entry.InactiveMailboxes61To90Days
	$InactiveMailboxes91To1460Days = $entry.InactiveMailboxes91To1460Days
	Write-Host($ActiveMailboxes,$InactiveMailboxes31To60Days,$InactiveMailboxes61To90Days,$InactiveMailboxes91To1460Days) -Separator ";"
}

$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/StaleMailboxDetail?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$UserName = $entry.UserName
	$WindowsLiveID = $entry.WindowsLiveID
	$LastLogin = $entry.LastLogin
	$DaysInactive = $entry.DaysInactive 
	Write-Host ($UserName,$WindowsLiveID,$LastLogin,$DaysInactive) -separator ";"
}

Write-Host("MailboxUsageReport")
Write-Host("----------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxUsage?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$Date = $entry.Date.ToString("yyyy-MM-dd")
	$TenantName = $entry.TenantName
	$TotalMailboxCount = $entry.TotalMailboxCount
	$TotalInactiveMailboxCount = $entry.TotalInactiveMailboxCount
	$MailboxesOverWarningSize = $entry.MailboxesOverWarningSize
	$MailboxesUsedLessthan25Percent = $entry.MailboxesUsedLessthan25Percent
	Write-Host($TotalMailboxCount,$TotalInactiveMailboxCount,$MailboxesOverWarningSize,$MailboxesUsedLessthan25Percent) -Separator ";"
}
Write-Host("MailboxUsageDetailReport")
Write-Host("--------------------------")
if($bIsOverWarningQuota -eq "true")
{
	$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxUsageDetail?`$filter=Date eq datetime'"+$D + "' and IsOverWarningQuota eq "+$bIsOverWarningQuota + "&`$format=json"
}
else
{
	$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxUsageDetail?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
}
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$UserName = $entry.UserName
	$WindowsLiveID = $entry.WindowsLiveID
	$MailboxSize = $entry.MailboxSize
	$CurrentMailboxSize = $entry.CurrentMailboxSize
	$PercentUsed = $entry.PercentUsed
	$IsInactive = $entry.IsInactive
	$IssueWarningQuota = $entry.IssueWarningQuota
	$IsOverWarningQuota = $entry.IsOverWarningQuota
	Write-Host ($UserName,$WindowsLiveID,$MailboxSize,$CurrentMailboxSize,$PercentUsed,$IsInactive,$IssueWarningQuota,$IsOverWarningQuota) -separator ";"
}

Write-Host ("ConnectionbyClientTypeDaily")
Write-Host("--------------------------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/ConnectionbyClientTypeDaily?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$Date = $entry.Date
	$ClientType = $entry.ClientType
	$Count = $entry.Count
	$TenantName = $entry.TenantName
	Write-Host ($ClientType,$Count) -separator ";"
}
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/ConnectionbyClientTypeDetailDaily?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$Date = $entry.Date
	$ClientType = $entry.ClientType
	$Count = $entry.Count
	$TenantName = $entry.TenantName
	$UserName = $entry.UserName
	$WindowsLiveID = $entry.WindowsLiveID
	Write-Host ($UserName,$WindowsLiveID,$ClientType,$Count) -separator ";"
}

Write-Host("MailTraffic send and receive")
Write-Host("--------------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTraffic?`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$Organization = $entry.Organization
	$Domain = $entry.Domain
	$Date = $entry.Date
	$EventType = $entry.EventType
	$Direction = $entry.Direction
	$Action = $entry.Action
	$MessageCount = $entry.MessageCount
	#Write-Host ($Organization,$Domain,$Date,$EventType,$Direction,$Action,$MessageCount) -separator ";"
	Write-Host ($Direction,$EventType,$MessageCount) -separator ";"
}

Write-Host("TopRecipientsSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopMailRecipient'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("TopSendersSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopMailSender'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("TopSpamRecipientsSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopSpamRecipient'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("TopMalwareRecipientsSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopMalwareRecipient'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("License Usage")
Write-Host("---------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/LicenseVsUsageSummary?`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
foreach($entry in $entries)
{
	$Date = $entry.Date.ToString("yyyy-MM-dd")
	$Workload = $entry.Workload
	$TrailLicenses = $entry.TrialEntitlements
	$PaidLicenses = $entry.NonTrialEntitlements
	$ActiveUsers = $entry.ActiveUsers
	Write-Host($Workload,$TrailLicenses,$PaidLicenses,$ActiveUsers) -Separator ";"
}

Write-Host("Service Status Report")
Write-Host("-----------------------")
$json = (@{userName=$username;password=$pwd;} | convertto-json).tostring()
$cookie = (invoke-restmethod -contenttype "application/json" -method Post -uri "https://api.admin.microsoftonline.com/shdtenantcommunications.svc/Register" -body $json).RegistrationCookie
#preferredEventType -- "0" to represents a Service Incident, "1" to represent a Maintenance Event, and "2" to represent a Message Center communication 
$load = (@{lastCookie=$cookie;locale="en-US";preferredEventTypes=@(0);pastDays=$pastDays} | convertto-json).tostring()
$events = (invoke-restmethod -contenttype "application/json" -method Post -uri "https://api.admin.microsoftonline.com/shdtenantcommunications.svc/GetEvents" -body $load)
foreach($evnt in $events.events)
{
	$ID = $evnt.ID
	$Title = $evnt.Title
	$SVCNames = $evnt.AffectedServiceHealthStatus
	$Status = $evnt.Status
	$StrTime = $evnt.starttime
	$UpTime = $evnt.LastUpdatedTime
	foreach($SVCName in $SVCNames)
	{
		$features = $SVCName.ServiceFeatureStatus
		foreach($feature in $features)
		{
			Write-Host($SVCName.ServiceName+"\"+$feature.FeatureName+";"+$ID+";"+$Title+";"+$Status+";"+$StrTime+";"+$UpTime)
		}
	}
}
[System.GC]::GetTotalMemory($true) | out-null


