$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$hostname = $env:COMPUTERNAME
$sessions = Get-XASession -ServerName $hostname
$wgs = get-xaworkergroup -servername $hostname
$dskinwgs = @{}
$dskWithSessions = @{}

foreach($wg in $wgs)
{
	$apps = Get-XAApplication -workergroupname $wg.workergroupname
	foreach( $app in $apps)
	{
		if($app.ApplicationType -eq "ServerDesktop")
		{
			$wgname = $wg.FolderPath +"\"+$wg.workergroupname
			$dname = $app.FolderPath +"/"+$app.BrowserName
			$dskinwgs.add($dname,$wgname)
		}
	}
}

$noResults = 1
if($? -and $sessions)
{
	foreach($session in $sessions)
	{
		if($session.Protocol -eq "Ica" -and $session.BrowserName)
		{
			$apps = Get-XAApplication -ServerName $hostname -SessionId $session.SessionId	
			foreach( $app in $apps)
			{
				if($app.ApplicationType -eq "ServerDesktop")
				{
					if($app.BrowserName -eq $session.BrowserName)
					{
						$dname = $app.FolderPath +"/"+$app.BrowserName
						if($dskinwgs.containskey($dname))
						{
							$wgname = $dskinwgs.get_item($dname)
							$dname = $dname + "^^"+$wgname
						}
						$dskWithSessions.add($dname,$dname)
						Write-Host($dname,$session.SessionName,$session.AccountName) -Separator ":"
					}
					$noResults = 0
				}
			}
		}
	}
}

if ($noResults -eq 0 -and $dskWithSessions)
{
	if($dskinwgs)
	{
		$keys = $dskinwgs.Keys
		foreach($key in $keys)
		{
			$value = $dskinwgs.get_item($key)
			$dname = $key + "^^"+$value
			if (!($dskWithSessions.containsKey($dname)))
			{
				write-host($dname,"","") -Separator ":"
			}
		}
	}

	$apps = Get-XAApplication -ServerName $hostname
	if($apps)
	{
		foreach( $app in $apps)
		{
			if($app.ApplicationType -eq "ServerDesktop")
			{
				$dname = $app.FolderPath +"/"+$app.BrowserName
				if(!($dskinwgs.containskey($dname)))
				{
					if (!($dskWithSessions.containskey($dname)))
					{
						write-host($dname,"","") -Separator ":"
					}
				}
			}
		}
	}
}

if($noResults -eq 1)
{
	if($dskinwgs)
	{
		$keys = $dskinwgs.Keys
		foreach($key in $keys)
		{
			$value = $dskinwgs.get_item($key)	
			$dname = $key + "^^"+$value
			write-host($dname,"","") -Separator ":"
		}
	}

	$apps = Get-XAApplication -ServerName $hostname
	if($apps)
	{
		foreach( $app in $apps)
		{
			if($app.ApplicationType -eq "ServerDesktop")
			{
				$dname = $app.FolderPath +"/"+$app.BrowserName
				if(!($dskinwgs.containskey($dname)))
				{
					Write-Host($dname,"","") -Separator ":"
				}
			}
		}
	}
}

Remove-PSSnapin Citrix.XenApp.Commands





