﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply Admin Server"
	break
}

$adminServer = $args[0]
$Global:ErrorActionPreference="SilentlyContinue"
$adminConn = New-XdAdminConnection -Name $adminServer

Write-Host "Farm"
Write-Host "-------"
$xenFarm = Get-XdFarm -AdminConnection $adminConn
Write-Host "Name" $xenFarm.Name -Separator ":"
Write-Host "LicenseServer" $xenFarm.LicenseServerName -Separator ":"
Write-Host "LicenseServerPort" $xenFarm.LicenseServerPort -Separator ":"

Write-Host "Controllers"
Write-Host "---------------"
$controllers = Get-XdController
if($controllers -ne $null)
{
	foreach($i in $controllers)
	{
		Write-Host "Name" $i.Name -Separator ":" 
	}
}
Write-Host "Desktop Groups"
Write-Host "---------------"
$dgroups = Get-XdDesktopGroup 
if($dgroups -ne $null)
{
	foreach ($i in $dgroups)
	{
		Write-Host($i.Name,$i.Enabled) -Separator ";" 
	}
}


Disconnect-XdAdminConnection -AdminConnection $adminConn






