﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-PSSnapin "XDCommands"
$xenFarm = Get-XdFarm
Write-Host "Farm"
Write-Host "-------"
Write-Host "Name" $xenFarm.Name -Separator ":"
Write-Host "LicenseServer" $xenFarm.LicenseServerName -Separator ":"
Write-Host "LicenseServerPort" $xenFarm.LicenseServerPort -Separator ":"

Write-Host "Controllers"
Write-Host "---------------"
$controllers = Get-XdController
if($controllers -ne $null)
{
	$hostname = $env:computername
	foreach($i in $controllers)
	{
		Write-Host($i.Name,$i.ZoneElectionPreference,$hostname) -Separator ";"
	}
}

Write-Host "Desktop Groups"
Write-Host "---------------"
$dgroups = Get-XdDesktopGroup
if($dgroups -ne $null)
{
	foreach ($i in $dgroups)
	{
		$hs = $i.HostingSettings.HostingServer
		if($i.Folder.Name -ne "\")
		{
			$temp = $i.Folder.Name + "\" + $i.Name
			Write-Host ($temp,$i.Id,$i.Enabled,$i.AssignmentBehavior,$hs.Address,$hs.User,$hs.Provider) -Separator ";"
		}
		else
		{
			Write-Host ($i.Name,$i.Id,$i.Enabled,$i.AssignmentBehavior,$hs.Address,$hs.User,$hs.Provider) -Separator ";"
		}
	}
}

Write-Host "Virtual Desktops"
Write-Host "-----------------"
$vds = Get-XdVirtualDesktop
if($vds -ne $null)
{
	foreach ($vd in $vds)
	{
		$vdPowerState = "-"
		$AssignmentBehavior = "-"
		$AssignedUserName = "-"
		if ($vd.PowerState.length -gt 0)
		{
			$vdPowerState = $vd.PowerState;
		}
		if ($vd.AssignedUserName.length -gt 0)
		{
			$AssignedUserName = $vd.AssignedUserName
		}
		Write-Host($vd.GroupId,$vd.Name,$vd.GroupName,$vd.State,$vdPowerState,$AssignmentBehavior,$vd.MaintenanceMode,$AssignedUserName,$vd.Controller) -Separator ";"
	}
}


Write-Host "Sessions"
Write-Host "--------"
$sessions = Get-XdSession
if($sessions -ne $null)
{
	foreach($session in $sessions)
	{
		$UserName = "Unknown"
		if ($session.UserName.length -gt 0)
		{
			$UserName = $session.UserName
		}
		Write-Host($session.GroupId,$session.DesktopName,$UserName,$session.State,$session.StartTime,$session.Controller) -Separator ";"
	}
}

Remove-PSSnapin "XDCommands"