$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"

function Convert-IniFile ($file) 
{ 
    $REGEX_INI_COMMENT_STRING = ";" 
    $REGEX_INI_SECTION_HEADER = "^\s*(?!$($REGEX_INI_COMMENT_STRING))\s*\[\s*(.*[^\s*])\s*]\s*$" 
    $REGEX_INI_KEY_VALUE_LINE = "^\s*(?!$($REGEX_INI_COMMENT_STRING))\s*([^=]*)\s*=\s*(.*)\s*$"

    $ini = @{} 
    switch -regex -file $file { 
        "$($REGEX_INI_SECTION_HEADER)" { 
            $section = $matches[1] 
            $ini[$section] = @{} 
        } 
        "$($REGEX_INI_KEY_VALUE_LINE)" { 
            $name,$value = $matches[1..2] 
            if ($name -ne $null -and $section -ne $null) 
            { 
                $ini[$section][$name] = $value 
            } 
        } 
    } 
    $ini 
}


# Get list of xenapp servers
Write-Host "[Citrix_server]"
$Servers = Get-XAServer -EA 0 | sort-object FolderPath, ServerName 
If($? -and $Servers)
{
	foreach($Server in $Servers)
	{
		Write-Host $Server.ServerName "=" $Server.IPAddresses
	}
}
Write-Host "[Citrix_XP_farm]"
$Zones = Get-XAZone -EA 0 | sort-object ZoneName
if($? -and $Zones)
{
	foreach($Zone in $Zones)
	{
		$ips = @(([net.dns]::GetHostEntry($Zone.DataCollector)).AddressList)
		$tips = ""
		$count = 0
		if($? -and $ips)
		{
			foreach($ip in $ips)
			{
				if($ip.AddressFamily -eq "InterNetwork")
				{
					if($count -eq 0)
					{
						$tips = $ip.IPAddressToString
					}
					else
					{
						$tips = $tips + ","+ $ip.IPAddressToString
					}
					$count = $count + 1
				}	
			}	
			Write-Host $Zone.DataCollector "=" $tips
		}			
	}

}
$ips = @{}
$count = 0
$tips = ""
$hostname = $env:COMPUTERNAME
$server = Get-XAServer -ServerName $hostname
Write-Host "[IMA Data Store]"
$imaFolder = $server.CitrixInstallPath +"Independent Management Architecture\MF20.dsn"
if(Test-Path $imaFolder)
{
	$iniFile = Convert-IniFile $imaFolder
	$db = $iniFile["ODBC"]["DRIVER"]
	if($db -eq "SQL Server")
	{
		$address = $iniFile["ODBC"]["ADDRESS"]
		if($address -ne $null)
		{
			Write-Host $address
		}
		else
		{
			$dbserver = $iniFile["ODBC"]["SERVER"]
			if($dbserver -ne $null)
			{
				$data = $dbserver.split("\")
				if($data[0] -eq "(local)")
				{
					$ip = (Get-WmiObject -class win32_NetworkAdapterConfiguration -Filter 'ipenabled = "true"').ipaddress[0]
					Write-Host $hostname "=" $ip
				}
				else
				{
					$ips = @(([net.dns]::GetHostEntry($data[0])).AddressList)
					$tips = ""
					$count = 0
					if($? -and $ips)
					{
						foreach($ip in $ips)
						{
							if($ip.AddressFamily -eq "InterNetwork")
							{
								if($count -eq 0)
								{
									$tips = $ip.IPAddressToString
								}
								else
								{
									$tips = $tips + "," +  $ip.IPAddressToString
								}
								$count = $count + 1
							}	
						}	
						Write-Host $data[0] "=" $tips
					}	
				}
			}
			else
			{
				Write-Host "-"
			}
		}	
	}
}
Write-Host "[Citrix_license_server]"
$ips = @(([net.dns]::GetHostEntry($server.LicenseServerName)).AddressList)
$tips = ""
$count = 0
if($? -and $ips)
{
	foreach($ip in $ips)
	{
		if($ip.AddressFamily -eq "InterNetwork")
		{
			if($count -eq 0)
			{
				$tips = $ip.IPAddressToString
			}
			else
			{
				$tips = $tips + "," + $ip.IPAddressToString
			}
			$count = $count + 1
		}	
		
	}	
	Write-Host $server.LicenseServerName "=" $tips
}	
$ips = @{}
$count = 0
$tips = ""
Write-Host "[ActiveDirectory_server]"
$dcs = @([System.DirectoryServices.ActiveDirectory.Domain]::getComputerDomain().DomainControllers)
if($? -and $dcs)
{
	foreach($dc in $dcs)
	{
		Write-Host $dc.Name "=" $dc.IPAddress
	}

}

Write-Host "[Citrix_WorkerGroups]"
$WorkerGroups = Get-XAWorkerGroup -EA 0
if($WorkerGroups)
{
		foreach($WG in $WorkerGroups)
		{
			$WGName = $WG.WorkerGroupName
			$WGServers = $WG.ServerNames
			foreach($WGServer in $WGServers)
			{
				$Server1 = Get-XAServer -ServerName $WGServer -EA 0
				if($? -and $Server1)
				{
					$Output = $WGName +"=" + $Server1.ServerName + "^^" + $Server1.IPAddresses
					Write-Host $Output
				}
			}
			
		}
}	
Remove-PSSnapin Citrix.XenApp.Commands


