$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"

$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply measurement period"
	break
}

$measurePeriod = $args[0]
$logs = Get-MessageTrackingLog -Start (Get-Date).AddSeconds(-$measurePeriod) -End (Get-Date) -ResultSize Unlimited
#Write-Host Get-MessageTrackingLog -Start (Get-Date).AddSeconds(-$measurePeriod) -End (Get-Date) -ResultSize Unlimited

if($logs)
{
	foreach($log in $logs)
	{
		if($log.RecipientCount -gt 0)
		{
			$Recipients = ($log.Recipients) -join ","
		}
		else
		{
			$Recipients = "-"
		}
		$CientIP = "-"
		$ServerIP = "-"
		if ($log.ClientIp -ne $null -and $log.ClientIp.length -gt 0)
		{
			$CientIP = $log.ClientIp
		}
		if ($log.ServerIp -ne $null -and $log.ServerIp.length -gt 0)
		{
			$ServerIP = $log.ServerIp
		}
		$MessageSubject = "-"
		if ($log.MessageSubject -ne $null -and $log.MessageSubject.length -gt 0)
		{
			$MessageSubject = $log.MessageSubject
		}

		if($log.Recipientstatus -ne $null -and $log.Recipientstatus.length -gt 0)
		{
			$Recipientstatus = ($log.Recipientstatus) -join ","
		}
		else
		{
			$Recipientstatus = "-"
		}
		$MsgLatency = 0
		if ($log.MessageLatency -ne $null)
		{
			$MsgLatency = $log.MessageLatency.TotalMilliSeconds
		}
		Write-host $log.timestamp,$CientIP,$ServerIP,$log.Source,$log.EventId,$log.Sender,$Recipients,$log.RecipientCount,$log.TotalBytes,$MessageSubject,$Recipientstatus,$MsgLatency -separator "#~#"
	}
}



