$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
$dbs = Get-MailboxDatabase -Server $env:computername -Status
foreach($db in $dbs)
{
	$mxcount = (Get-Mailbox -Database $db.name -resultsize unlimited).Count
	$fspace  = $db.AvailableNewMailboxSpace.ToMB()
	$size 	 = $db.DatabaseSize.ToMB()
	$name	 = $db.Identity
    $wpid    = $db.WorkerProcessId
    $mounted = $db.Mounted
    $edbpath = $db.EdbFilePath
    #Write-Host "EDB path:" ($edbpath)
    $replicationtype = $db.ReplicationType
    $backupinprogress = $db.BackupInProgress
    $mountedonserver = $db.MountedOnServer
    $rpcclientaccesssvr = $db.RpcClientAccessServer
    
    Write-Host ($name,$size,$fspace,$mounted,$mxcount,$backupinprogress,$replicationtype,$edbpath,$mountedonserver,$wpid,$rpcclientaccesssvr) -Separator ";"
	
}
Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn