# This Script will give all details of XenDesktop for Discovery
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-pssnapin "Citrix.Common.Commands"
Add-pssnapin "Citrix.Host.Admin.V2"
Add-pssnapin "Citrix.Broker.Admin.V2"
<#
Function Get-BrokerMachinesPaged
{
    param (
    $MachineName,
    $AgentVersion,
    $AllocationType,
    $ApplicationInUse,
    $AssignedClientName,
    $AssignedIPAddress,
    $AssociatedUserFullName,
    $AssociatedUserName,
    $AssociatedUserSID,
    $AssociatedUserUPN,
    $BrowserName,
    $CatalogName,
    $CatalogUid,
    $CatalogUUID,
    $ColorDepth,
    $ControllerDNSName,
    $DeliveryType,
    $Description,
    $DesktopCondition,
    $DesktopGroupName,
    $DesktopGroupUid,
    $DesktopGroupUUID,
    $DesktopKind,
    $DesktopUid,
    $DNSName,
    $FaultState,
    $FunctionalLevel,
    $HostedMachineId,
    $HostedMachineName,
    $HostingServerName,
    $HypervisorConnectionName,
    $HypervisorConnectionUid,
    $HypHypervisorConnectionUid,
    $IconUid,
    $ImageOutOfDate,
    $InMaintenanceMode,
    $IPAddress,
    $IsAssigned,
    $IsPhysical,
    $LastConnectionFailure,
    $LastConnectionTime,
    $LastConnectionUser,
    $LastDeregistrationReason,
    $LastDeregistrationTime,
    $LastErrorReason,
    $LastErrorTime,
    $LastHostingUpdateTime,
    $LastPvdErrorReason,
    $LastPvdErrorTime,
    $LoadIndex,
    $MachineInternalState,
    $Metadata,
    $OSType,
    $OSVersion,
    $PersistUserChanges,
    $PowerActionPending,
    $PowerState,
    $ProvisioningType,
    $PublishedApplication,
    $PublishedName,
    $PvdEstimatedCompletionTime,
    $PvdPercentDone,
    $PvdStage,
    $PvdUpdateStartTime,
    $RegistrationState,
    $ScheduledReboot,
    $SecureIcaRequired,
    $SessionAutonomouslyBrokered,
    $SessionClientAddress,
    $SessionClientName,
    $SessionClientVersion,
    $SessionConnectedViaHostName,
    $SessionConnectedViaIP,
    $SessionCount,
    $SessionDeviceId,
    $SessionHardwareId,
    $SessionHidden,
    $SessionKey,
    $SessionLaunchedViaHostName,
    $SessionLaunchedViaIP,
    $SessionProtocol,
    $SessionSecureIcaActive,
    $SessionsEstablished,
    $SessionSmartAccessTag,
    $SessionsPending,
    $SessionStartTime,
    $SessionState,
    $SessionStateChangeTime,
    $SessionSupport,
    $SessionType,
    $SessionUid,
    $SessionUserName,
    $SessionUserSID,
    $SID,
    $SummaryState,
    $SupportedPowerActions,
    $Tag,
    $UUID,
    $VMToolsState,
    $WillShutdownAfterUse,
    $WindowsConnectionSetting,
    $AssignedUserSID,
    $AdminAddress,
    $MaxRecordCount = 250
    )

    $argumentList = $PSBoundParameters
    $argumentList.Add("SortBy", "MachineName")
    $desktops = @()
    $desktops += Get-BrokerMachine -ReturnTotalRecordCount:$true -ErrorVariable RecordCount -ErrorAction SilentlyContinue @argumentList
    $total = $RecordCount.TotalAvailableResultCount
    while ($RecordCount.TotalAvailableResultCount -gt $MaxRecordCount)
    {
        $remainingPerc= [math]::round($desktops.count / $total * 100, 1)
        #Write-Host  "Getting Broker Machines. Retrieved $($desktops.count) of $total machines completed in $remainingPerc%"
        $last = $desktops[-1].MachineName
        $desktops += Get-BrokerMachine -ReturnTotalRecordCount:$true -ErrorVariable RecordCount -ErrorAction SilentlyContinue -Filter { MachineName -gt $last } @argumentList
    }
     
    return $desktops
}
#>

Function Get-BrokerMachinesPaged
{
    param (
    $MachineName,
    $AgentVersion,
    $AllocationType,
    $ApplicationInUse,
    $AssignedClientName,
    $AssignedIPAddress,
    $AssociatedUserFullName,
    $AssociatedUserName,
    $AssociatedUserSID,
    $AssociatedUserUPN,
    $BrowserName,
    $CatalogName,
    $CatalogUid,
    $CatalogUUID,
    $ColorDepth,
    $ControllerDNSName,
    $DeliveryType,
    $Description,
    $DesktopCondition,
    $DesktopGroupName,
    $DesktopGroupUid,
    $DesktopGroupUUID,
    $DesktopKind,
    $DesktopUid,
    $DNSName,
    $FaultState,
    $FunctionalLevel,
    $HostedMachineId,
    $HostedMachineName,
    $HostingServerName,
    $HypervisorConnectionName,
    $HypervisorConnectionUid,
    $HypHypervisorConnectionUid,
    $IconUid,
    $ImageOutOfDate,
    $InMaintenanceMode,
    $IPAddress,
    $IsAssigned,
    $IsPhysical,
    $LastConnectionFailure,
    $LastConnectionTime,
    $LastConnectionUser,
    $LastDeregistrationReason,
    $LastDeregistrationTime,
    $LastErrorReason,
    $LastErrorTime,
    $LastHostingUpdateTime,
    $LastPvdErrorReason,
    $LastPvdErrorTime,
    $LoadIndex,
    $MachineInternalState,
    $Metadata,
    $OSType,
    $OSVersion,
    $PersistUserChanges,
    $PowerActionPending,
    $PowerState,
    $ProvisioningType,
    $PublishedApplication,
    $PublishedName,
    $PvdEstimatedCompletionTime,
    $PvdPercentDone,
    $PvdStage,
    $PvdUpdateStartTime,
    $RegistrationState,
    $ScheduledReboot,
    $SecureIcaRequired,
    $SessionAutonomouslyBrokered,
    $SessionClientAddress,
    $SessionClientName,
    $SessionClientVersion,
    $SessionConnectedViaHostName,
    $SessionConnectedViaIP,
    $SessionCount,
    $SessionDeviceId,
    $SessionHardwareId,
    $SessionHidden,
    $SessionKey,
    $SessionLaunchedViaHostName,
    $SessionLaunchedViaIP,
    $SessionProtocol,
    $SessionSecureIcaActive,
    $SessionsEstablished,
    $SessionSmartAccessTag,
    $SessionsPending,
    $SessionStartTime,
    $SessionState,
    $SessionStateChangeTime,
    $SessionSupport,
    $SessionType,
    $SessionUid,
    $SessionUserName,
    $SessionUserSID,
    $SID,
    $SummaryState,
    $SupportedPowerActions,
    $Tag,
    $UUID,
    $VMToolsState,
    $WillShutdownAfterUse,
    $WindowsConnectionSetting,
    $AssignedUserSID,
    $AdminAddress,
    $MaxRecordCount = 250
    )

	$argumentList = $PSBoundParameters
	$argumentList.Add("SortBy", "Uid")
	$desktops = @()
	$LastUid = 0;
	do
	{
		$NewDesktops = @(Get-BrokerMachine -MaxRecordCount $MaxRecordCount -ErrorAction SilentlyContinue -Filter {Uid -gt $LastUid} @argumentList)
		if ($NewDesktops.Count -gt 0)
		{
			$desktops += $NewDesktops
			$LastUid = $desktops[-1].Uid
		}
	} while ($NewDesktops.Count -ge $MaxRecordCount)
	return $desktops
}

Write-Host "[License_server]"
$ips = @{}
$count = 0
$tips = ""
$Site = Get-BrokerSite
$SiteName=""
if ($Site -ne $null)
{
    $SiteName = $Site.Name
    $ips = @(([net.dns]::GetHostEntry($Site.LicenseServerName)).AddressList)
	$tips = ""
	$count = 0
	if($? -and $ips)
	{
	    foreach($ip in $ips)
		{
			if($ip.AddressFamily -eq "InterNetwork")
			{
				if($count -eq 0)
				{
					$tips = $ip.IPAddressToString +":"+$Site.LicenseServerPort
				}
				else
				{
					$tips = $tips + "," + $ip.IPAddressToString+":"+$Site.LicenseServerPort
				}
				$count = $count + 1
			}	
		
		}	
		Write-Host $Site.LicenseServerName "=" $tips
	}	
}
$ips = @{}
$count = 0
$tips = ""

Write-Host "[Controllers]"
$Controllers = Get-BrokerController
$BrokerToHypIDs = @{}
if($Controllers -ne $null)
{
	foreach($Controller in $Controllers)
	{
		#Write-Host($Controller.DNSName)
		$ips = @(([net.dns]::GetHostEntry($Controller.DNSName)).AddressList)
		$tips = ""
		$count = 0
		if($? -and $ips)
		{
			foreach($ip in $ips)
			{
				if($ip.AddressFamily -eq "InterNetwork")
				{
					if($count -eq 0)
					{
						$tips = $ip.IPAddressToString
					}
					else
					{
						$tips = $tips + "," + $ip.IPAddressToString
					}
					$count = $count + 1
				}	
			
			}	
			Write-Host $Controller.DNSName "=" $tips
                    
      	}
        $AssociatedHypervisorConnectionUids = $Controller.AssociatedHypervisorConnectionUids
        if($AssociatedHypervisorConnectionUids -ne $null)
        {
            $BrokerToHypIDs[$controller.DNSName] = $AssociatedHypervisorConnectionUids
        }	
	}
}
$ips = @{}
$count = 0
$tips = ""


Write-Host "[Hypervisor_Details]"
$BrokerHypConns = Get-BrokerHypervisorConnection -State On
$HypConnsToBroker = @{}
if($BrokerHypConns -ne $null)
{
    foreach($BrokerHypConn in $BrokerHypConns)
    {
        $Value = $BrokerHypConn.HypHypervisorConnectionUid
        $Key = $BrokerHypConn.Uid
        $HypConnsToBroker[$Key] = $Value
    }
}

$HypConns = @{}
$HypConnPath = "XDHyp:\Connections\"
$HypConnections = Get-ChildItem $HypConnPath
if ($HypConnections -ne $null)
{
	foreach ($HypConn in $HypConnections)
	{
        $Key1 = $HypConn.HypervisorConnectionUid
        $Value1 = $HypConn.ConnectionType.toString() + ";" + $HypConn.HypervisorAddress[0].toString()
        $HypConns[$Key1] = $Value1
	}
}
if($BrokerToHypIDs -ne $null)
{
    $Keys = $BrokerToHypIDs.Keys
    foreach($key2 in $keys)
    {
        $Values = $BrokerToHypIDs[$key2]
        if($Values.Count -ge 1)
        {
            foreach($Value in $Values)
            {
                $hypuobj = Get-BrokerHypervisorConnection -Uid $Value 
                if($hypuobj)
                {
                    $hypuid = $hypuobj.HypHypervisorConnectionUid  
                    $output = $HypConns[$hypuid]
                    $outputStr = $key2.toString() + "=" + $output
                    Write-Host $outputStr
                }
            }
        }

    }
}

Write-Host "[Hypervisor_Type]"
#Support XenServer only
$HypConnPath = "XDHyp:\Connections\"
$HypConnections = Get-ChildItem $HypConnPath
if ($HypConnections -ne $null)
{
	foreach ($HypConn in $HypConnections)
	{
	        $ConnUid = $HypConn.HypervisorConnectionUid
		$Value1 = $HypConn.ConnectionType.toString() + ";" + $HypConn.HypervisorAddress[0].toString()
		if ($HypConn.ConnectionType.toString() -ieq "XenServer")
		{
			$machines = Get-BrokerMachinesPaged -SessionSupport 'MultiSession' -HypHypervisorConnectionUid $ConnUid
			if ($machines -ne $null)
			{
				Write-Host $Value1"=Server"
			}
			else
			{	
				Write-Host $Value1"=VDI"
			}
		}
        elseif ($HypConn.ConnectionType.toString() -ieq "vcenter")
        {
                Write-Host $Value1"=vCenter"
        }
	}
}

Write-Host "[DataSource]"
$DataSource = Get-BrokerDBConnection
if ($DataSource -ne $null)
{
	Write-Host ($DataSource)
}


$ips = @{}
$count = 0
$tips = ""
Write-Host "[ActiveDirectory_server]"

$d =  (gwmi win32_computersystem).domain
$ips = @(([net.dns]::GetHostEntry($d)).AddressList) 
if($? -and $ips)
{
	foreach($ip in $ips)
	{
		if($ip.AddressFamily -eq "InterNetwork")
		{
			if($count -eq 0)
			{
				$tips = $ip.IPAddressToString
			}
			else
			{
				$tips = $tips +","+ $ip.IPAddressToString
			}
			$count = $count + 1
		}	
		
	}
	Write-Host $d "=" $tips
}	

$ips = ""
$tips = ""
Write-Host "[XenApp]"
$XenApps = Get-BrokerMachinesPaged -SessionSupport MultiSession | Select DNSName,IPAddress,ControllerDNSName,DesktopGroupName
if($XenApps -ne $null)
{
	foreach($XenApp in $XenApps)
	{
		$tips = ""
		$count = 0
		$ips = $XenApp.IPAddress
		if($? -and $ips)
		{
			Write-Host $XenApp.ControllerDNSName  "^^"  $XenApp.DNSName "^^" $XenApp.DesktopGroupName "="   $ips
		}
		else
		{
			$ips = @(([net.dns]::GetHostEntry($XenApp.DNSName)).AddressList)
			if($? -and $ips)
			{
				foreach($ip in $ips)
				{
					if($ip.AddressFamily -eq "InterNetwork")
					{
						if($count -eq 0)
						{
							$tips = $ip.IPAddressToString
						}
						else
						{
							$tips = $tips +","+ $ip.IPAddressToString
						}
						$count = $count + 1
					}
				}
			}

			If ($XenApp.ControllerDNSName -ne $null -and $XenApp.ControllerDNSName.length -gt 0)
			{
				Write-Host $XenApp.ControllerDNSName  "^^"  $XenApp.DNSName "^^" $XenApp.DesktopGroupName "="   $tips 	
			}
			else
			{
				Write-Host "-^^"  $XenApp.DNSName "^^" $XenApp.DesktopGroupName "="   $tips	
			}
		}
	}
}

Write-Host "[PVS]"
$PVSIPAddresses = @()
$Catalogs = Get-BrokerCatalog -MaxRecordCount 2147483647
if($Catalogs -ne $null)
{
	foreach($Catalog in $Catalogs)
	{
		if ($Catalog.PvsAddress.length -gt 0)
		{
			$PvsAddress = $Catalog.PvsAddress
			if($PVSIPAddresses -Contains $PvsAddress)
			{
			}
			else
			{
				$PVSIPAddresses += $PvsAddress
			}
		}
	}
	Write-Host $PVSIPAddresses
}

Write-Host "[XD_Site]"
if ( $SiteName.Length -gt 0)
{
    $objIPProperties = [System.Net.NetworkInformation.IPGlobalProperties]::GetIPGlobalProperties()
    $fqdn = "{0}.{1}" -f $SiteName, $objIPProperties.DomainName
    $ips = ""
    $ips = @(([net.dns]::GetHostEntry($env:COMPUTERNAME)).AddressList)
    $tips = ""
    $count = 0
    if($? -and $ips)
    {
	    foreach($ip in $ips)
        {
	        if($ip.AddressFamily -eq "InterNetwork")
	        {
		        if($count -eq 0)
		        {
			        $tips = $ip.IPAddressToString +":80"
		        }
		        else
		        {
			        $tips = $tips + "," + $ip.IPAddressToString+":80"
		        }
		        $count = $count + 1
	        }	

        }	
        Write-Host $fqdn "=" $tips
    }
}

Remove-pssnapin "Citrix.Common.Commands"
Remove-pssnapin "Citrix.Host.Admin.V2"
Remove-pssnapin "Citrix.Broker.Admin.V2"


