$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
$stats = Get-MailboxStatistics -Server $env:computername
foreach($stat in $stats)
{
	$LastLogonTime = "-"
	if ($stat.LastLogonTime -ne $null)
	{
		$LastLogonTime = $stat.LastLogonTime 
	}
	Write-Host ($stat.DatabaseName,$stat.DisplayName,$LastLogonTime, $stat.ItemCount) -Separator ";"
}
Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn