﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"

$Teams = Get-NetLbfoTeam
if ($Teams -ne $null)
{
    foreach ($Team in $Teams)
    {
        $TeamName = $Team.Name 
        $TeamStatus =$Team.Status
        $TeamNics = Get-NetLbfoTeamNic -Name $TeamName
        if ($TeamNics -ne $null)
        {
            foreach ($TeamNic in $TeamNics)
            {
                Write-Host($TeamName,$TeamStatus,$TeamNic.InterfaceDescription) -Separator "^@^"
            }
        }
        $TeamMembers = Get-NetLbfoTeamMember -Team $TeamName
        if($TeamMembers -ne $nulll)
        {
            foreach($Member in $TeamMembers)
            {
                Write-Host ("Member=",$TeamName, $Member.Name, $Member.OperationalStatus, $Member.FailureReason,$Member.InterfaceDescription) -Separator "^@^"
            }
        }
     }
}
