$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$records = @()
$viewConnBroker = $env:computername
$ou="Servers"
$ldaproot = "LDAP://$($viewConnBroker)/OU=$($ou),DC=vdi,DC=vmware,DC=int"
$tmpObj = New-Object System.DirectoryServices.DirectoryEntry($ldaproot)
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $tmpObj
$selector.PageSize = 1000
$records = $Selector.FindAll() | where {$_.Properties.objectcategory -match "CN=pae-VM"}
$count = 0
if($records -ne $null)
{
	foreach ($record in $records)
	{
		$count = $count + 1
	}

	Write-Host "Total number of desktops = " $count
	foreach ($record in $records)
	{
		$attribute = $record.Properties
		$p1 = 'pae-displayname'
		$value1 = $attribute.$p1
		$p2 = 'pae-vmstate'
		$value2 = $attribute.$p2
		$p3 = 'pae-vmpath'
		$value3 = $attribute.$p3
		$p4 = 'pae-memberdnof'
		$value4 = $attribute.$p4
		$p5 = 'pae-dirtyfornewsessions'
		$value5 = $attribute.$p5
		if($value5 -eq $null)
		{
			$value5 = 0
		}
		$p6 = 'cn'
		$value6 = $attribute.$p6
		Write-Host($value1,$value2,$value3,$value4,$value5,$value6) -separator ";"
		
	
	}
}
else
{
	Write-Host "Total number of desktops = " $count
}

