<#
	EXAMPLE
	VeeamRepStats.ps1 -BRHost veeam01.lan.local
	#Requires -Modules VeeamPSSnapIn
#>

[cmdletbinding()]

param(
	[Parameter(Position=0, Mandatory=$false)]
	[string] $BRHost = ".",
	[Parameter(Position=1, Mandatory=$false)]
	$reportMode = "24" # Weekly, Monthly as String or Hour as Integer
)

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

if (!(Get-PSSnapin -Name VeeamPSSnapIn -ErrorAction SilentlyContinue)) {
	if (!(Add-PSSnapin -PassThru VeeamPSSnapIn -ErrorAction SilentlyContinue)) {
		# Error out if loading fails
		Write-Host "ERROR: Cannot load the VEEAM Snapin."
		Exit
	}
}

Try {
	Connect-VBRServer -server $BRHost -ErrorAction Stop
}
Catch {
	Write-Host "Unable to connect to VBR server - $BRHost" 
	exit
}

$HourstoCheck = $reportMode

# Get all Sessions (Backup/BackupCopy/Replica)
$allSesh = Get-VBRBackupSession 

# Gather all Replication sessions within timeframe
$seshListRepl = @($allSess | ?{($_.EndTime -ge (Get-Date).AddHours(-$HourstoCheck) -or $_.CreationTime -ge (Get-Date).AddHours(-$HourstoCheck) -or $_.State -eq "Working") -and $_.JobType -eq "Replica"})

# Preparing Replication Session Reports

$totalXferRp = 0
$totalReadRp = 0
$seshListRepl | %{$totalxferBk += $([Math]::Round([Decimal]$_.Progress.TransferedSize/1GB, 0))}
$seshListRepl | %{$totalReadBk += $([Math]::Round([Decimal]$_.Progress.ReadSize/1GB, 0))}
$successSessionsRepl = @($seshListRepl | ?{$_.Result -eq "Success"})
$warningSessionsRepl = @($seshListRepl | ?{$_.Result -eq "Warning"})
$failsSessionsRepl = @($seshListRepl | ?{$_.Result -eq "Failed"})
$runningSessionsRepl = @($allSesh | ?{$_.State -eq "Working"})
$failedSessionsRepl = @($seshListRepl | ?{($_.Result -eq "Failed") -and ($_.WillBeRetried -ne "True")})

$SessionObject = [PSCustomObject] @{
	"Successful Replications" = $successSessionsRepl.Count
	"Warning Replications" = $warningSessionsRepl.Count
	"Failes Replications" = $failsSessionsRepl.Count
	"Failed Replications" = $failedSessionsRepl.Count
	"Running Replications" = $runningSessionsRepl.Count
	"Total Backup Transfer" = $totalxferBk
	"Total Backup Read" = $totalReadBk
	"Sessions" = If ($seshListRepl) {@($seshListRepl).Count} Else {0}
}

$SessionObject


