$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#Load VMware View Snapin to powershell v2 - Starts

Set-Variable product_name "VMware View PowerCLI" -scope Private
Set-Variable view_snapin_name "VMware.View.Broker" -scope Private
$ViewSnapinLoaded = Get-PSSnapin | Where { $_.Name -eq $view_snapin_name }
if(!$ViewSnapinLoaded)
{
	# Install or Re-register View Cmdlets
	$installpath = (get-itemproperty "HKLM:\Software\VMware, Inc.\VMware VDM").ServerInstallPath
	$BuildVersion = (get-itemproperty "HKLM:\Software\VMware, Inc.\VMware VDM").BuildNumber
	$os=Get-WMIObject win32_operatingsystem | select OSArchitecture
	if ($os.OSArchitecture -like "64*")
	{
		$path="$env:windir\Microsoft.NET\Framework64\v2.0.50727\installUtil.exe"
        if(![System.IO.File]::Exists($path))
		{             
			$path="$env:windir\Microsoft.NET\Framework64\v4.0.30319\installUtil.exe"
			if(![System.IO.File]::Exists($path))
			{
     			Write-Host "Either .NET v2 or v4 frameworks are not installed"
				return
			}
		}
	}
	else
	{
		$path="$env:windir\Microsoft.NET\Framework\v2.0.50727\installUtil.exe"
		if(![System.IO.File]::Exists($path))
		{ 
			$path="$env:windir\Microsoft.NET\Framework\v4.0.30319\installUtil.exe"
			if(![System.IO.File]::Exists($path))
			{
				Write-Host "Either .NET v2 or v4 frameworks are not installed"
				return
			}
		}
	}
	set-alias installUtil $path
	$null = (installUtil ($installpath  + "\bin\PowershellServiceCmdlets.dll"))
}

Remove-Variable product_name -scope Private
Remove-Variable view_snapin_name -scope Private

#Load VMware View Snapin to powershell v2 - Ends


Add-pssnapin "VMware.View.Broker"
#$Global:ErrorActionPreference="SilentlyContinue"
$hostname = $env:computername
$hostname = "DomainMonitor." + $hostname
$LDAPPath = 'LDAP://localhost:389/OU=Servers,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry

$LDAPPath1 = 'LDAP://localhost:389/OU=Server Groups,DC=vdi,DC=vmware,DC=int'
$LDAPEntry1 = New-Object DirectoryServices.DirectoryEntry $LDAPPath1
$Selector1 = New-Object DirectoryServices.DirectorySearcher
$Selector1.SearchRoot = $LDAPEntry1

Write-Host "Connection Brokers"
Write-Host "-------------------"
$connBrokers = Get-ConnectionBroker  | select broker_id,activation,lastBackup,ldapBackupFrequency
if($connBrokers -ne $null)
{
	foreach($connBroker in $connBrokers)
	{
		Write-Host ($connBroker.broker_id,$connBroker.activation,
		$connBroker.lastBackup,$connBroker.ldapBackupFrequency ) -Separator "#"
	}
}
else
{
	Write-Host "- #"  -nonewline;
}

$VCs = @{}
$LDAPPath2 = 'LDAP://localhost:389/OU=VirtualCenter,OU=Properties,DC=vdi,DC=vmware,DC=int'
$LDAPEntry2 = New-Object DirectoryServices.DirectoryEntry $LDAPPath2
$Selector2 = New-Object DirectoryServices.DirectorySearcher
$Selector2.SearchRoot = $LDAPEntry2
$Selector2.Filter = "(objectClass=pae-VirtualCenter)"
$VCData = $Selector2.FindAll()
foreach($VC in $VCData)
{
    $attribute = $VC.Properties
	$dn = $attribute.'distinguishedname'
    $vcurl = $attribute.'pae-vcurl'
    $dnStr = [String]$dn
    $VCs.Add($dnStr.Trim(),$vcurl)    
}
$LDAPEntry2.Close()
$VCs.Keys

Write-Host 

Write-Host "Domain monitor"
Write-Host "---------------"
$domains = Get-Monitor -monitor DomainMonitor -monitor_id $env:computername
if($domains -ne $null)
{
	write-host($domains.domains)
}

Write-Host 

Write-Host "VC monitor"
Write-Host "-----------"
$vcs = Get-Monitor -monitor VCMonitor
if($vcs -ne $null)
{
	foreach($vc in $vcs)
	{
		Write-Host ($vc.URL,$vc.State) -Separator "^"
	}
}
Write-Host

Write-Host "DB monitor"
Write-Host "-------------"

$db = Get-monitor -monitor DBMonitor
Write-Host ($db.Server,$db.DBName,$db.State) -Separator "#"

Write-Host

Write-Host "License"
Write-Host "---------"

$license = Get-license
$license | fl

Write-Host

Remove-Pssnapin "VMware.View.Broker"
