$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

function Get-ViewAPIService
{
	param(
	[Parameter(Mandatory = $false)]
	$HvServer
	)
	if ($null -ne $hvServer)
	{
		if ($hvServer.GetType().name -ne 'ViewServerImpl')
		{
			$type = $hvServer.GetType().name
			Write-Error "Expected hvServer type is ViewServerImpl, but received: [$type]"
			return $null
		}
		elseif ($hvServer.IsConnected)
		{
			return $hvServer.ExtensionData
		}
	} elseif ($global:DefaultHVServers.Length -gt 0)
	{
		$hvServer = $global:DefaultHVServers[0]
		return $hvServer.ExtensionData
	}
	return $null
}

#Load VMware View Snapin to powershell v2 - Starts
[string]$eGInstallDir = $args[0]
$vmhelper = "VMware.HV.Helper.psm1"
$moduleStr = $eGInstallDir+"\"+$vmhelper

Set-Variable product_name "VMware View PowerCLI" -scope Private
Set-Variable view_snapin_name "VMware.View.Broker" -scope Private
$ViewSnapinLoaded = Get-PSSnapin | Where { $_.Name -eq $view_snapin_name }
if(!$ViewSnapinLoaded)
{
	# Install or Re-register View Cmdlets
	$installpath = (get-itemproperty "HKLM:\Software\VMware, Inc.\VMware VDM").ServerInstallPath
	$BuildVersion = (get-itemproperty "HKLM:\Software\VMware, Inc.\VMware VDM").BuildNumber
	$os=Get-WMIObject win32_operatingsystem | select OSArchitecture
	if ($os.OSArchitecture -like "64*")
	{
		$path="$env:windir\Microsoft.NET\Framework64\v2.0.50727\installUtil.exe"
		if(![System.IO.File]::Exists($path))
		{
			$path="$env:windir\Microsoft.NET\Framework64\v4.0.30319\installUtil.exe"
			if(![System.IO.File]::Exists($path))
			{
				Write-Host "Either .NET v2 or v4 frameworks are not installed"
				return
			}
		}
	}
	else
	{
		$path="$env:windir\Microsoft.NET\Framework\v2.0.50727\installUtil.exe"
		if(![System.IO.File]::Exists($path))
		{
			$path="$env:windir\Microsoft.NET\Framework\v4.0.30319\installUtil.exe"
			if(![System.IO.File]::Exists($path))
			{
				Write-Host "Either .NET v2 or v4 frameworks are not installed"
				return
			}
		}
	}
	set-alias installUtil $path
	$null = (installUtil ($installpath  + "\bin\PowershellServiceCmdlets.dll"))
}

Remove-Variable product_name -scope Private
Remove-Variable view_snapin_name -scope Private

#Load VMware View Snapin to powershell v2 - Ends

Add-pssnapin "VMware.View.Broker"
Import-Module -Name VMware.VimAutomation.HorizonView -EA SilentlyContinue
Import-Module -Name $moduleStr -Force -EA SilentlyContinue

$hzUser = $args[1]
$hzPass = $args[2]
$DirPath = $eGInstallDir + "\OE.exe"
& $DirPath $hzPass | Tee-Object -Variable pwd | Out-Null
$hzDomain = $args[3]
[string]$hzConnStr = $args[4]

$Global:ErrorActionPreference="SilentlyContinue"
Set-PowerCLIConfiguration -Scope User -ParticipateInCEIP $false -confirm:$false |out-null
Set-PowerCLIConfiguration -InvalidCertificateAction Ignore -confirm:$false |out-null

try
{
	# Establish connection to Connection Server
	$hvServer = Connect-HVServer -Server $hzConnStr -User $hzUser -Password $pwd -Domain $hzDomain
}
catch
{
	write-host "Not able to connect to the server $hzConnStr".
	Write-host $_.Exception.Message
	return
}

$Global:hvServices = $hvServer.ExtensionData
$services = Get-ViewAPIService -hvServer $hvServer
$vc_service_helper = New-Object VMware.Hv.VirtualCenterService
$vcList = $vc_service_helper.VirtualCenter_List($services)

cls

$hostname = $env:computername
$hostname = "DomainMonitor." + $hostname
$LDAPPath = 'LDAP://localhost:389/OU=Servers,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry

$LDAPPath1 = 'LDAP://localhost:389/OU=Server Groups,DC=vdi,DC=vmware,DC=int'
$LDAPEntry1 = New-Object DirectoryServices.DirectoryEntry $LDAPPath1
$Selector1 = New-Object DirectoryServices.DirectorySearcher
$Selector1.SearchRoot = $LDAPEntry1

Write-Host "Connection Brokers"
Write-Host "-------------------"
$connBrokers = Get-ConnectionBroker | select broker_id,activation,lastBackup,ldapBackupFrequency,type
if($connBrokers -ne $null)
{
	foreach($connBroker in $connBrokers)
	{
        if($connBroker.type -eq "Connection Server")
        {
		    Write-Host ($connBroker.broker_id,$connBroker.activation,
		    $connBroker.lastBackup,$connBroker.ldapBackupFrequency ) -Separator "#"
        }
	}
}
else
{
	Write-Host "- #"  -nonewline;
}

<##
logic for findig the current connection server is master or replica and ignore the session monitoring data
#$vdm = Get-ItemProperty "HKLM:\SOFTWARE\VMware, Inc.\VMware VDM" 
#$isStandardVDM = $vdm.ServerInstanceType
##>
$isStandardVDM = $False
$ldapaddr = 'LDAP://localhost:389/DC=vdi,DC=vmware,DC=int'
$ldapopen = [adsi]$ldapaddr
$objectCategoryarr = $ldapopen.'objectCategory' -split ','
#$objectCategoryarr.count
if($objectCategoryarr.count -eq 4)
{
    $schemaguid = $objectCategoryarr[3]
    $schemaConfigurationaddr= 'LDAP://localhost:389/CN=Schema,CN=Configuration,'+$schemaguid
    #$schemaConfigurationaddr
    $schemaConfigurationOpen = [adsi]$schemaConfigurationaddr
    #$schemaConfigurationOpen.fSMORoleOwner
    $fsmoRoleOwnerAddr = $schemaConfigurationOpen.fSMORoleOwner -split ","
    if($fsmoRoleOwnerAddr.count -gt 2)
    {
        $masterarr= $fsmoRoleOwnerAddr[1].split('`$')
        if($masterarr.count -eq 2)
        {
            $localhost = "CN=$env:computername"
            #$localhost
            #$masterarr[0]
            $isStandardVDM = $localhost -eq $masterarr[0]
        }
    }
}

$isStandardVDM

Write-Host "Pools"
Write-Host "--------"
if($isStandardVDM -eq $True)
{
	$pools = get-hvpool
	foreach($pool in $pools)
	{
		$headroomcount = -5
		$maximumcount = -5
		$minimumcount = -5
		$vcServerName = -5

		$DesktopBase = $pool.Base
		$id = $DesktopBase.Name
		$displayName = $DesktopBase.DisplayName

		$DesktopSettings = $pool.DesktopSettings
		$enabled = $DesktopSettings.Enabled
		$deliveryModel = $pool.Type
		$desktopSource = $pool.Source
		if($deliveryModel -eq "AUTOMATED")
		{
			$DesktopData = $pool.AutomatedDesktopData
			$VmNamingSettings = $DesktopData.VmNamingSettings
			$PatternNamingSettings = $VmNamingSettings.PatternNamingSettings
			$maximumcount = $PatternNamingSettings.MaxNumberOfMachines
			$minimumcount = $PatternNamingSettings.MinNumberOfMachines
			$headroomcount = $PatternNamingSettings.NumberOfSpareMachines
			if($minimumcount -eq $null -or $minimumcount.length -eq 0) {$minimumcount = -5}
		}
		elseif($deliveryModel -eq "MANUAL")
		{
			$DesktopData = $pool.ManualDesktopData
		}

		if($DesktopData.VirtualCenter -ne $null)
		{
			$vcid = $DesktopData.VirtualCenter.Id
			foreach($vCenter in $vcList)
			{
				if($vCenter.Id.Id -eq $vcid)
				{
					$vcServerSpec = $vCenter.ServerSpec
					$vcServerName = $vcServerSpec.ServerName +":" +  $vcServerSpec.Port
					if($vcServerName -eq $null -or $vcServerName.length -eq 0)
					{
						$vcServerName = "-"
					}
					break
				}
			}
		}
		$poolType = $deliveryModel
		write-host ($id, $displayName,$enabled, $deliveryModel, $desktopSource,$vcServerName, $poolType, $headroomcount, $maximumcount, $minimumcount) -Separator "#"

		

		$poolentitlements = Get-PoolEntitlement -pool_id $id  | select displayName
		Write-Host "poolentitlement starts ^!^" -nonewline;
		if($poolentitlements -ne $null)
		{
			foreach($poolentitlement in $poolentitlements)
			{
				Write-Host ($poolentitlement.displayName) ("^!^")  -nonewline;
			}
		}
		else
		{
			Write-Host "- ^!^"  -nonewline;
		}
		Write-Host "poolentitlement stops"

		Write-Host "Desktops starts ^!^" -nonewline;
		if($desktopSource -eq "VIRTUAL_CENTER" -or $desktopSource -eq "VIEW_COMPOSER" -or $desktopSource -eq "INSTANT_CLONE_ENGINE")
		{
			$machines = Get-HVMachine -poolname $id
			if($machines -ne $null)
			{
				foreach($machine in $machines)
				{
					$machineBase = $machine.Base
					$Name = $machineBase.Name
					if($Name -eq $null -or $Name.length -eq 0)
					{
						$Name = "-"
					}
					$GuestFullName = $machineBase.OperatingSystem
					if($GuestFullName -eq $null -or $GuestFullName.length -eq 0)
					{
						$GuestFullName = "-"
					}
					$HostName = $machineBase.DnsName
					if($HostName -eq $null -or $HostName.length -eq 0)
					{
						$HostName = "-"
					}
					$IPAddress = $HostName
					$isInPool = $true
					$machine_id = $Name
					$ManagedMachineData = $machine.ManagedMachineData
					$VirtualCenterData = $ManagedMachineData.VirtualCenterData
					$Path = $VirtualCenterData.Path
					$ServerGroup = $id
					$BasicState = $machineBase.BasicState
					Write-Host ($id,$Name,$Path, $GuestFullName, $HostName, $IPAddress, $isInPool,$machine_id,$ServerGroup,$BasicState, "^!^") -Separator "#" -nonewline;
				}
			}
			else
			{
				Write-Host "- ^!^" -nonewline;
			}
		}
		elseif($desktopSource -eq "RDS")
		{
			$RdsDesktopData = $pool.RdsDesktopData
			if($RdsDesktopData -ne $null)
			{
				$FarmID = $RdsDesktopData.Farm
				$FarmInfo = $services.Farm.Farm_GetSummaryView($FarmID)
				if($FarmInfo -ne $null)
				{
					$farmData = $FarmInfo.Data
					$Path = "-"
					$GuestFullName = "-"
					$isInPool = $true
					$Enabled = $farmData.Enabled
					if($Enabled -eq $null -or $Enabled.length -eq 0)
					{
						$Enabled = 0	#0 means Enabled   1 means Disabled
					}
					$MaxConns = $farmData.MaximumNumberOfSessions
					if($MaxConns -eq $null -or $MaxConns.length -eq 0)
					{
						$MaxConns = 150
					}
					$farmHealth = $services.FarmHealth.FarmHealth_Get($FarmID)
					if($farmHealth -ne $null)
					{
						$name = $farmHealth.Name
						$RDSServersHealth = $farmHealth.RDSServerHealth
						foreach($RDSServer in $RDSServersHealth)
						{
							$HostName = "-"
							$IPAddress = "-"
							$machine_id = "-"
							$ServerGroup = "-"
							$BasicState = "-"

							$IPAddress = $RDSServer.Name
							$machine_id = $RDSServer.Name
							$HostName = $RDSServer.Name  
							$BasicState = $RDSServer.Status

							Write-Host ($id,$name,$Path, $GuestFullName, $HostName, $IPAddress, $isInPool,$machine_id,$ServerGroup,$BasicState,$Enabled,$MaxConns,"^!^") -Separator "#" -nonewline;
						}
					}
				}
			}
			else
			{
				Write-Host "- ^!^" -nonewline;
			}
		}
		Write-Host "Desktops stops"
		Write-Host "~#~"
	}
	

	Write-Host "PoolsUsage"
	Write-Host "----------"
	write-Host "localsessions starts ^!^" -nonewline;
	Write-Host "localsessions stops"
	Write-Host "remotesessions starts ^!^" -nonewline;
	$PodSessions = get-hvlocalsession
	if($podSessions -ne $null)
	{
		foreach($session in $podSessions)
		{
			$NamesData = $session.NamesData
			$mac_id = $NamesData.MachineOrRDSServerName
			$SessionData = $session.SessionData
			$userName = $NamesData.userName
			$SessUniqID = $session.id.id
			if($userName -eq $null -or $userName.length -eq 0)
			{
				$userName = "-"
			}
			$DNSName = $NamesData.MachineOrRDSServerDNS
			if($DNSName -eq $null -or $DNSName.length -eq 0)
			{
				$DNSName = "-"
			}
			$startTime = $SessionData.startTime
			if($startTime -eq $null -or $startTime.length -eq 0)
			{
				$startTime = "-"
			}
			$duration = $SessionData.LastSessionDurationMS
			if($duration -eq $null -or $duration.length -eq 0)
			{
				$duration = "-"
			}
			$state = $SessionData.SessionState
			if($state -eq $null -or $state.length -eq 0)
			{
				$state = "-"
			}
			$protocol = $SessionData.SessionProtocol
			if($protocol -eq $null -or $protocol.length -eq 0)
			{
				$protocol = "-"
			}
			$session_id = $SessionData.SessionType
			if($session_id -eq $null -or $session_id.length -eq 0)
			{
				$session_id = "-"
			}
			$pool_id = $NamesData.DesktopName
			if($pool_id -eq $null)
			{
				$pool_id = $NamesData.FarmName
			}
			Write-Host ($pool_id,$userName,$startTime, $DNSName, $duration, $mac_id, $state, $protocol, $session_id,$SessUniqID,"^!^") -Separator "#" -nonewline;
		}
	}
	else
	{
		Write-Host "- ^!^" -nonewline;
	}
	write-Host "remotesesions stops"
}
Write-Host 
Write-Host "Domain monitor"
Write-Host "---------------"
$domains = Get-Monitor -monitor DomainMonitor -monitor_id $env:computername
if($domains -ne $null)
{
	write-host($domains.domains)
}

Write-Host 



Write-Host "VC monitor"
Write-Host "-----------"
$vcs = Get-Monitor -monitor VCMonitor
if($vcs -ne $null)
{
	foreach($vc in $vcs)
	{
		Write-Host ($vc.URL,$vc.State) -Separator "^"
	}
}
Write-Host




Write-Host "DB monitor"
Write-Host "-------------"

$db = Get-monitor -monitor DBMonitor
Write-Host ($db.Server,$db.DBName,$db.State) -Separator "#"

Write-Host



Write-Host "License"
Write-Host "---------"

$license = Get-hvlicense
$license | fl

Write-Host "RDS Host Applications"
Write-Host "------------------"
if($isStandardVDM -eq $True)
{
	$AppForRDSServers = New-Object -TypeName System.Collections.Generic.List[string]
	$MissingAppForRDSServers = New-Object -TypeName System.Collections.Generic.List[string]
	$query_service_helper = New-Object VMware.Hv.QueryServiceService
	$defn = New-Object VMware.Hv.QueryDefinition
	$defn.queryEntityType = 'ApplicationInfo'
	$queryResults = $query_service_helper.QueryService_Query($services,$defn)
	$AppsInfo = $queryResults.results

	if($AppsInfo -ne $null)
	{
		foreach($AppInfo in $AppsInfo)
		{
			$MissingAppExists = $false
			$AppForRDSServers.Clear()
			$MissingAppForRDSServers.Clear()
			$AppData = $AppInfo.data
			$AppDisplayName = $AppData.Name
			$AppEnabled = $AppData.enabled
			$farmID = $AppInfo.executionData.farm
			$farmHealth = $services.FarmHealth.FarmHealth_Get($farmID)
			if($farmHealth -ne $null)
			{
				$fname = $farmhealth.name
				$RDSServersHealth = $farmHealth.RDSServerHealth
				foreach($RDSServer in $RDSServersHealth)
				{
					$IPAddress = $RDSServer.Name
					$AppForRDSServers.Add($IPAddress)
					$MissingApplications = $RDSServer.MissingApplications
					if($MissingApplications -ne $null)
					{
						foreach($missingApps in $MissingApplications)
						{
							
							if($missingApps.Name -eq $AppDisplayName)
							{
								$MissingAppExists = $true
								$MissingAppForRDSServers.add($IPAddress)
							}
						}
					} 
				}
				write-host ($AppDisplayName,$fname, $AppForRDSServers,$AppEnabled,$MissingAppExists,$MissingAppForRDSServers) -Separator "#"  
			}
		}
	}
}

write-host
write-host "RDS Farms"
Write-host "-----------"
if($isStandardVDM -eq $True)
{
	$farms = get-hvfarm -SuppressInfo $true
	if($farms -ne $null)
	{
		foreach($farm in $farms)
		{
			$farmId = $farm.ID
			$farmtype = $farm.Type
			$FarmInfo = $services.Farm.Farm_GetSummaryView($FarmID)
			if($FarmInfo -ne $null)
			{
				$farmData = $FarmInfo.Data
				$Path = "-"
				$GuestFullName = "-"
				$isInPool = $true
				$Enabled = $farmData.Enabled
				if($Enabled -eq $null -or $Enabled.length -eq 0)
				{
					$Enabled = 0	#0 means Enabled   1 means Disabled		
				}
				$MaxConns = $farmData.MaximumNumberOfSessions
				if($MaxConns -eq $null -or $MaxConns.length -eq 0)
				{
					$MaxConns = 150
				}
				$farmHealth = $services.FarmHealth.FarmHealth_Get($FarmID)
				if($farmHealth -ne $null)
				{
					$name = $farmHealth.Name
					$RDSServersHealth = $farmHealth.RDSServerHealth
					foreach($RDSServer in $RDSServersHealth)
					{
						$HostName = "-"
						$IPAddress = "-"
						$machine_id = "-"
						$ServerGroup = "-"
						$BasicState = "-"

						$IPAddress = $RDSServer.Name
						$machine_id = $RDSServer.Name
						$HostName = $RDSServer.Name  
						$BasicState = $RDSServer.Status
						Write-Host ($name,$Path, $GuestFullName, $HostName, $IPAddress, $isInPool,$machine_id,$ServerGroup,$BasicState,$Enabled,$MaxConns) -Separator "#"
					}
				}
			}
		}
	}
}
write-host
write-host "Date Format"
Write-host "-----------"
$f = (get-culture).datetimeformat.ShortDatePattern
$h = (get-culture).datetimeformat.LongTimePattern
Write-host "$f $h"

Disconnect-HVServer -confirm:$false


Remove-Pssnapin "VMware.View.Broker"
