﻿$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$TermSvcObj = gwmi -Namespace root\cimv2\terminalservices -CLASS Win32_TerminalServiceSetting
if ($TermSvcObj -ne $null)
{
	$GraceDaysLeft = $TermSvcObj.GetGracePeriodDays().DaysLeft
	$RegServers = ""

	$RegServerObj = $TermSvcObj.GetRegisteredLicenseServerList()
	If ($RegServerObj -ne $null)
	{
		$count = 0
		$RegLsServers = $RegServerObj.RegisteredLSList
		foreach ($RegLSSrv in $RegLsServers)
		{
			If ($count -eq 0)
			{
				$RegServers = $RegLSSrv
			}
			else
			{
				$RegServers = ($RegServers,$RegLSSrv) -join ","
			}
			$count = $count + 1
		}
	}
	Write-Host($TermSvcObj.ServerName,$GraceDaysLeft,$TermSvcObj.AllowTSConnections,$TermSvcObj.SingleSession,$RegServers) -Separator "#~#"
}


