﻿<#
    /*****************************************************************************
    Author            :       Prabaharan.T
    Purpose           :       used to get the site information from SPO site collections
    Created           :       31/01/2018
    Modified By       : 

#>
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
clear

$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxycrdls=($TestInputs[2]).ToString().Split("#")
$proxyUsr=$proxycrdls[0]
$proxyPass=Eg-O365Dcr -EncStr $proxycrdls[1]
$proxyserverip=$TestInputs[3]
$reportingname=$TestInputs[4]
$sites=$TestInputs[5]
$rptTopNSites=[int]$TestInputs[6]
$rptTopNDD=[int]$TestInputs[7]
$graphDetails=$TestInputs[8]
$appDetails=$TestInputs[9]
$o365Domain=$TestInputs[10]

if($graphDetails -and $graphDetails -ne 'none'){
    $graphDetailsArr=($graphDetails).ToString() -Split ("~!~")
    $appId=$graphDetailsArr[0]
    $appSecret=$graphDetailsArr[1]
    $authString=$graphDetailsArr[2]
    $resource=$graphDetailsArr[3]
}
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}


if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$filePath 
    )

    Process
    {
        $typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
        Add-Type -Path $typePath
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()

        $header = @{
            'Authorization'=$authCode
        }
        $queryRes = Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url 
        $queryRes=$queryRes.Replace('ï»¿','')
        $queryRes=$queryRes.Replace('(Byte)','')
        $queryRes=$queryRes.Replace(' ','')
        $resultarray = ConvertFrom-Csv -InputObject $queryRes
        $reprts=$resultarray | ConvertTo-Json 
        $jsonreprt=@()
        $jsonreprt='{ "Usage" :['+$reprts+']}'
        $reports=$jsonreprt | ConvertFrom-Json
        for($i=0;$i -lt $reports.Usage.Length ;$i++ ){  
            $reports.Usage[$i] |Export-Csv $filePath -Append -NoTypeInformation -Force
        }
    }
}

Function Eg-DeleteOldFiles(){
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$FilePath, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$Pattern  
    )
    Process
    {
        $indx=1
          $fileRead=Get-ChildItem -Path $FilePath |Where-Object {$_.Name -like $Pattern+'*.dat'}| Sort-Object LastWriteTime -Descending | Select Name 
            foreach($file in $fileRead)
            {
                 if($indx -gt 1){
                    $fileName=([String]$file.Name).Trim()
                    $tempPath=$FilePath+$fileName
                    if([System.IO.File]::Exists($tempPath)){
                        Remove-Item $tempPath -Force
                    }
                 }
               $indx++ 
        }
    }
}

Function Eg-DeleteNewFiles(){
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$FilePath, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$Pattern
    )
    Process
    {
        $indx=1
          $fileRead=Get-ChildItem -Path $FilePath |Where-Object {$_.Name -like $Pattern+'*.dat'}| Select Name 
            foreach($file in $fileRead)
            {
                 if($indx -gt 1){
                    $fileName=([String]$file.Name).Trim()
                    $tempPath=$FilePath+$fileName
                    if([System.IO.File]::Exists($tempPath)){
                        Remove-Item $tempPath -Force
                    }
                 }
               $indx++ 
        }
    }
}

[System.Collections.ArrayList]$spoSpecificSites = @()
$totalCount  = 0
$passedCount = 0
$unauthCount = 0
$otherCount = 0
if($sites -and $sites.Trim() -and $sites -ne 'none' -and $sites){
    $seperator = [string[]]@("^!")
    $spoSpecificSites = $sites.ToString().Split($seperator, [System.StringSplitOptions]::RemoveEmptyEntries)
}else{
    Try{
        # ----- Top Site List --------
        $rptPath='SPO/'+$reportingname

        $writArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "spoactsites" -keyFileName "kspoactsites" -EgPath $egurkhaPath
        Eg-InvokeUrl -Url "https://graph.microsoft.com/v1.0/reports/getSharePointSiteUsageDetail(period='D7')" -filePath $writArr[1]
        $null=Protect-File  $writArr[1] -Algorithm AES -KeyAsPlainText $writArr[0] -RemoveSource
        [System.GC]::GetTotalMemory($true) | out-null
        try{
            $readArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "spoactsites" -keyFileName "kspoactsites" -EgPath $egurkhaPath
            if($readArr -ne $null -and [System.IO.File]::Exists($readArr[1]) -eq 'True'){
                $unProtctSites=$readArr[1] -replace (".csv",".dat") 
                $sitesPath=Unprotect-File $unProtctSites -Algorithm AES -KeyAsPlainText $readArr[0]	
                $siteUsageDtls= import-csv $sitesPath
                Remove-Item $sitesPath
            }
        }
        catch{
            $errmsg=$_.Exception.Message
            Write-Error -Message $errmsg
        }
        $ldate=($siteUsageDtls |sort -Property LastActivityDate -Descending |Select-Object -First 1).LastActivityDate
        $lastActData=$siteUsageDtls|Where-Object{$_.LastActivityDate -in $ldate -and $_.RootWebTemplate -ne 'Group'}
	    $lastActData=($lastActData |Select-Object -First 100)
        
        if($lastActData.Length -gt 0){
            Eg-DeleteOldFiles -FilePath $readArr[2] -Pattern 'spoactsites'
            Eg-DeleteOldFiles -FilePath $readArr[2] -Pattern 'kspoactsites'
            [System.GC]::GetTotalMemory($true) | out-null
        }else{
            try{
                Eg-DeleteNewFiles -FilePath $readArr[2] -Pattern 'spoactsites'
                Eg-DeleteNewFiles -FilePath $readArr[2] -Pattern 'kspoactsites'
                [System.GC]::GetTotalMemory($true) | out-null
                $readArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "spoactsites" -keyFileName "kspoactsites" -EgPath $egurkhaPath
                if($readArr -ne $null -and [System.IO.File]::Exists($readArr[1]) -eq 'True'){
                    $unProtctSites=$readArr[1] -replace (".csv",".dat") 
                    $sitesPath=Unprotect-File $unProtctSites -Algorithm AES -KeyAsPlainText $readArr[0]	
                    $siteUsageDtls= import-csv $sitesPath
                    Remove-Item $sitesPath 
                }   
            }catch{
                $errmsg1=$_.Exception.Message
                Write-Host $errmsg1
            }
            $ldate=($siteUsageDtls |sort -Property LastActivityDate -Descending |Select-Object -First 1).LastActivityDate
            $lastActData=$siteUsageDtls|Where-Object{$_.LastActivityDate -in $ldate -and $_.RootWebTemplate -ne 'Group'}
	        $lastActData=($lastActData |Select-Object -First 100)
        }
	    $lastActData |ForEach-Object{$null = $spoSpecificSites.Add($_.SiteURL);}
        [System.GC]::GetTotalMemory($true) | out-null
    }Catch{
        $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
        Write-Error "Error Occured while getting top active sites in SPOSiteHealthCheck -- $exceptionmsg "
        Eg-DeleteNewFiles -FilePath $readArr[2] -Pattern 'spoactsites'
        Eg-DeleteNewFiles -FilePath $readArr[2] -Pattern 'kspoactsites'
        [System.GC]::GetTotalMemory($true) | out-null
    }    
}

Try{
    if($spoSpecificSites.Length -gt 0){
        #$o365Domain = $o365Domain.Substring(0, $o365Domain.IndexOf('.onmicrosoft.com'))
        $url = 'https://'+$o365Domain+'-admin.sharepoint.com'
        if(!$proxyserverip.Contains('none')){
            $proxyserver='http://'+$proxyserverip
            [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
            if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
                $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
                [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
                [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
            }
        }

        if($appDetails -and $appDetails -ne 'none'){
		    Connect-PnPOnline -url $url -clientId $clientId -Tenant $tenantName -Thumbprint $thumbPrint
        }else{
        	$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)    
	        Connect-SPOService -Url $url -Credential $cred 
	    }
	
        foreach($site in $spoSpecificSites){
            Try{
                if($appDetails -and $appDetails -ne 'none'){
                    $testSite=Test-PnPSite -Identity $site | select SiteUrl,PassedCount,FailedWarningCount,FailedErrorCount,Results
                }else{
                	$testSite=Test-SPOSite -Identity $site | select SiteUrl,PassedCount,FailedWarningCount,FailedErrorCount,Results
		}
                if($testSite -ne $null){
                    if($passedCount -ge $rptTopNSites){
                        break
                    }
                    $siteUrl=$testSite.SiteUrl
                    $results=$testSite.Results
                    foreach($res in $results){
                        write-host 'SpoHealthDD~'$siteUrl '~'$res.Status '~'$res.Rule.Id '~'$res.Rule.Name
                    }
                    $extCount = 0
                    Try{
                        $i=0
                        if($appDetails -and $appDetails -ne 'none'){
                            $extUsers= Get-PnPExternalUser -SiteUrl $siteUrl -Position $i -PageSize 50| select Email,DisplayName,UniqueId,AcceptedAs,WhenCreated,InvitedBy
                        }else{
	                        $extUsers= Get-SPOExternalUser -SiteUrl $siteUrl -Position $i -PageSize 50| select Email,DisplayName,UniqueId,AcceptedAs,WhenCreated,InvitedBy
			}
                        $extCount= $extUsers.count
                        Try{
                            if($extUsers.count -gt 0){
                                $count = 0
                                foreach($user in $extUsers){
                                    if($count -eq $rptTopNDD){
                                        Break
                                    }
                                    $InvitedBy=$user.InvitedBy
                                    if($InvitedBy -ne $null){
                                        $value=$user.Email+'~'+$user.DisplayName+'~'+$user.AcceptedAs+'~'+$user.WhenCreated+'~'+$InvitedBy
                                    }
                                    else{
                                        $value=$user.Email+'~'+$user.DisplayName+'~'+$user.AcceptedAs+'~'+$user.WhenCreated+'~'+'-'
                                    }                   
                                    Write-Host 'ExtDD~'$siteUrl'~'$value
                                    $count++
                                }
                            }
                        }
                        Catch{
                            Write-Error 'Exception Occured while parsing Get-SPOExternalUser output ' $_.Exception.Message
                        }
                    }
                    Catch{
                        Write-Error 'Exception Occured in Get-SPOExternalUser ' $_.Exception.Message
                    }
                    write-host 'SpoHealthME~'$siteUrl '~'$testSite.PassedCount'~'$testSite.FailedWarningCount'~'$testSite.FailedErrorCount'~'$extCount
                    $passedCount++
                }
            }
            Catch{
                #Write-Error 'Exception Occured in Test-SPOSite ' $_.Exception.Message
		        $exceptionmsg=$_.Exception.Message
                if($exceptionmsg -match 'System.UnauthorizedAccessException'){
                    $unauthCount++
                }else{
                    $otherCount++
                }
	        }
            $totalCount++
	    }
	    write-host 'Summary~Tried top' $totalCount 'site collection URLs,'$passedCount '- successful,'$unauthCount '- failed with unauthorized exception,'$otherCount '- failed with other exception'
    }
}
Catch{
    $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
     Write-Error "Error Occured in SPOSiteHealthCheck -- $exceptionmsg "
}