﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

clear
#<#
$TestInputs=$args
$domain=$TestInputs[0]
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxycrdls=($TestInputs[2]).ToString().Split("#")
$proxyUsr=$proxycrdls[0]
$proxyPass=Eg-O365Dcr -EncStr $proxycrdls[1]
$proxyserverip=$TestInputs[3]
$tenantName=$TestInputs[4]
if($tenantName -and $tenantName -ne 'none'){
    $appDetails=($TestInputs[5]).ToString() -Split ("~!~")
    $clientId=$appDetails[0]
    $tenantName=$appDetails[1]
    $thumbPrint=$appDetails[2]
}
#>

if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

if($tenantName -eq 'none') {
    $cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force) 
}

$siteUrls=($TestInputs[6]).ToString() -Split (",")
foreach($siteUrl in $siteUrls) {
    $testInfo = $siteUrl.Substring(0, $siteUrl.IndexOf(':'))
    $url = $siteUrl.Substring($siteUrl.IndexOf(':') + 1)
    Try {
        $datStr1 = [datetime](Get-Date)
        if($tenantName -ne 'none') {
            Connect-PnPOnline -url $url -clientId $clientId -Tenant $tenantName -Thumbprint $thumbPrint
        } else { 
            Connect-SPOService -Url $url -Credential $cred
        }
        $datStr2 = [datetime](Get-Date)
        $diff1 = New-TimeSpan -Start $datStr1 -End $datStr2
        $connTime = [Math]::Round(((($diff1.Minutes*60000)+($diff1.Seconds*1000)+$diff1.Milliseconds)/1000),2)
        Write-Host 'SPOSiteConnectivityMM~'$testInfo'~100~-5~'$connTime
        if($tenantName -eq 'none') {
            Disconnect-SPOService
        }
    } Catch {
        Write-Host 'SPOSiteConnectivityMM~'$testInfo'~0~-5~-5'
        $exceptionmsg = ($_.Exception.Message)+($_.ScriptStackTrace)
        Write-Error "Error Occured in SPOSiteConnectivity -- $exceptionmsg "
    }
}
