﻿<#
    /*****************************************************************************
    Author            :       Prabaharan.T
    Purpose           :       get the Message Center messages
    Created           :       31/01/2018
    Modified By       : 
#>
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$testFrequency=$TestInputs[2]
$proxycrdls=($TestInputs[3]).ToString().Split("#")
$proxyUsr=$proxycrdls[0]
$proxyPass=Eg-O365Dcr -EncStr $proxycrdls[1]
$proxyserverip=$TestInputs[4]
$graphDetails=$TestInputs[5]
if($graphDetails -and $graphDetails -ne 'none'){
    $graphDetailsArr=($graphDetails).ToString() -Split ("~!~")
    $appId=$graphDetailsArr[0]
    $appSecret=$graphDetailsArr[1]
    $authString=$graphDetailsArr[2]
    $resource=$graphDetailsArr[3]
}
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }

$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

$time=((Get-date).AddMinutes($testFrequency)).ToUniversalTime()
    $proxyserver='http://'+$proxyserverip  


    [System.Collections.ArrayList]$incidentIDs=@()

    Function Eg-InvokeUrl(){
	    [CmdletBinding()]
        Param(
            [Parameter(Mandatory=$true, Position=1)]
            [String]$Url, 
            [Parameter(Mandatory=$true, Position=3)]
            [Object]$header               
        )

        Process
        {
			$query = [System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
           #$query= Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url
		   $query=$query | ConvertFrom-Json
           #$query=$query.value
           return $query
        }
    }
        $path=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
        Add-Type -Path $path
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($Resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()
        $header = @{
            'Authorization'=$authCode
        }

        $O365Servicesurl= "https://graph.microsoft.com/v1.0/admin/serviceAnnouncement/messages"
        $serv= Eg-InvokeUrl -Url $O365Servicesurl  -header $header
        while($true){      
            $serv= Eg-InvokeUrl -Url $O365Servicesurl  -header $header
            $values=$serv.value
            foreach($value in $values){
                if($value.services -match 'SharePoint Online'){
                    $ID= $value.id
                    $Title = $value.title
                    $StartTime = $value.startDateTime
                    $EndTime= $value.endDateTime
                    $Message = $value.body.content
                    $ActionRequiredByDate = $value.actionRequiredByDateTime
                    if($ActionRequiredByDate -eq $null){
                        $ActionRequiredByDate = '-'
                    }
                    $ActionType =$value.services
                    $Category = $value.category
                    $ExternalLink=$value.details.value
                    $UrgencyLevel=$value.severity
                    if($EndTime -gt $time){
                        Write-Host "##DDLINE##" "Messagecenter"  ~!~  $Category ~!~  $ID ~!~  $EndTime ~!~  $Title  ~!~  $StartTime ~!~  $ActionRequiredByDate ~!~  $ActionType ~!~  $ExternalLink ~!~  $UrgencyLevel ~!~
                        $msg = $Message -replace ‘<[^>]+>’,"”                      
                        if($msg.Contains("["))
                        {
                            $Msge = $msg.Split("[");
                            Write-Host   "##msage##" $Msge[0]
                        }else{
                            Write-Host   "##msage##" $msg
                        }
                    }
                }
            }
            if($serv."@odata.nextLink" -eq $null -or $serv."@odata.nextLink" -eq ''){
                break;
            }else{
                $O365Servicesurl=($serv."@odata.nextLink")
            }
        }
[System.GC]::GetTotalMemory($true) | out-null





