﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

clear
#<#
$TestInputs=$args
$domain=$TestInputs[0]
$userName=$TestInputs[1]
$password=Eg-O365Dcr -EncStr $TestInputs[2]
$proxycrdls=($TestInputs[3]).ToString().Split("#")
$proxyUsr=$proxycrdls[0]
$proxyPass=Eg-O365Dcr -EncStr $proxycrdls[1]
$proxyserverip=$TestInputs[4]
$appDetails=$TestInputs[5]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$url = 'https://'+$domain+'-admin.sharepoint.com'
$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)  

Try{
    $url = 'https://'+$domain+'-admin.sharepoint.com'
    $datStr1=[datetime](Get-Date)
    if($appDetails -and $appDetails -ne 'none'){
        Connect-PnPOnline -url $url -clientId $clientId -Tenant $tenantName -Thumbprint $thumbPrint
    }else{
        $cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)  
        Connect-SPOService -Url $url -Credential $cred
    }
    $datStr2=[datetime](Get-Date)
    $diff1=New-TimeSpan -Start $datStr1 -End $datStr2
    $connTime=[Math]::Round(((($diff1.Minutes*60000)+($diff1.Seconds*1000)+$diff1.Milliseconds)/1000),2)
    $connTime=$connTime.ToString().replace(',','.')
    Write-Host 'SpoLogonStatusMM~Success~'$connTime
    if(!$appDetails -or $appDetails -eq 'none'){
        Disconnect-SPOService
    }
}Catch{
    $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
     Write-Error "Error Occured in SPOLogonStatus -- $exceptionmsg "
}