﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
#<#
$testargs=$args
$proxyUsr=$testargs[0]
$proxyPass=Eg-O365Dcr -EncStr $testargs[1]
$Proxyserverip=$testargs[2]
$uploadLoc=$testargs[3]
$folderNam=$testargs[4]
$downloadLoc=$testargs[5]
$appDtls=$testargs[6]
if($appDtls -and $appDtls -ne 'none'){
    $appDetailsArr=($appDtls).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

if(!$proxyserverip.ToString().ToLower().Contains('none')){
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserverip)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	    $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

Connect-PnPOnline -Thumbprint $thumbPrint -url $uploadLoc -clientId $clientId -Tenant $tenantName

$uploadTime=-5;$dwnloadTime=-5;$chkOutTime=-5;$chkInTime=-5;$delTime=-5;

##File Creation
if(!(Test-Path -Path $downloadLoc )){
    New-Item -ItemType directory -Path $downloadLoc
}
$dat=Get-Date -Format "dd-MM-yyyy HH-mm-ss-fff"
$fileNam='eGTestFile'+$dat+'.csv'

$spoFile=$downloadLoc+'\'+$fileNam
Add-Content -Path $spoFile -Value 'eG Uploading the document for testing the time taken to upload'

Try{
    ## Upload the file
    $uploadStart=[datetime](Get-Date)
    Add-PnPFile -Path $spoFile -Folder $folderNam
    $uploadEnd=[datetime](Get-Date)
    $uploaddiff=New-TimeSpan -Start $uploadStart -End $uploadEnd
    $uploadTime=[Math]::Round(((($uploaddiff.Minutes*60000)+($uploaddiff.Seconds*1000)+$uploaddiff.Milliseconds)/1000),2)

    if([System.IO.File]::Exists($spoFile) -eq 'True'){
        Remove-Item -Path $spoFile -Force
    }
    $relativPathFoldr=$folderNam.Replace('%20',' ')
    $spoReltivUrl='/'+$relativPathFoldr+"/"+$fileNam

    ##Download the file
    $dwnloadStart=[datetime](Get-Date)
    Get-PnPFile -Url $spoReltivUrl -Path $downloadLoc -FileName $fileNam -AsFile -Force
    $dwnloadEnd=[datetime](Get-Date)
    $dwnloaddiff=New-TimeSpan -Start $dwnloadStart -End $dwnloadEnd
    $dwnloadTime=[Math]::Round(((($dwnloaddiff.Minutes*60000)+($dwnloaddiff.Seconds*1000)+$dwnloaddiff.Milliseconds)/1000),2)


    ##CheckOut the file
    $chkOutStart=[datetime](Get-Date)
    Set-PnPFileCheckedOut -Url $spoReltivUrl
    $chkOutEnd=[datetime](Get-Date)
    $chkOutdiff=New-TimeSpan -Start $chkOutStart -End $chkOutEnd
    $chkOutTime=[Math]::Round(((($chkOutdiff.Minutes*60000)+($chkOutdiff.Seconds*1000)+$chkOutdiff.Milliseconds)/1000),2)


    ##Checkin the file
    $chkInStart=[datetime](Get-Date)
    Set-PnPFileCheckedIn -Url $spoReltivUrl -CheckinType MinorCheckIn -Comment "Smaller changes"
    $chkInEnd=[datetime](Get-Date)
    $chkIndiff=New-TimeSpan -Start $chkInStart -End $chkInEnd
    $chkInTime=[Math]::Round(((($chkIndiff.Minutes*60000)+($chkIndiff.Seconds*1000)+$chkIndiff.Milliseconds)/1000),2)

    ##Delete the file
    $delStart=[datetime](Get-Date)
    Remove-PnPFile -ServerRelativeUrl $spoReltivUrl -Force
    $delEnd=[datetime](Get-Date)
    $deldiff=New-TimeSpan -Start $delStart -End $delEnd
    $delTime=[Math]::Round(((($deldiff.Minutes*60000)+($deldiff.Seconds*1000)+$deldiff.Milliseconds)/1000),2)

    Disconnect-PnPOnline

    if([System.IO.File]::Exists($spoFile) -eq 'True'){
        Remove-Item -Path $spoFile -Force
    }  
}
Catch{
    $spoExcepMsg='[SPOFileOperations] Exception Occured -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception+'!>'
    Write-Host $spoExcepMsg
}
$measures='measures~'+$uploadTime+'~'+$dwnloadTime+'~'+$chkOutTime+'~'+$chkInTime+'~'+$delTime
Write-Host $measures

