﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
#<#
$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$splitArrVal=($TestInputs[4]).ToString().Split("#")
$testFrequency=($splitArrVal[0]).ToString().trim()
$proxyserverip=($splitArrVal[1]).ToString().trim()
$rptNam=($splitArrVal[2]).ToString().trim()
$statusVal=($splitArrVal[3]).ToString().trim()
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$rptPath=$egurkhaPath+'\agent\SBO\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$logPath=$rptPath+'\SBOServiceHealth.log'

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$lastruntime=((Get-date).AddMinutes($testFrequency)).ToUniversalTime() 
Eg-WriteLog -writString ('Lastruntime -->> '+$lastruntime) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $true

$proxyserver='http://'+$proxyserverip
$domain=Eg-GetDomain -userName $userName -Password $Password -proxyUsr $proxyUsr -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

if($domain){
    [System.Collections.ArrayList]$incidentIDs=@()
    try{
        $msGraphPath=$egurkhaPath+"\agent\O365\MsGraph"
        $keyFileNam = '\GraphDetailsKey.dat'
        $unProtPath= $msGraphPath+'\GraphDetails.dat'
        $kvalue= Get-Content -Path $msGraphPath$keyFileNam
        $null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
        $SkypeInput=$msGraphPath+"\GraphDetails.txt"
        $GetInput = Get-Content -Path $SkypeInput
    }catch{
        Write-Error -Message "File not found. The $GetInput location does not contain GraphDetails"
    }

    Function Eg-InvokeUrl(){
	    [CmdletBinding()]
        Param(
            [Parameter(Mandatory=$true, Position=1)]
            [String]$Url, 
            [Parameter(Mandatory=$true, Position=3)]
            [Object]$header               
        )

        Process
        {
            $query = [System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
           #$query= Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url
           $query=$query | ConvertFrom-Json
           #$query=$query.value
           return $query
        }
    }
    $ClientSecretDetails=$false
    $flag=$false
    foreach($inp in $GetInput){
        if($inp.StartsWith('[') -and $inp.Contains($domain)){
            $flag=$true
            $ClientSecretDetails=$true
        }
        if($flag){
            if($inp.Contains("client_id")){
                $appId =$inp.ToString().Substring($inp.IndexOf('~')+1)
            }
            if($inp.Contains("client_secret")){
                $appSecret =$inp.ToString().Substring($inp.IndexOf('~')+1)
            }
            if($inp.Contains("TenantName")){
                $tenantID=$inp.ToString().Substring($inp.IndexOf('~')+1)
            }
            if($inp.Contains("Authority")){
                $authString = $inp.ToString().Substring($inp.IndexOf('~')+1)
                $authString=$authString+$domain
            }
            if($inp.Contains("Resource")){
                $Resource =$inp.ToString().Substring($inp.IndexOf('~')+1)
                $flag=$false            
            }
        }
    }

    if($ClientSecretDetails){
        $path=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
        Add-Type -Path $path
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($Resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()
        $header = @{
            'Authorization'=$authCode
        }

        $O365Servicesurl= "https://graph.microsoft.com/v1.0/admin/serviceAnnouncement/issues"
        while($true){
            $serv= Eg-InvokeUrl -Url $O365Servicesurl  -header $header
            $values=$serv.value
            foreach($issue in $values){
                $Status = ($issue.Status).Trim()
                $ID = $issue.id
                $title = $issue.title
                $ServiceName=($issue.service).Trim()
                $Startime=$issue.startDateTime
                $Endtime =$issue.endDateTime
                $lastupdated=$issue.lastModifiedDateTime
                #$messages=$issue.impactDescription
                $FeatureName= $issue.Feature
                $type=($issue.classification).Trim()

                Eg-WriteLog -writString ('Incidents ID -->>'+$ID+" -- "+$ServiceName) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $true
                if($ServiceName -eq 'Skype for Business' -and $issue.isResolved -ne 'True' -and $statusVal -match $Status){
                    $post=$issue.posts|select -Last 1
                    $messages=$post.description
                    if($type -eq "incident"){
                        Write-Host $type  ~!~ "NOTOKSERVICE" ~!~  $Status ~!~  $ID ~!~  $title ~!~  $Status   ~!~  $ServiceName ~!~  $Startime ~!~  $Endtime ~!~  $lastupdated ~!~  $FeatureName ~!~ $messages "##msage##"
                        Eg-WriteLog -writString ('OUTPUT -->> '+$type+'~'+$Status+'~'+$ID+'~'+$title+'~'+$ServiceName) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $true
                    }
                    elseif($type -eq "advisory"){
                        Write-Host $type ~!~ "ADVISORY" ~!~ $Status ~!~  $ID ~!~  $title ~!~  $Status   ~!~  $ServiceName ~!~  $Startime ~!~  $Endtime ~!~  $lastupdated ~!~  $FeatureName ~!~  $messages "##msage##"
                        Eg-WriteLog -writString ('OUTPUT -->> '+$type+'~'+$Status+'~'+$ID+'~'+$title+'~'+$ServiceName) -LogPath $logPath -ReportingName $rptNam -TestFreq $testFrequency -isWriteLog $true
                    }
                }
            }
            if($serv."@odata.nextLink" -eq $null -or $serv."@odata.nextLink" -eq ''){
                break;
            }else{
                $O365Servicesurl=($serv."@odata.nextLink")
            }
        }
    }
}
[System.GC]::GetTotalMemory($true) | out-null
