﻿#Requires -Version 3.0
#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
	Creates an inventory of a Citrix PVS Sites details.
.DESCRIPTION
	Creates an inventory of a Citrix PVS Sites details using Microsoft PowerShell.
	
	The PVS Console must be installed and the snap-in registered on the computer running 
	the script.
	
	For Windows 8.x, Server 2012 and later, run:
	
	For 32-bit:
	%systemroot%\Microsoft.NET\Framework\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	For 64-bit:
	%systemroot%\Microsoft.NET\Framework64\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	
.INPUTS
	None.  You cannot pipe objects to this script.
.OUTPUTS
	No objects are output from this script.  
.NOTES
    Test	: PVSSitesTest_cf
	
	Measures:
        1.Site description
	    2.Groups with Site Administrtor access
	    3.Administrator credentials used for Multiple Access Key (MAK) enabled devices.
	    4.Default collection name (if auto-add enabled in Farm properties)
	    5.Seconds between vDisk inventory scans
	    6.Automatic vDisk update enabled
	    7.vDisk update server name
#>

#endregion

#region initialize variables
$SaveEAPreference = $ErrorActionPreference
$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False  

$global:CONST_SCRIPT_START = "***Start_Citrix_PVS_server_config_data_***";
$global:CONST_SCRIPT_END = "***End_Citrix_PVS_server_config_data_***";
$global:CONST_DELIMITER = "~#~";

Add-PSSnapin Citrix.PVS.SnapIn
#endregion

Function getPvsSitesDetails
{
    try
    {
        $pvsFarm =  Get-PvsFarm
        
        If($? -and $pvsFarm -ne $Null)
        {
            Write-Host $($CONST_SCRIPT_START)

             $deviceFields = @('SiteName','Description','DefaultCollectionName','InventoryFilePollingInterval','EnableDiskUpdate','DiskUpdateServerName','MakUser')

            $pVSSites = Get-PVSSite -fields $deviceFields -EA 1
	   
            If($? -and $pVSSites -ne $Null)
            {
                 ForEach($pVSSite in $pVSSites)
		         {
                    $authgroups = Get-PVSAuthGroup -SiteName $pVSSite.SiteName -fields AuthGroupName
                   
                    $groupNm = $authgroups.AuthGroupName
					$groupNms = $groupNm -join ","
                    $siteName = $pVSSite.SiteName;
                    $description = $pVSSite.Description;
                    $defaultCollectionName = $pVSSite.DefaultCollectionName;
                    $invntryFileInterval = $pVSSite.InventoryFilePollingInterval;
                    $enableDiskUpdate = $pVSSite.EnableDiskUpdate;
                    $diskUpdateServerName = $pVSSite.DiskUpdateServerName;
                    $makUser = $pVSSite.MakUser;
					
                    Write-Host "SiteName: $($siteName) $($CONST_DELIMITER) Description: $($description) $($CONST_DELIMITER) SecurityGroup: $($groupNms) $($CONST_DELIMITER) DefaultCollectionName: $($defaultCollectionName) $($CONST_DELIMITER) InventoryFilePollingInterval: $($invntryFileInterval) $($CONST_DELIMITER) EnableDiskUpdate: $($enableDiskUpdate) $($CONST_DELIMITER)  DiskUpdateServerName: $($diskUpdateServerName) $($CONST_DELIMITER)  MakUser: $($makUser)";  
                }
            } 
        }
    }
    catch
    {
	    $global:isErrorOccured = $True
	    Write-Host " PVSSitesTest_cf powershell script Exception ";
        Write-Host $_
    }

    If(-Not $isErrorOccured)
    {
	    Write-Host $CONST_SCRIPT_END
    }
}

getPvsSitesDetails
Remove-PSSnapin Citrix.PVS.SnapIn