﻿#Requires -Version 3.0
#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
	Creates an inventory of a Citrix PVS Device Collections details.
.DESCRIPTION
	Creates an inventory of a Citrix PVS Device Collections details using Microsoft PowerShell.
	
	The PVS Console must be installed and the snap-in registered on the computer running 
	the script.
	
	For Windows 8.x, Server 2012 and later, run:
	
	For 32-bit:
	%systemroot%\Microsoft.NET\Framework\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	For 64-bit:
	%systemroot%\Microsoft.NET\Framework64\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	
.INPUTS
	None.  You cannot pipe objects to this script.
.OUTPUTS
	No objects are output from this script.  
.NOTES
    Test	: PVSCollectionTest_cf (PVS Collections)
	
	Measures:
		1.Description
		2.Template target device
		3.Device prefix
		4.Maximum length of device number for auto-add
		5.Zero fill enabled
		6.Device suffix
		7.Last incremental number
#>

#endregion

#region initialize variables
$SaveEAPreference = $ErrorActionPreference
$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False  

$global:CONST_SCRIPT_START = "***Start_Citrix_PVS_server_config_data_***";
$global:CONST_SCRIPT_END = "***End_Citrix_PVS_server_config_data_***";
$global:CONST_DELIMITER = "~#~";

Add-PSSnapin Citrix.PVS.SnapIn

#endregion

Function getPvsDeviceCollectionDetails
{   
    try
    {
        $pvsFarm =  Get-PvsFarm

        #IF pvsFarm object is available then only return script start tag and Pvs Device Collection Details script output.
        If($? -and $pvsFarm -ne $Null)
	    {
	        Write-Host $($CONST_SCRIPT_START)  
        
			$rqrdFields = @('Name','TemplateDeviceName','Description','AutoAddPrefix','AutoAddNumberLength','AutoAddSuffix','LastAutoAddDeviceNumber','AutoAddZeroFill')
		
            $pvsCollectionObjs = Get-PvsCollection -fields $rqrdFields
        
			If($? -and $pvsCollectionObjs -ne $Null)
			{				
				ForEach($currentCollectionObj in $pvsCollectionObjs)
				{	
					$name = $currentCollectionObj.Name;
					$description = $currentCollectionObj.Description;
					$templateDvcNm = $currentCollectionObj.TemplateDeviceName;
					$prefix = $currentCollectionObj.AutoAddPrefix;
					$length = $currentCollectionObj.AutoAddNumberLength;
					$suffix = $currentCollectionObj.AutoAddSuffix;
					$lastAutoAdd = $currentCollectionObj.LastAutoAddDeviceNumber;
					$zeroFill = $currentCollectionObj.AutoAddZeroFill;
				
					Write-Host "Name: $($name) $($CONST_DELIMITER) Description: $($description) $($CONST_DELIMITER)  TemplateDeviceName: $($templateDvcNm) $($CONST_DELIMITER)  Prefix: $($prefix) $($CONST_DELIMITER) Length: $($length) $($CONST_DELIMITER) Suffix: $($suffix) $($CONST_DELIMITER) LastAutoAdd: $($lastAutoAdd)  $($CONST_DELIMITER) ZeroFill: $($zeroFill)";
				}
			}
		}
    }
    catch
    {
	    $global:isErrorOccured = $True
	    Write-Host " PVSCollectionTest_cf powershell script Exception ";
        Write-Host $_
    }

    If(-Not $isErrorOccured)
    {
	    Write-Host $CONST_SCRIPT_END
    }
}

getPvsDeviceCollectionDetails
Remove-PSSnapin Citrix.PVS.SnapIn
