﻿#$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
#$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear

#Set LOG Location
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$logDir=$egurkhaPath+'\agent\O365'
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$logFile=$logDir+'\O365_prerequisites.log'
#Remove-Item -Path $logFile

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

$osNam='N/A';$csdVersion='N/A';$sysType='N/A'
Try{
    $os=[String](Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).Name
    $osNam=$os.Substring(0,$os.IndexOf('|')).Trim() #(Microsoft Windows 7 Professional |C:\Windows|\Device\Harddisk0\Partition2)
    $csdVersion=(Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).CSDVersion #(Service Pack 1)
    $sysType=(Get-WMIObject win32_operatingsystem -ErrorAction SilentlyContinue).OSArchitecture #(64-bit)
    Write-Host 'SYSTEM INFO - ' $osNam ' -- ' $csdVersion '--' $sysType
}Catch{Write-Host 'SYSTEM INFO - ' $osNam ' -- ' $csdVersion '--' $sysType}

#Set Download Location

$DownloadLocation = $env:USERPROFILE+'\downloads\O365\step1'
if(!(Test-Path -Path $DownloadLocation)){
    $null=New-Item -ItemType directory -Path $DownloadLocation
}
Write-Host 'Download Location - ' $DownloadLocation
$stTim1=Get-Date
O365-WriteLog -writString "******************************************** O365_Step1_ModulesDwnldnInstall ********************************************" -LogPath $logFile -ReportingName 'Script'
O365-WriteLog -writString "O365_Step1_ModulesDwnldnInstall started at $stTim1" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString $osNam ' -- ' $csdVersion '--' $sysType -LogPath $logFile -ReportingName 'SYSTEM INFO'
O365-WriteLog -writString $DownloadLocation -LogPath $logFile -ReportingName 'Download Location'

function Unzip{
    param([string]$zipfile, [string]$outpath)
    #[System.IO.Compression.ZipFile]::ExtractToDirectory($zipfile, $outpath)
    $shell_app=new-object -com shell.application
    $zip_file = $shell_app.namespace($zipfile)
    $destination = $shell_app.namespace($outpath)
    $destination.Copyhere($zip_file.items())
}

function Proceed-Download(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$APPName, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$APPFile
    )
    Process
    {
        Try{
            if($APPFile -match '#'){
                $arr=$APPFile -split '#'
                $appDst=$arr[0].Substring($arr[0].LastIndexOf('/')+1)
                $dest=$DownloadLocation+'\'+$appDst
                if((Get-Host).Version.Major -le 3){
                    $wc=New-Object System.Net.WebClient
                    $wc.DownloadFile($arr[0],$dest)
                }else{
                    $isPresent=Test-Path $dest -PathType Leaf
                    if(!$isPresent){
                        Try{
                            Write-Host $APPName '- Download started...' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading started' -LogPath $logFile -ReportingName $APPName
                            Start-BitsTransfer -Source $arr[0] -Destination $dest -TransferType Download -Description "Transfering $APPName" -ErrorAction Stop
                            Write-Host $APPName '- Download completed!' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading completed' -LogPath $logFile -ReportingName $APPName
                        }Catch{
                            Write-Host $APPName '- Download not completed or failed!' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading not completed or failed' -LogPath $logFile -ReportingName $APPName
                        }
                    }
                }
                Unzip -zipfile $dest -outpath $DownloadLocation
                #$dest=$dest.Replace(".zip",$arr[1])
                #$installHash.Add($dest,$APPName)
            }else{
                $appDst=$APPFile.Substring($APPFile.LastIndexOf('/')+1)
                $dest=$DownloadLocation+'\'+$appDst
                if((Get-Host).Version.Major -le 3){
                    $wc=New-Object System.Net.WebClient
                    $wc.DownloadFile($APPFile,$dest)
                }else{
                    $isPresent=Test-Path $dest -PathType Leaf
                    if(!$isPresent){
                        Try{
                            Write-Host $APPName '- Download started...' -ForegroundColor Green
                            O365-WriteLog -writString 'Download started...' -LogPath $logFile -ReportingName $APPName
                            Start-BitsTransfer -Source $APPFile -Destination $dest -TransferType Download -Description "Transfering $APPName" -ErrorAction Stop
                            Write-Host $APPName '- Download completed!' -ForegroundColor Green
                            O365-WriteLog -writString 'Download completed!' -LogPath $logFile -ReportingName $APPName
                        }Catch{
                            Write-Host $APPName '- Download not completed or failed!' -ForegroundColor Green
                            O365-WriteLog -writString 'Download not completed or failed!' -LogPath $logFile -ReportingName $APPName
                        }
                    }
                }       
            }
        }Catch{
                Write-Host "Download Failed" $Exception.Message -ForegroundColor Red
        }
    }      
}


$preDwnldHash=@{}
$installHash=@{}

$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$tstIniPath=$egurkhaPath+'\agent\config\O365_Prerequisites.ini'
$iniContent=get-content -Path $tstIniPath
$lineStr=''
$isReadStrt=$false
foreach($line in $iniContent){
    if($isReadStrt -and $line.StartsWith('Step1_Ins')){
        $lineStr=$line
        break
    }
    if($line.StartsWith('[Step1-')){
        $isReadStrt=$true
    }
}

$lineStr=$lineStr.Replace('Step1_Ins=','')
$fileArr=$lineStr.Split('~')
foreach($file in $fileArr){
    $argsArr=$file.Split('@')
    $appDst=$argsArr[1].Substring($argsArr[1].LastIndexOf('/')+1)
    $dest=$DownloadLocation+'\'+$appDst
    $isPresent=Test-Path $dest -PathType Leaf
    if($isPresent){
        $installHash.Add($dest,$argsArr[0])  
    }
    else{
        $preDwnldHash.Add($argsArr[0],$argsArr[1])
        $installHash.Add($dest,$argsArr[0])
    }  
}

$proceedInstall=$False
if($preDwnldHash.Count -ne 0){
    $message = @("Download the below?")
    $message+=" "
    foreach($key in $preDwnldHash.Keys){
    $message+=' -> '+$key
    }
    $res=[system.windows.forms.messagebox]::show(($message -join "`n"),"Download",'YesNo')
    if($res -eq 'Yes'){
        foreach($key in $preDwnldHash.Keys){
            Proceed-Download -APPName $key -APPFile $preDwnldHash[$key]
        } 
        $proceedInstall=$true    
    }else{
        Write-Host 'You cancelled the download...'
        O365-WriteLog -writString 'You cancelled the download...' -LogPath $logFile -ReportingName 'Download'
    }
}else{
    $msg = @("Downloads available in")
    $msg+=$DownloadLocation
    $msg+=" "
    $msg+="Proceed with installation?"
    $procdIns=[system.windows.forms.messagebox]::show(($msg -join "`n"),"Download",'YesNo')
    if($procdIns -eq 'Yes'){
        $proceedInstall=$true
    }else{
        Write-Host 'You cancelled the installation ....'
        O365-WriteLog -writString 'You cancelled the installation ....' -LogPath $logFile -ReportingName 'Install'
    }
}

if($proceedInstall){
    $insMsg=@("Install the below?")
        $insMsg+=" "
        foreach($key in $installHash.Keys){
            $insMsg+=' -> '+$installHash[$key]
        }
        $insRes=[system.windows.forms.messagebox]::show(($insMsg -join "`n"),"Installation",'YesNo')
        if($insRes -eq 'Yes'){
            foreach($key in $installHash.Keys){
                Try{
                    $processId=(Start-Process $key -ArgumentList '/norestart' -PassThru ).Id
                    Write-Host $installHash[$key]' Installation process started!' -ForegroundColor Yellow
                    O365-WriteLog -writString 'Installation process started' -LogPath $logFile -ReportingName $installHash[$key]
                    $status = ((ps | where {$_.Id -eq $processId} | select HasExited,ExitCode).HasExited).ToString().Trim()
                    if($status -eq 'False'){
                        Wait-Process -Id $processId -Timeout 120
                    }
                    Write-Host $installHash[$key]' Installation process completed!' -ForegroundColor Yellow
                    O365-WriteLog -writString 'Installation process completed' -LogPath $logFile -ReportingName $installHash[$key]
                }Catch{
                    Write-Host 'Installation failed!' -ForegroundColor Red
                    O365-WriteLog -writString 'Installation process not completed or failed' -LogPath $logFile -ReportingName $installHash[$key]
                } 
            }
        }else{
            Write-Host 'You cancelled the installation ....'
            O365-WriteLog -writString 'You cancelled the installation ....' -LogPath $logFile -ReportingName 'Install'
        }
}

$edTim1=Get-Date
O365-WriteLog -writString "O365_Step1_ModulesDwnldnInstall ended at $edTim1" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'