﻿##/******************************************************************************************
##Author                :     MohanRaj S
##Purpose               :     Display the License available in O365 and their License details
##Created               :     06/12/2017
##Modified By		    :     Prabaharan.T

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear

$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$reprt=$TestInputs[4]
$rptndfrqcy=$reprt.split('#')
$reportingNam=$rptndfrqcy[0]
$topN_dd=$rptndfrqcy[1]
$proxyserverip=($rptndfrqcy[2]).ToString().trim()
$tenantName=$TestInputs[5]

$MyDir=$egurkhaPath+'/agent/O365/'+$reportingNam+'/Debug'
if(!(Test-Path -Path $MyDir )){
    New-Item -ItemType directory -Path $MyDir
}
$WriteLog=$false
$LogFile = $MyDir+"\O365UserLog.log"
$LogFile1 = $MyDir+"\O365UserLog1.log"
$isFrstTimLog=$false

# Writes output to a log file with a time date stamp
Function Write-Log {
	Param ([string]$string)
	[string]$date = Get-Date -Format G
    if ($WriteLog) {
        ( "[" + $date + "] - [Debug] -" + $string ) | Out-File -FilePath $LogFile -Append } 
    if($isFrstTimLog){     
        if ($WriteLog -eq $true){ #if flag is true 
            if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $LogFile1 
                } 
                Rename-Item $LogFile $LogFile1 
            }
        }
        $isFrstTimLog=$false
    }
}



if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
Try{

    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')
    $langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
    $encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
    $am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
    $pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp
     
    $cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
    if(!$proxyserverip.Contains('none')){
        $proxyserver='http://'+$proxyserverip
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
        if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        }
     }

    if(!$tenantName -or $tenantName -eq 'none'){
    	Connect-MsolService -Credential $cred -AzureEnvironment $azureEnvArr[0]
    }
    $chkEnd=[datetime](Get-Date).AddDays(+6).ToUniversalTime()
    $chkStart=[datetime](Get-Date).AddDays(-1).ToUniversalTime()

    $dmnPwdExp=@{}
    $allowedcount = 0 
    $blockedcount = 0
    $TotalUsers = 0
    $licensecount = 0
    $enabledMFA = 0
    $disabledMFA = 0
    $enforcedMFA = 0
    $unlicensecount = 0
    $ExternalUsrCount=0
    $Passnevercount = 0
    $deletedcount = 0
    $nextexpiry = 0
    $rptPath='O365/'+$reportingNam
    #---------------START CMDLET------------------
    try{
        $readArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
        if($readArr -ne $null -and [System.IO.File]::Exists($readArr[1]) -eq 'True'){
            $unProtctMUsr=$readArr[1] -replace (".csv",".dat") 
            $musrPath=Unprotect-File $unProtctMUsr -Algorithm AES -KeyAsPlainText $readArr[0]	
            $usersview= import-csv $musrPath -Encoding $encTyp
            Remove-Item $musrPath
            Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'O365msolUsr' -InputFile $readArr[3]
            Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'kO365msolUsr' -InputFile $readArr[4]
        }
    }
    catch{
        $errmsg=$_.Exception.Message
        Write-Error -Message $errmsg
    }
    [System.GC]::GetTotalMemory($true) | out-null

    #---------------START CMDLET------------------
    if(!$tenantName -or $tenantName -eq 'none'){
        try{
            $delUsrRArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolDelUsr" -keyFileName "kO365msolDelUsr" -EgPath $egurkhaPath
            if($delUsrRArr -ne $null -and [System.IO.File]::Exists($delUsrRArr[1]) -eq 'True'){
                $unProtctMDUsr=$delUsrRArr[1] -replace (".csv",".dat") 
                $mdelusrPath=Unprotect-File $unProtctMDUsr -Algorithm AES -KeyAsPlainText $delUsrRArr[0]	
                $deluser= import-csv $mdelusrPath -Encoding $encTyp
                Remove-Item $mdelusrPath
                Eg-DeleteFiles -FilePath $delUsrRArr[2] -Pattern 'O365msolDelUsr' -InputFile $delUsrRArr[3]
                Eg-DeleteFiles -FilePath $delUsrRArr[2] -Pattern 'kO365msolDelUsr' -InputFile $delUsrRArr[4]
            }
        }
        catch{
            $errmsg1=$_.Exception.Message
            Write-Host $errmsg1
        }
        [System.GC]::GetTotalMemory($true) | out-null
    }
    #---------------START CMDLET------------------
    try{
        $dmUsrRArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
        if($dmUsrRArr -ne $null -and [System.IO.File]::Exists($dmUsrRArr[1]) -eq 'True'){
            $uPMDomUsr=$dmUsrRArr[1] -replace (".csv",".dat") 
            $mdomusrPath=Unprotect-File $uPMDomUsr -Algorithm AES -KeyAsPlainText $dmUsrRArr[0]	
            $domain= import-csv $mdomusrPath -Encoding $encTyp
            Remove-Item $mdomusrPath
            Eg-DeleteFiles -FilePath $dmUsrRArr[2] -Pattern 'O365msolDomUsr' -InputFile $dmUsrRArr[3]
            Eg-DeleteFiles -FilePath $dmUsrRArr[2] -Pattern 'kO365msolDomUsr' -InputFile $dmUsrRArr[4]
        }
    }
    catch{
        $errmsg2=$_.Exception.Message
        Write-Host $errmsg2
    }
    [System.GC]::GetTotalMemory($true) | out-null

    #---------------START CMDLET------------------
    if(!$tenantName -or $tenantName -eq 'none'){
        Try{
            $passPlcyWArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolpass" -keyFileName "kO365msolpass" -EgPath $egurkhaPath  
        
            foreach($dmn in $domain){
                $valid=((Get-MsolPasswordPolicy -domain $dmn.Name -ErrorAction SilentlyContinue))| Select-Object -Property @{Name='Domain';Expression={$dmn.Name}},ValidityPeriod #|Export-Csv -Append -LiteralPath $passPlcyWArr[1] #-Force
                if($valid -ne $null -and $valid -ne ''){
                    $valid|Export-Csv -Append -LiteralPath $passPlcyWArr[1] -Encoding $encTyp #-Force
                }
            }
            $null=Protect-File  $passPlcyWArr[1] -Algorithm AES -KeyAsPlainText $passPlcyWArr[0] -RemoveSource
            try{
                $passPlcyRArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolpass" -keyFileName "kO365msolpass" -EgPath $egurkhaPath
                if($passPlcyRArr -ne $null -and [System.IO.File]::Exists($passPlcyRArr[1]) -eq 'True'){
                    $mpassPlcyUsr=$passPlcyRArr[1] -replace (".csv",".dat") 
                    $passPlcyPath=Unprotect-File $mpassPlcyUsr -Algorithm AES -KeyAsPlainText $passPlcyRArr[0]	
                    $msolPassword= import-csv $passPlcyPath -Encoding $encTyp
                    for($j=0; $j -lt $msolPassword.Length; $j++){
                        $Domain=$msolPassword[$j].Domain.toString()
                        [int]$ValidityPeriod=$msolPassword[$j].ValidityPeriod
                        $dmnPwdExp.Add($Domain,$ValidityPeriod)
                    }
                    Remove-Item $passPlcyPath
                    Eg-DeleteFiles -FilePath $passPlcyRArr[2] -Pattern 'O365msolpass' -InputFile $passPlcyRArr[3]
                    Eg-DeleteFiles -FilePath $passPlcyRArr[2] -Pattern 'kO365msolpass' -InputFile $passPlcyRArr[4]
                }
            }catch{
                $errmsg3=$_.Exception.Message
                Write-Host $errmsg3
            }  
        }Catch{
	        $egurkhaRprtPath=  $egurkhaPath+'\agent\'+$rptPath+'\'
            $fileRead=Get-ChildItem -Path $egurkhaRprtPath |Where-Object {$_.Name -like 'kO365msolpass*.dat'}| Sort-Object LastWriteTime -Descending | Select Name -First 1
            foreach($file in $fileRead){
                $fileName=([String]$file.Name).Trim()
                if([System.IO.File]::Exists(($egurkhaRprtPath+$fileName)) -eq 'True'){
                    Remove-Item $egurkhaRprtPath$fileName -Force
                }
            }
        }
        [System.GC]::GetTotalMemory($true) | out-null
        $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
        $DateFormat = $CultureDateTimeFormat.ShortDatePattern
        $TimeFormat = $CultureDateTimeFormat.LongTimePattern
        $DateTimeFormat = "$DateFormat $TimeFormat"
        $hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt').Trim()
        if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}
    }

    $TotalUsers=($usersview).Count
    $licensecount=($usersview|Where{$_.IsLicensed -eq $true}).Count
    $usersview=$usersview| Sort-Object UserPrincipalName 
    foreach($pwdexp in $usersview){
        if($pwdexp.PasswordNeverExpires -eq $true){
		if($Passnevercount -lt $topN_dd){
	            Write-Host 'Passnever~'$pwdexp.UserPrincipalName'~'$pwdexp.SignInName'~'$pwdexp.AccId'~'$pwdexp.IsLicensed'~'$pwdexp.UsageLocation'!@!'
		}		
	    $Passnevercount++
        }
        if($pwdexp.IsLicensed -ne $true){
			#Unlicensed internal users
            if(-not  $pwdexp.UserPrincipalName.Contains('#EXT#')){                
		        if($unlicensecount -lt $topN_dd){		       
			        Write-Host 'Unlicensed~'$pwdexp.UserPrincipalName'~'$pwdexp.DisplayName'~'"Unlicensed"'!@!'                    		        
                }
                $unlicensecount++
		    }           
			#Unlicensed external users
		    if($pwdexp.UserPrincipalName.Contains('#EXT#')){                   
               if($ExternalUsrCount -le $topN_dd){
			        Write-Host 'ExternalUsers~'$pwdexp.UserPrincipalName'~'$pwdexp.DisplayName'!@!'                    
               }
               $ExternalUsrCount++
		    }		    		    
        }
        if($pwdexp.BlockCredential -ne $true){
            $allowedcount++
        }else{
		if($blockedcount -lt $topN_dd){
	            Write-Host 'blocked~'$pwdexp.UserPrincipalName'~'$pwdexp.SignInName'~'$pwdexp.AccId'~'$pwdexp.IsLicensed'~'$pwdexp.UsageLocation'!@!'
		}
		
	    $blockedcount++
        }

        if(!$tenantName -or $tenantName -eq 'none'){
        #Mutli Factor Authenication
        if($pwdexp.MFAStatus -ne ''){
            if($pwdexp.MFAStatus -eq 'Enabled'){
                $enabledMFA++
                <#if($enabledMFA -le $showDD){
	                Write-Host 'MFAEnabled~'$pwdexp.UserPrincipalName'~!~'$pwdexp.SignInName'~!~-~!~'$pwdexp.UsageLocation'!@!'
		        }#>
            }
            elseif($pwdexp.MFAStatus -eq 'Enforced'){
                $enforcedMFA++
                <#if($enforcedMFA -le $showDD){
                    Write-Host 'MFAEnforced~'$pwdexp.UserPrincipalName'~!~'$pwdexp.SignInName'~!~-~!~'$pwdexp.UsageLocation'!@!'
                }#>
            }
		}
        else{
            $disabledMFA++
        }
        }else{
            $enabledMFA=-5
            $enforcedMFA=-5
            $disabledMFA=-5
	}
    }

    if(!$tenantName -or $tenantName -eq 'none'){
    foreach($deleteduser in $deluser){
	    if($deletedcount -lt $topN_dd){
	        Write-Host 'usersdeleted~'$deleteduser.UserPrincipalName'~'$deleteduser.SignInName'~'$deleteduser.AccId'~'$deleteduser.IsLicensed'~'$deleteduser.UsageLocation'!@!'
	    }
		
	$deletedcount++
        }
    }else{
        $deletedcount=-5
    }
    if(!$tenantName -or $tenantName -eq 'none'){
    $users = $usersview |  where { $_.PasswordNeverExpires -eq $false } 
    $nextexpiry=0
    foreach($user in $users){
        Try{
            $usrname = $user.UserPrincipalName
            $signname = $user.SignInName
            Write-Log($user.LastPasswordChangeTimestamp+ ' -- ' +$DateTimeFormat)
            $inpDatStr=([String]$user.LastPasswordChangeTimestamp).Trim()
            if($inpDatStr -ne $null -and $inpDatStr -ne ''){
                $passwordSetDate =Eg-ParseExact -dateStr $inpDatStr -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                $domainName= $usrname.substring($usrname.IndexOf('@')+1)
                [int]$maxPasswordAge=$dmnPwdExp[$domainName]
                Write-Log('domainName -->> '+$domainName+' -- '+$dmnPwdExp[$domainName])
                Write-Log('maxPasswordAge -->> '+$maxPasswordAge)
                #Try{
                    if($maxPasswordAge -ne 2147483647){
                        [DateTime] $expireson =$passwordSetDate.addDays($maxPasswordAge)
                        $expireson=$expireson.ToUniversalTime().Date
                        Write-Log('[chkStart&end&expireson] '+$chkStart+' -- '+$chkEnd+' -- '+$expireson)
	                    if((($chkStart.Date) -lt $expireson) -and (($chkEnd.Date) -gt $expireson)){
	                        $userlicAcc =  $user.AccId
	                        $userislic = $user.IsLicensed
	                        $usageloc = $user.UsageLocation
	                        if($usageloc -eq $null){
			                    $usageloc = "-"
	                        }
	                        if($userlicAcc -eq $null -or $userlicAcc -eq ''){
			                    $userlicAcc = "-"
	                        }
			                if($nextexpiry -lt $topN_dd){
		                        Write-Host 'userpassexpire~'$usrname'~'$signname'~'$expireson'~'$userlicAcc'~'$userislic'~'$usageloc'!@!'
                                Write-Log('userpassexpire~'+$usrname+'~'+$signname+'~'+$expireson+'~'+$userlicAcc+'~'+$userislic+'~'+$usageloc)
			                }								
                            $nextexpiry++
                        }
                    }
                #}Catch{}
            }
            }Catch{}
        }
    }
}
    Catch{            
	Write-Host "Error Occured in O365UserLog -- " $_.Exception.Message        
	}

write-host ''
Write-Host 'unlicecnt~'$unlicensecount'!@!'
Write-Host 'deletedcount~' $deletedcount'!@!'
Write-Host 'Pwdnvrcnt~'$Passnevercount'!@!'
Write-Host 'signcount~'$allowedcount'~'$blockedcount'!@!'
Write-Host $(If ($nextexpiry.Equals(0)) {"nextexpire~-5"} Else {'nextexpire~'+$nextexpiry})'!@!'
Write-Host 'TotalUsers~'$TotalUsers'!@!'
Write-Host 'licecnt~'$licensecount'!@!'
Write-Host 'EnabledMFA~'$enabledMFA'!@!'
Write-Host 'EnforcedMFA~'$enforcedMFA'!@!'
Write-Host 'DisabledMFA~'$disabledMFA'!@!'
Write-Host 'extUsrsCnt~'$ExternalUsrCount'!@!'
[System.GC]::GetTotalMemory($true) | out-null