﻿##/******************************************************************************************
##Author                :     Guravareddy T
##Purpose               :     Display the O365 Security Groups
##Created               :     06/21/2018

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$repotingnamendfrq=$TestInputs[4]
$rptndfrqcy=$repotingnamendfrq.split('#')
$reportingName=$rptndfrqcy[0]
$frequency=$rptndfrqcy[1]
$proxyserverip=($rptndfrqcy[2]).ToString().trim()
$rptPath='O365/'+$reportingName
$appDetails=$TestInputs[5]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }


$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
#[System.Net.CredentialCache]::DefaultCredentials=$cred
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }
if($appDetails -and $appDetails -ne 'none'){
        $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
}else{
	Connect-MsolService -Credential $cred -AzureEnvironment $azureEnvArr[0]
	$null=Connect-AzureAD -Credential $cred -AzureEnvironmentName $azureEnvArr[0]
}
 
$totalcnt=0
$emptygrps=0
$orphnedgrps=0
$newgrupscnt=0
$softdeletcnt=0

    #---------------START CMDLET------------------
    Try{
        $writArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365secugrp" -keyFileName "kO365secugrp" -EgPath $egurkhaPath
        Get-AzureADMSGroup | Select-Object * | where-Object { $_.Mail -eq $null}|Export-Csv $writArr[1] -Encoding $encTyp
        $null=Protect-File  $writArr[1] -Algorithm AES -KeyAsPlainText $writArr[0] -RemoveSource
    }Catch{
    $exception=$_.Exception
     Write-Error -Message " The exception while writting data to file $exception " 
    }
    try{
        $readfiles=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365secugrp" -keyFileName "kO365secugrp" -EgPath $egurkhaPath
        if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
            $datafile=$readfiles[1] -replace (".csv",".dat") 
            $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
            $sectygrps= import-csv $csvfile -Encoding $encTyp
            Remove-Item $csvfile
            Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'O365secugrp' -InputFile $readfiles[3]
            Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kO365secugrp' -InputFile $readfiles[4]
            Write-Host "ReadFile:"$readfiles[3]
        }
    }
    catch{
        $errmsg=$_.Exception.Message
        Write-Error -Message $errmsg
    }
     [System.GC]::GetTotalMemory($true) | out-null
#Get-AzureADMSDeletedGroup | Sort-Object DisplayName| Format-Table Id, DisplayName, Description, Visibility
#$sectygrps=Get-AzureADMSGroup | Select-Object * | where-Object { $_.Mail -eq $null} 

#Get-AzureADGroup| Select-Object * | where-Object { $_.Mail -eq $null} 
$startdate=(Get-Date).ToUniversalTime()
$CultureDateTimeFormat = (Get-Culture).DateTimeFormat
$DateFormat = $CultureDateTimeFormat.ShortDatePattern
$TimeFormat = $CultureDateTimeFormat.LongTimePattern
$DateTimeFormat = "$DateFormat $TimeFormat"
$hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt').Trim()
if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}
foreach($grp in $sectygrps)
{
    $totalcnt++
    if($appDetails -and $appDetails -ne 'none'){
        $mebers=Get-AzureADGroupMember -ObjectId $grp.Id | Select-Object displayname
    }else{
    	$mebers=Get-MsolGroupMember -GroupObjectId $grp.Id | Select-Object displayname
    }

    $owner=Get-AzureADGroupOwner -ObjectId $grp.Id | Select-Object displayname
    #$cretntime=$grp.CreatedDateTime
    $grpCreatedDateTim=([String]$grp.CreatedDateTime.Replace('??','')).Trim()
    if($grpCreatedDateTim -ne $null -and $grpCreatedDateTim -ne ''){
        $cretntime=Eg-ParseExact -dateStr $grpCreatedDateTim -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
    } 
    #$cretntime=[DateTime]::ParseExact(($grp.CreatedDateTime),$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)

    try{
        $mebcnt=$mebers.count
    }catch{$mebcnt=0}
    
    if($mebcnt -eq 0 -or $mebcnt -eq $null -or $mebcnt -eq " "){
        $emptygrps++
        Write-Host '##ddEmpty Groups'$grp.DisplayName '~!~' -5
    }
    if(!$owner)
    {
        write-host '>>>>>>'$owner
        $orphnedgrps++
        Write-Host '##ddOrphaned Groups'$grp.DisplayName '~!~' $mebcnt

    }
    write-host $cretntime  '>>' $startdate
    if([DateTime]$cretntime -ge [DateTime]$startdate){
   write-host $cretntime  '>>' $startdate
        $newgrupscnt++
        Write-Host '##ddcreated Groups'$grp.DisplayName '~!~' $mebcnt

    }

    write-host '##ddTotals'$grp.DisplayName '~!~' $mebcnt
}

[System.GC]::GetTotalMemory($true) | out-null

    try{
        $filepath=$egurkhaPath+'/agent/'+$rptPath+'/'
	    $fileread2=Get-ChildItem -Path $filepath |Where-Object {$_.Name -like 'O365secugrp*.dat'}| Sort-Object LastWriteTime -Descending | Select-Object -index 1|Select Name
	    $filepath2=$filepath+$fileread2.Name
	    $datpos = $fileread2.name.IndexOf(".dat")
	    $length='O365secugrp'.Length
	    $tmpvalue = $fileread2.name.toString().substring($length,($datpos-$length)) 
	    $kfileval2 = "kO365secugrp"+$tmpvalue+".dat"
   	    $kfile2=Get-ChildItem -Path $filepath |Where-Object {$_.Name -eq $kfileval2}| Sort-Object LastWriteTime -Descending | Select-Object -first 1|Select Name
	    $kfilename2=([String]$kfile2.Name).Trim()
	    $kvalue2=Get-Content -Path $filepath$kfilename2
	    $decrypPath2=$filepath2 -replace (".csv",".dat") 
	    $recpFile2=Unprotect-File $decrypPath2 -Algorithm AES -KeyAsPlainText $kvalue2	
	    $securitygrp2= import-csv $recpFile2 -Encoding $encTyp
        if([System.IO.File]::Exists($recpFile2) -eq 'True'){
	        Remove-Item $recpFile2
        }
    }
    catch{
        $securitygrp2=""
        $errmsg2=$_.Exception.Message
        Write-Host $errmsg2
    }

    if($securitygrp2 -ne "" -and $securitygrp2 -ne $null){
      foreach($total2 in $securitygrp2)
      {
        $mebcnt=0
        $displayname=$total2.DisplayName
        $bolean=$false
        foreach($total in $sectygrps)
	    {
            if($appDetails -and $appDetails -ne 'none'){
                $mebers=Get-AzureADGroupMember -ObjectId $grp.Id | Select-Object displayname
            }else{
            	$mebers=Get-MsolGroupMember -GroupObjectId $grp.Id | Select-Object displayname
	    }
            $cretntime=$grp.CreatedDateTime
            try{
                $mebcnt=$mebers.count
            }catch{$mebcnt=0}
            if($displayname -eq $total.DisplayName)
            {
                $bolean=$true
	        }
        }

        if($securitygrp2 -ne "" -and $securitygrp2 -ne $null -and $bolean -eq $false)
        {
            Write-Host '##ddsoftdeleted'$total2.DisplayName'~!~'$mebcnt
	       $softdeletcnt++
	    }
       }
     }

write-host '##Totalgrps'$totalcnt
Write-Host '##orphnedgrps'$orphnedgrps
Write-Host '##emptygrps'$emptygrps
Write-Host '##createdgrps'$newgrupscnt
Write-Host '##softdeletedgrps'$softdeletcnt

[System.GC]::GetTotalMemory($true) | out-null
