﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$repNameCompname=($TestInputs[4]).ToString().Split('#')
$reportingNam=$repNameCompname[0]
$CompType=$repNameCompname[1]
#$O365Tenant=$TestInputs[5]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$rptArr=$reportingNam.Split("_")
$rptFoldr=($rptArr[$rptArr.Count-1]).ToLower()
if($rptFoldr -eq 'mtm'){$fldr='MTM'}
elseif($rptFoldr -eq 'sbo'){$fldr='SBO'}
elseif($rptFoldr -eq 'exo'){$fldr='EXO'}
elseif($rptFoldr -eq 'spo'){$fldr='SPO'}
else {$fldr='O365'}

$rptPath=$fldr+'/'+$reportingNam
$LicensesCnt=0

try{
    $readmsolLUsr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365PSmsolAccSku" -keyFileName "kO365PSmsolAccSku" -EgPath $egurkhaPath
    if($readmsolLUsr -ne $null -and [System.IO.File]::Exists($readmsolLUsr[1]) -eq 'True'){
        $unProtctLUsr=$readmsolLUsr[1] -replace (".csv",".dat") 
        $mlUsrPath=Unprotect-File $unProtctLUsr -Algorithm AES -KeyAsPlainText $readmsolLUsr[0]	
        $Licenses= import-csv $mlUsrPath -Encoding $encTyp
        Remove-Item $mlUsrPath
        Eg-DeleteFiles -FilePath $readmsolLUsr[2] -Pattern 'O365PSmsolAccSku' -InputFile $readmsolLUsr[3]
        Eg-DeleteFiles -FilePath $readmsolLUsr[2] -Pattern 'kO365PSmsolAccSku' -InputFile $readmsolLUsr[4]
    }
    [System.GC]::GetTotalMemory($true) | out-null
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}

if($Licenses.Count -ne $null){
    $LicensesCnt= $Licenses.Count
}else{
    $LicensesCnt=1
}

try{
    $readmsolLUsr1=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365PSmsolUsr" -keyFileName "kO365PSmsolUsr" -EgPath $egurkhaPath
    if($readmsolLUsr1 -ne $null -and [System.IO.File]::Exists($readmsolLUsr1[1]) -eq 'True'){
        $unProtctLUsr1=$readmsolLUsr1[1] -replace (".csv",".dat") 
        $mlUsrPath1=Unprotect-File $unProtctLUsr1 -Algorithm AES -KeyAsPlainText $readmsolLUsr1[0]	
        $users= import-csv $mlUsrPath1 -Encoding $encTyp
        Remove-Item $mlUsrPath1
        Eg-DeleteFiles -FilePath $readmsolLUsr1[2] -Pattern 'O365PSmsolUsr' -InputFile $readmsolLUsr1[3]
        Eg-DeleteFiles -FilePath $readmsolLUsr1[2] -Pattern 'kO365PSmsolUsr' -InputFile $readmsolLUsr1[4]
    }
    [System.GC]::GetTotalMemory($true) | out-null
}
catch{
    $errmsg1=$_.Exception.Message
    Write-Error -Message $errmsg1
}

$DisabledHash = @{} 
$PendingActivationHash = @{} 
$PendingProvisionHash = @{} 
$PendingInputHash = @{} 
$OthersHash = @{} 
$SuccessHash= @{}
$measurehash=@{}
$tmpServiceName=$null

$SPOServiceName=@()
$SBOServiceName=@()
$EXOServiceName=@()
$MTMServiceName=@()
$tests=Get-content -Path $egurkhaPath'\agent\config\eg_tests.ini'
$firstEntry=$false
    foreach($testsini in $tests){
        if($testsini -eq '[AGENT_SETTINGS]'){
            $firstEntry=$true
        }
        elseif($testsini.StartsWith("[")){
            $firstEntry=$false
        }
        if($firstEntry){
            if($testsini.StartsWith("ExcludeO365Service")){
                $ExcludeService= $testsini.Split("=")[1].Split(",")
            }
        }
    }

    $firstEntry=$false
    foreach($testsini in $tests){
        if($testsini -eq '[O365_Subscriptions]'){
            $firstEntry=$true
        }
        elseif($testsini.StartsWith("[")){
            $firstEntry=$false
        }
        if($firstEntry){
            if($testsini -ne '[O365_Subscriptions]'){           
                $valAndOpt= $testsini.Split("=")
                $testsini=$testsini.ToUpper()
                $ExternalName=$valAndOpt[0]
                if($ExcludeService -contains ($ExternalName)){
                    continue
                }
                if($testsini.Contains("EXCHANGE")){
                    $EXOServiceName+="$ExternalName"
        	    }
			    elseif($testsini.Contains("LYNC") -or $testsini.Contains("SKYPE")){
                    $SBOServiceName+="$ExternalName"
			    }
			    elseif($testsini.Contains("SHAREPOINT")){
				    $SPOServiceName+="$ExternalName"
			    }
			    elseif($testsini.Contains("MICROSOFT TEAMS")){
				    $MTMServiceName+="$ExternalName"
			    }
            }
        }
    }

    if($CompType -eq 'SBO'){
        $tmpServiceName=$SBOServiceName
    }
    elseif($CompType -eq 'SPO'){
        $tmpServiceName=$SPOServiceName
    }
    elseif($CompType -eq 'EXO'){
        $tmpServiceName=$EXOServiceName
    }
    elseif($CompType -eq 'MTM'){
        $tmpServiceName=$MTMServiceName
    }
    for($k=0; $k -lt $LicensesCnt; $k++){ 
        $LicenseAccountSKUID = $Licenses[$k].AccountSKUID
        $SvcsCnt = $Licenses[$k].Status.split('~').count
        foreach($userstmp in $users){
            $UserAccountSKUID=$userstmp.AccId
                if($LicenseAccountSKUID -eq $UserAccountSKUID){      
                    for($j=0; $j -lt $SvcsCnt; $j++){
                        $ServiceName=$userstmp.ServiceName.Split(' ')
                        $ProvisioningStatus=$userstmp.ProvisioningStatus.Split(' ')
                        $SrvcName = $ServiceName[$j]
                        $SrvcStatus = $ProvisioningStatus[$j]
                        $UserName = $userstmp.UserName
                        $supportFlow=$false
                        if($SrvcName -ne $null -and $tmpServiceName -eq $null){ 
                            $supportFlow=$true
                        }
                        elseif($tmpServiceName -contains ($SrvcName)){
                            $supportFlow=$true
                        }
                        if($supportFlow){
                            $key = $UserName+'~'+$LicenseAccountSKUID+'~'+$SrvcName
                            $licSrvKey = $LicenseAccountSKUID +'~'+$SrvcName
                            $key1 = $LicenseAccountSKUID
                            if($measurehash.ContainsKey($key1)){
                                $tmparr=[int[]]$measurehash[$key1]
                                if($SrvcStatus -eq 'PendingActivation'){ 
                                    $tmparr[0]+=1
                                }
				                elseif ($SrvcStatus -eq 'PendingProvisioning'){ 
                                    $tmparr[1]+=1
                                }
                                elseif($SrvcStatus -eq 'PendingInput'){ 
                                    $tmparr[2]+=1
                                }
                                elseif($SrvcStatus -eq 'Success'){ 
                                    $tmparr[3]+=1
                                }
                                elseif($SrvcStatus -eq 'Disabled'){ 
                                    $tmparr[4]+=1
                                }
                            }
                            else{
                                $Disabledcnt=0
                                $PendingActivationcnt=0
                                $PendingProvisioncnt=0 
                                $PendingInputcnt=0
                                $Successcnt=0
                                if ($SrvcStatus -eq 'PendingProvisioning'){ 
                                    $PendingProvisioncnt=1
                                }
                                elseif($SrvcStatus -eq 'PendingActivation'){ 
                                    $PendingActivationcnt = 1
                                }
                                elseif($SrvcStatus -eq 'PendingInput'){ 
                                    $PendingInputcnt = 1
                                }
                                elseif($SrvcStatus -eq 'Success'){ 
                                    $Successcnt= 1
                                }
                                elseif($SrvcStatus -eq 'Disabled'){ 
                                    $Disabledcnt =1
                                }
                                [int[]]$measurearr =$PendingActivationcnt,$PendingProvisioncnt,$PendingInputcnt,$Successcnt,$Disabledcnt
                                $measurehash.add($key1,$measurearr)
                            }
                        if ($SrvcStatus -eq 'PendingProvisioning'){
                            if($PendingProvisionHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$PendingProvisionHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $PendingProvisionHash.add($licSrvKey, $ddarr)
                            }                              
                        }
                        elseif($SrvcStatus -eq 'PendingActivation'){
                            if($PendingActivationHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$PendingActivationHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $PendingActivationHash.add($licSrvKey, $ddarr)
                            }
                        }
                        elseif($SrvcStatus -eq 'PendingInput'){ 
                            if($PendingInputHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$PendingInputHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $PendingInputHash.add($licSrvKey, $ddarr)
                            }                                
                        }
                        elseif($SrvcStatus -eq 'Success'){
                            if($SuccessHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$SuccessHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $SuccessHash.add($licSrvKey, $ddarr)
                            }
                        }
                        elseif($SrvcStatus -eq 'Disabled'){ 
                            if($DisabledHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$DisabledHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $DisabledHash.add($licSrvKey, $ddarr)
                            }
                        }
                    }
                }
            }
        }
    }
    foreach($Hkey in $PendingActivationHash.keys){
        $HValue = $PendingActivationHash[$Hkey]
        Write-Host 'PendingActivationDD~'$Hkey'~'$HValue 
    }

    foreach($Hkey in $PendingProvisionHash.keys){
        $HValue = $PendingProvisionHash[$Hkey]
        Write-Host 'PendingProvisionDD~'$Hkey'~'$HValue 
    }

    foreach($Hkey in $PendingInputHash.keys){
        $HValue = $PendingInputHash[$Hkey]
        Write-Host 'PendingInputDD~'$Hkey'~'$HValue 
    }
    foreach($Hkey in $SuccessHash.keys){
        $HValue = $SuccessHash[$Hkey]
        Write-Host 'SuccessDD~'$Hkey'~'$HValue 
    }

    foreach($Hkey in $DisabledHash.keys){
        $HValue = $DisabledHash[$Hkey]
        Write-Host 'DisabledtDD~'$Hkey'~'$HValue 
    }
    foreach($Hkey in $measurehash.keys){
        $HValue = $measurehash[$Hkey]
        $HValue =$HValue -join '~'
        Write-Host 'MeasureCnt~'$Hkey '~' $HValue
    }

    [System.GC]::GetTotalMemory($true) | out-null