﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
clear

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G 
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

Function GetRequiredPermissions($requiredDelegatedPermissions, $requiredApplicationPermissions, $reqsp) {
    $sp = $reqsp
    $appid = $sp.AppId
    $requiredAccess = New-Object Microsoft.Open.AzureAD.Model.RequiredResourceAccess
    $requiredAccess.ResourceAppId = $appid
    $requiredAccess.ResourceAccess = New-Object System.Collections.Generic.List[Microsoft.Open.AzureAD.Model.ResourceAccess]
    if ($requiredDelegatedPermissions) {
        AddResourcePermission $requiredAccess -exposedPermissions $sp.Oauth2Permissions -requiredAccesses $requiredDelegatedPermissions -permissionType "Scope"
    } 
    if ($requiredApplicationPermissions) {
        AddResourcePermission $requiredAccess -exposedPermissions $sp.AppRoles -requiredAccesses $requiredApplicationPermissions -permissionType "Role"
    }
    return $requiredAccess
}

Function AddResourcePermission($requiredAccess, $exposedPermissions, $requiredAccesses, $permissionType) {
    foreach ($permission in $requiredAccesses) {
        $reqPermission = $null
        $reqPermission = $exposedPermissions | Where-Object {$_.Value -contains $permission.Value}
        $resourceAccess = New-Object Microsoft.Open.AzureAD.Model.ResourceAccess
        $resourceAccess.Type = $permissionType
        $resourceAccess.Id = $reqPermission.Id    
        $requiredAccess.ResourceAccess.Add($resourceAccess)
    }
}


$certDir=$egurkhaPath+'\agent\O365\AppInfo'
if(!(Test-Path -Path $certDir)){
    $null=New-Item -ItemType directory -Path $certDir
}

$grphDir=$egurkhaPath+'\agent\O365\MsGraph'
if(!(Test-Path -Path $grphDir)){
    $null=New-Item -ItemType directory -Path $grphDir
}
$logFile=$grphDir+'\O365_GraphApi.log'


$tstIniPath=$egurkhaPath+'\agent\config\O365_Prerequisites.ini'
$iniContent=get-content -Path $tstIniPath
$lineStr=''
$isReadStrt=$false
$isMASupport=$false
foreach($line in $iniContent){
    if($isReadStrt -and $line.StartsWith('Modern_Auth_Supported=')){
        if($line -match 'true'){
            $isMASupport=$true
            $isReadStrt=$false
        }
    }
    if($line.StartsWith('[Modern_Auth_Support')){
        $isReadStrt=$true
    }
}

if($isMASupport){
    $certBasedRes=[system.windows.forms.messagebox]::show(("Connect to O365 using `"Modern Authentication`"?" -join "`n"),"O365 Graph API",'YesNo')
}else{
    $certBasedRes='No'
}


######***GUI****#######
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()

   $form = New-Object System.Windows.Forms.Form
    $buttonOK = New-Object System.Windows.Forms.Button
    $textbox1=New-Object System.Windows.Forms.TextBox
    $label1=New-Object System.Windows.Forms.Label
    $textbox2=New-Object System.Windows.Forms.TextBox
    $label2=New-Object System.Windows.Forms.Label

    $textbox3=New-Object System.Windows.Forms.TextBox
    $label3=New-Object System.Windows.Forms.Label
    $textbox4=New-Object System.Windows.Forms.TextBox
    $label4=New-Object System.Windows.Forms.Label
    $label5=New-Object System.Windows.Forms.Label

    $O365DtlsLbl=New-Object System.Windows.Forms.Label
    $O365UsrLbl=New-Object System.Windows.Forms.Label
    $O365UsrTxtBx=New-Object System.Windows.Forms.TextBox
    $O365PassLbl=New-Object System.Windows.Forms.Label
    $O365PassTxtBx=New-Object System.Windows.Forms.TextBox
    
    $totalvalues = ($onames.count)
    $formsize = 270 + (30 * $totalvalues)
    $flowlayoutsize = 10 + (30 * $totalvalues)
    $buttonplacement = 210 + (30 * $totalvalues)

    $form.Controls.Add($O365DtlsLbl)
    $form.Controls.Add($O365UsrLbl)
    $form.Controls.Add($O365UsrTxtBx)
    $form.Controls.Add($O365PassLbl)
    $form.Controls.Add($O365PassTxtBx)
    $form.Controls.Add($label5)
    $form.Controls.Add($label1)
    $form.Controls.Add($textbox1)
    $form.Controls.Add($label2)
    $form.Controls.Add($textbox2)
    $form.Controls.Add($label3)
    $form.Controls.Add($textbox3)
    $form.Controls.Add($label4)
    $form.Controls.Add($textbox4)
    $form.Controls.Add($buttonOK)
    $form.AcceptButton = $buttonOK
    $form.AutoScaleDimensions = '8, 17'
    $form.AutoScaleMode = 'Font'
    $form.ClientSize = "380 , $formsize"
    $form.FormBorderStyle = 'FixedDialog'
    $form.Margin = '5, 5, 5, 5'
    $form.MaximizeBox = $False
    $form.MinimizeBox = $False
    $form.Name = 'form1'
    $form.StartPosition = 'CenterScreen'
    $form.Text = 'O365 Graph API'
    $form.add_Load($($form_Load))

    $O365DtlsLbl.Location="38,15"
    $O365DtlsLbl.Anchor="Bottom, Left"
    $O365DtlsLbl.Text="&O365 Details :"
    $O365DtlsLbl.Size="100,20"

    $O365UsrLbl.Location="38,38"
    $O365UsrLbl.Anchor="Bottom, Left"
    $O365UsrLbl.Text="&Username"
    $O365UsrLbl.Size="60,20"

    $O365UsrTxtBx.Location="105,38"
    $O365UsrTxtBx.Name="O365User"
    $O365UsrTxtBx.Size="200,20"
    $O365UsrTxtBx.Text="none"

    $O365PassLbl.Location="38,67"
    $O365PassLbl.Anchor="Bottom, Left"
    $O365PassLbl.Text="&Password"
    $O365PassLbl.Size="60,20"

    $O365PassTxtBx.Location="105,67"
    $O365PassTxtBx.Name="O365Pass"
    $O365PassTxtBx.Size="200,20"
    $O365PassTxtBx.Text="none"
    $O365PassTxtBx.PasswordChar='*'

    if($certBasedRes -eq 'Yes'){
        $O365DtlsLbl.Enabled=$false
        $O365UsrLbl.Enabled=$false
        $O365UsrTxtBx.Enabled=$false
        $O365PassLbl.Enabled=$false
        $O365PassTxtBx.Enabled=$false
    }else{
        $O365DtlsLbl.Enabled=$true
        $O365UsrLbl.Enabled=$true
        $O365UsrTxtBx.Enabled=$true
        $O365PassLbl.Enabled=$true
        $O365PassTxtBx.Enabled=$true
    }

    $label5.Location="38,95"
    $label5.Anchor="Bottom, Left"
    $label5.Text="&Proxy Details :"
    $label5.Size="100,20"

    $label1.Location="38,118"
    $label1.Anchor="Bottom, Left"
    $label1.Text="&Host IP"
    $label1.Size="60,20"

    $textbox1.Location="105,118"
    $textbox1.Name="ProxyHost"
    $textbox1.Size="120,20"
    $textbox1.Text="none"

    $label2.Location="228,118"
    $label2.Anchor="Bottom, Left"
    $label2.Text="&Port"
    $label2.Size="25,20"

    $textbox2.Location="255,118"
    $textbox2.Name="Port"
    $textbox2.Size="50,20"
    $textbox2.Text="none"

    $label3.Location="38,145"
    $label3.Anchor="Bottom, Left"
    $label3.Text="&Username"
    $label3.Size="60,20"

    $textbox3.Location="105,145"
    $textbox3.Name="ProxyUser"
    $textbox3.Size="200,20"
    $textbox3.Text="none"

    $label4.Location="38,171"
    $label4.Anchor="Bottom, Left"
    $label4.Text="&Password"
    $label4.Size="60,20"

    $textbox4.Location="105,171"
    $textbox4.Name="ProxyPass"
    $textbox4.Size="200,20"
    $textbox4.Text="none"
    $textbox4.PasswordChar='*'

    $buttonOK.Anchor = 'Bottom, Right'
    $buttonOK.DialogResult = 'OK'
    $buttonOK.Location = "150, $buttonplacement"
    $buttonOK.Margin = '4, 4, 4, 4'
    $buttonOK.Name = 'buttonOK'
    $buttonOK.Size = '100, 30'
    $buttonOK.TabIndex = 0
    $buttonOK.Text = '&OK'

    $frmDialog=$form.ShowDialog()
######### END ###########
if($frmDialog -eq 'OK'){
    $userName=$O365UsrTxtBx.Text
    $password=$O365PassTxtBx.Text
    $proxyHost=$textbox1.Text
    $proxyPort=$textbox2.Text
    $proxyUsr=$textbox3.Text
    $proxyPass=$textbox4.Text
    $proxyServer='none'
    
    if($proxyHost -eq "" -or $proxyPort -eq "" -or $proxyUsr -eq "" -or $proxyPass -eq ""){
        Write-Host "Re-run the script with all the inputs." -ForegroundColor Red 
        O365-WriteLog -writString  "Re-run the script with all the inputs." -LogPath $logFile -ReportingName 'ERROR'
        exit
    }
    if($certBasedRes -eq 'No' -and ($userName -eq 'none' -or $password -eq 'none' -or $userName -eq '' -or $password -eq '')){
        Write-Host "Re-run the script with all the inputs." -ForegroundColor Red 
        O365-WriteLog -writString  "Re-run the script with all the inputs." -LogPath $logFile -ReportingName 'ERROR'
        exit
    }
}
else{
    Write-Host 'Exiting...'
    exit
}

$edTim1=Get-Date
O365-WriteLog -writString "O365GraphAPI started at $edTim1" -LogPath $logFile -ReportingName 'INFO'

$proxyserverip=$proxyHost+':'+$proxyPort
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred =New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

if($certBasedRes -eq 'Yes'){
    $azureAD=Connect-AzureAD
    $iniDomainDtls=Get-AzureADDomain | Where-Object{$_.IsInitial -eq 'True'} | select *
    $orgNam=$iniDomainDtls.Name
    $tenantId=$azureAD.TenantId
}else{
    $cn=@('AzureChinaCloud','https://partner.outlook.cn/PowerShell','O365China')
    $com=@('AzureCloud','https://outlook.office365.com/powershell-liveid/','O365Default')
    $de=@('AzureGermanyCloud','https://outlook.office.de/powershell-liveid/','O365GermanyCloud')
    $us=@('USGovernment','None','O365USGovDoD')
    $azureCloud=$userName.Substring($userName.LastIndexOf('.')+1) 
    $azureCloudArr=@()
    if($azureCloud -eq 'com'){$azureCloudArr=$com}
    elseif($azureCloud -eq 'cn'){$azureCloudArr=$cn}
    elseif($azureCloud -eq 'de'){$azureCloudArr=$de}
    elseif($azureCloud -eq 'us'){$azureCloudArr=$us}  
    else{$azureCloudArr=$com}

    $credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    $azureAD=Connect-AzureAd  -AzureEnvironment $azureCloudArr[0] -Credential $credential

    $iniDomainDtls=Get-AzureADDomain | Where-Object{$_.IsInitial -eq 'True'} | select *
    $orgNam=$iniDomainDtls.Name
    $tenantId=$azureAD.TenantId
}

#######
$graphAppStr=''
$chkGrphDir=$egurkhaPath+'\agent\O365\MsGraph'
if(Test-Path -Path $chkGrphDir){
    $chkKeyPath=$chkGrphDir+'\GraphDetailsKey.dat'
    $chkGrphDatFile=$chkGrphDir+'\GraphDetails.dat'
    if(Test-Path -Path $chkGrphDatFile -PathType Leaf){
        $kvalue=Get-Content -Path $chkKeyPath
        Unprotect-File $chkGrphDatFile -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
        $grphDtlTxtFile=$chkGrphDir+'\GraphDetails.txt'
        if(Test-Path $grphDtlTxtFile -PathType Leaf){
            $txtLines=Get-Content -Path $grphDtlTxtFile
            foreach($txtLine in $txtLines){
                $chkEndsWith=$orgNam+']'
                if($txtLine.EndsWith($chkEndsWith)){
                    $graphAppStr=([String]$txtLine.Split('-')[0]).Replace('[','').Trim()
                }
            }
            Remove-Item -Path $grphDtlTxtFile
        }
    }
}
if($graphAppStr -ne ''){
    $chkConfigFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
    $chkLines=get-content -Path $chkConfigFile
    $isChkExist=$false
    $FileModified = @()
    foreach ($line in $chkLines){
        if($isChkExist -and $line.StartsWith('Graph_APP_Name')){
            $FileModified +=('Graph_APP_Name='+$graphAppStr)
            continue
        }
        if($line.StartsWith('[O365EnableCertBasedAuthentication')){
            $isChkExist=$true
        }
        $FileModified += $line
    }
    $FileModified | Out-File $chkConfigFile
}
########

$grph_AppName=''
$grph_srchStrArr=@()
$grph_reqPermissionArr=@()
$apiHash=@{}
$permissionHash=@{}
$azureEnv=''

$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExist=$false
$isO365MailSR='false'
foreach($line in $lines){  
    if($isExist){
        if($line.StartsWith('Monitor_O365_Mail_Sender_Receiver')){
           $isO365MailSR=$line.Replace('Monitor_O365_Mail_Sender_Receiver=','')
        }
        if($line.StartsWith('O365_MailFlow_Graph_Permissions') -and $isO365MailSR -eq 'true'){
            $o365MailSRPer=$line.Replace('O365_MailFlow_Graph_Permissions=','')
            $o365MailSRPer=$o365MailSRPer.Split('~')
            foreach($reqPerSRArr in $o365MailSRPer){
                $grph_reqPermissionArr+=$reqPerSRArr
            }
        }
        if($line.StartsWith('Graph_APP_Name')){
            $grph_AppName=$line.Replace('Graph_APP_Name=','')
        }
        if($line.StartsWith('Graph_APIs')){
            $apiStr=$line.Replace('Graph_APIs=','')
            $apiStr=$apiStr.Split('~')
            foreach($apiArr in $apiStr){
                $grph_srchStrArr+=$apiArr
            }
        }
        if($line.StartsWith('Graph_Permissions')){
            $reqPerStr=$line.Replace('Graph_Permissions=','')
            $reqPerStr=$reqPerStr.Split('~')
            foreach($reqPerArr in $reqPerStr){
                $grph_reqPermissionArr+=$reqPerArr
            }  
        }
        if($line.StartsWith('AAD_Env')){
           $azureEnv=$line.Replace('AAD_Env=','')
           break;
        }
        
    }
    if($line.StartsWith('[O365EnableCertBasedAuthentication')){
        $isExist=$true
    }
}

$apiHash.Add($grph_AppName,$grph_srchStrArr)
$permissionHash.Add($grph_AppName,$grph_reqPermissionArr)

foreach($appName in $apiHash.Keys){

    $srchStrArr=$apiHash[$appName]
    $reqPermissionArr=$permissionHash[$appName]

    $existingapp = $null
    $existingapp = get-azureadapplication -Filter "DisplayName eq '$appName'"
    if ($existingapp) {
        Write-host "Existing AzureAD application Removed"
        O365-WriteLog -writString  "Existing AzureAD application Removed" -LogPath $logFile -ReportingName 'INFO'
        Remove-Azureadapplication -ObjectId $existingApp.objectId
    }

    $spArr=[System.Collections.ArrayList]@()
    $requiredResourcesAccess = New-Object System.Collections.Generic.List[Microsoft.Open.AzureAD.Model.RequiredResourceAccess]
    foreach($str in $srchStrArr){
        $srchStr=$str -split('#')
        $appArray = [System.Collections.ArrayList]@()
        $delArray = [System.Collections.ArrayList]@()
        $svcPrincipal=Get-AzureADServicePrincipal -SearchString $srchStr[1] | Where-Object {$_.DisplayName -eq $srchStr[1]}

        $spArr.Add($svcPrincipal)
        for($i=0;$i -lt $reqPermissionArr.Length;$i++ ){
            if($reqPermissionArr[$i].StartsWith($srchStr[0])){
                $grStr=$srchStr[0].ToString().Length
                $tmpnam=$srchStr[0]
                while($true){
                    if($reqPermissionArr[$i].StartsWith($tmpnam) -and $reqPermissionArr[$i].EndsWith('App')){
                        $displayNam=$reqPermissionArr[$i].Substring($grStr)
                        $appIdx=$displayNam.Length-3
                        $displayNam=$displayNam.Substring(0,$appIdx)
                        $appArray.Add($displayNam) 
                        if($i -lt $reqPermissionArr.Length-1){
                            $i++
                        }else{break;}
                    }else{
                        break;
                    }
                }
                while($true){
                    if($reqPermissionArr[$i].StartsWith($tmpnam) -and $reqPermissionArr[$i].EndsWith('Del')){     
                        $displayNam=$reqPermissionArr[$i].Substring($grStr)
                        $appIdx=$displayNam.Length-3
                        $displayNam=$displayNam.Substring(0,$appIdx)
                        $delArray.Add($displayNam)
                        if($i -lt $reqPermissionArr.Length-1){
                            $i++
                        }else{break;}
                    }else{
                        break;
                    }
                }
                $appValue=$svcPrincipal.AppRoles | Where-Object{$_.DisplayName -in $appArray}
                $delValue=$svcPrincipal.Oauth2Permissions | Where-Object{$_.AdminConsentDisplayName -in $delArray}
                $azureAppPermissions = GetRequiredPermissions -reqsp $svcPrincipal -requiredApplicationPermissions $appValue -requiredDelegatedPermissions $delValue
                $requiredResourcesAccess.Add($azureAppPermissions)
            }
        }
    }
    $startDate = (Get-Date)
    $endDate = $startDate.AddYears(2)
    $KeyDesc='SecreteG'
    Try{
        $aadApplication = New-AzureADApplication -DisplayName $appName -RequiredResourceAccess $requiredResourcesAccess
        Write-host "New AzureAD application created"
        O365-WriteLog -writString  "New AzureAD application created" -LogPath $logFile -ReportingName 'INFO'

        $tmpCreVal=New-AzureADApplicationPasswordCredential -ObjectId $aadApplication.ObjectId -StartDate $startDate -EndDate $endDate -CustomKeyIdentifier $KeyDesc
        Write-host "Secret key generated"
        O365-WriteLog -writString  "Secret key generated" -LogPath $logFile -ReportingName 'INFO'

        $servicePrincipal = New-AzureADServicePrincipal -AppId $aadApplication.AppId      
        foreach ($app in $requiredResourcesAccess){   
            $reqAppSP = $spArr | Where-Object {$_.appid -contains $app.ResourceAppId}  
            foreach ($resource in $app.ResourceAccess) {
                if ($resource.Type -match "Role") {
                    New-AzureADServiceAppRoleAssignment -ObjectId $serviceprincipal.ObjectId -PrincipalId $serviceprincipal.ObjectId -ResourceId $reqAppSP.ObjectId -Id $resource.Id
                }
            }      
        }
        Write-host "permissions are configured to App.."
        O365-WriteLog -writString  "permissions are configured to App.." -LogPath $logFile -ReportingName 'INFO'
        Get-AzureADOAuth2PermissionGrant -All $true
        Write-host "Admin consent granted to permissions"
        O365-WriteLog -writString  "Admin consent granted to permissions" -LogPath $logFile -ReportingName 'INFO'
    }
    Catch{
        $message= $_.Exception.Message + $_.ScriptStackTrace 
        Write-host "[App Permissions] Exception Occurred - $message."
        O365-WriteLog -writString  "[App Permissions] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
    }

    $appId=$aadApplication.AppId

    $client_secret=$tmpCreVal.Value
    $authority = "https://login.microsoftonline.com/"
    $resource = "https://graph.microsoft.com"
    Try{
        $grphDir=$egurkhaPath+'\agent\O365\MsGraph'
        $keyPath=$grphDir+'\GraphDetailsKey.dat'
        $unProtFile=$grphDir+'\GraphDetails.dat'
        if(Test-Path $unProtFile -PathType Leaf){
            $unProtPath=$grphDir+'\GraphDetails.dat'
            $kvalue=Get-Content -Path $keyPath
            Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
        }
        $grphDtlPath=$grphDir+'\GraphDetails.txt'
        if(Test-Path $grphDtlPath -PathType Leaf){
            $lines=Get-Content -Path $grphDtlPath
            $wpath1=$grphDir+'\GraphDetails1.txt'  
            $orgChk='-'+$orgNam
            $isExist=$False
            for($i=0;$i -lt $lines.Length;$i++){
                if($lines[$i] -match $orgChk){
                    $isExist=$true
                    $null='['+$appName+'-'+$orgNam+']'| Add-Content $wpath1 -PassThru
                    $null='client_id~'+$appId| Add-Content $wpath1 -PassThru
                    $null='client_secret~'+$client_secret| Add-Content $wpath1 -PassThru
                    $null='TenantName~'+$orgNam| Add-Content $wpath1 -PassThru
                    $null='Authority~'+$authority| Add-Content $wpath1 -PassThru
                    $null='Resource~'+$resource| Add-Content $wpath1 -PassThru
                    $null='TenantId~'+$tenantId| Add-Content $wpath1 -PassThru
                    ""| Add-Content $wpath1
                    $i=$i+7
                    continue
                }
                Add-Content -Path $wpath1 -Value $lines[$i]
            }
            if(!$isExist){
                $null='['+$appName+'-'+$orgNam+']'| Add-Content $wpath1 -PassThru
                $null='client_id~'+$appId| Add-Content $wpath1 -PassThru
                $null='client_secret~'+$client_secret| Add-Content $wpath1 -PassThru
                $null='TenantName~'+$orgNam| Add-Content $wpath1 -PassThru
                $null='Authority~'+$authority| Add-Content $wpath1 -PassThru
                $null='Resource~'+$resource| Add-Content $wpath1 -PassThru
                $null='TenantId~'+$tenantId| Add-Content $wpath1 -PassThru
                ""| Add-Content $wpath1
            }
            Remove-Item $grphDtlPath
            if(Test-Path $wpath1 -PathType Leaf){
                Rename-Item $wpath1 'GraphDetails.txt'
            } 
        }else{
            $null='['+$appName+'-'+$orgNam+']'| Add-Content $grphDtlPath
            $null='client_id~'+$appId| Add-Content $grphDtlPath
            $null='client_secret~'+$client_secret| Add-Content $grphDtlPath
            $null='TenantName~'+$orgNam| Add-Content $grphDtlPath
            $null='Authority~'+$authority| Add-Content $grphDtlPath
            $null='Resource~'+$resource| Add-Content $grphDtlPath
            $null='TenantId~'+$tenantId| Add-Content $grphDtlPath
            ""| Add-Content $grphDtlPath
        }

        $key=Get-CryptoKey -FileDir $grphDir -FileName '\GraphDetailsKey.dat'
        $null=Protect-File $grphDtlPath -Algorithm AES -KeyAsPlainText $key -RemoveSource
    }
    Catch{
        $message= $_.Exception.Message + $_.ScriptStackTrace 
        Write-host "Exception Occurred in Graph API writing file - $message."
        O365-WriteLog -writString  "Exception Occurred in Graph API writing file - $message." -LogPath $logFile -ReportingName 'ERROR'
    }
}

Disconnect-AzureAD

if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}

$edTim2=Get-Date
O365-WriteLog -writString "O365GraphAPI ended at $edTim2" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'
