﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
clear

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G 
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

Function GetRequiredPermissions($requiredDelegatedPermissions, $requiredApplicationPermissions, $reqsp) {
    $sp = $reqsp
    $appid = $sp.AppId
    $requiredAccess = New-Object Microsoft.Open.AzureAD.Model.RequiredResourceAccess
    $requiredAccess.ResourceAppId = $appid
    $requiredAccess.ResourceAccess = New-Object System.Collections.Generic.List[Microsoft.Open.AzureAD.Model.ResourceAccess]
    if ($requiredDelegatedPermissions) {
        AddResourcePermission $requiredAccess -exposedPermissions $sp.Oauth2Permissions -requiredAccesses $requiredDelegatedPermissions -permissionType "Scope"
    } 
    if ($requiredApplicationPermissions) {
        AddResourcePermission $requiredAccess -exposedPermissions $sp.AppRoles -requiredAccesses $requiredApplicationPermissions -permissionType "Role"
    }
    return $requiredAccess
}

Function AddResourcePermission($requiredAccess, $exposedPermissions, $requiredAccesses, $permissionType) {
    foreach ($permission in $requiredAccesses) {
        $reqPermission = $null
        $reqPermission = $exposedPermissions | Where-Object {$_.Value -contains $permission.Value}
        $resourceAccess = New-Object Microsoft.Open.AzureAD.Model.ResourceAccess
        $resourceAccess.Type = $permissionType
        $resourceAccess.Id = $reqPermission.Id    
        $requiredAccess.ResourceAccess.Add($resourceAccess)
    }
}

function O365-Enc(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$str
    )
    Process
    {
        $j=124;
        $eStr=[System.Text.Encoding]::UTF8
        $byt=$eStr.GetBytes($str)
        $bytArr=@()
        for($i=0;$i -lt $byt.count ;$i++){  
            $k=$j-$byt[$i]+$i*3
            $bt=[System.BitConverter]::GetBytes($k)
            $bytArr+=$bt[0]
        }
        $encStr=''
        for($i=$bytArr.count;$i -ge 0 ;$i--){
            $encStr+=$bytArr[$i]
            if($bytArr[$i] -ne 0){
                $encStr+=':'
            }
        }
        $encStr=$encStr.Substring(1,$encStr.Length-2)
        return $encStr
    }
}


$certDir=$egurkhaPath+'\agent\O365\AppInfo'
if(!(Test-Path -Path $certDir)){
    $null=New-Item -ItemType directory -Path $certDir
}
$logFile=$certDir+'\O365_AppPrerequisites.log'

$grphDir=$egurkhaPath+'\agent\O365\MsGraph'
if(!(Test-Path -Path $grphDir)){
    $null=New-Item -ItemType directory -Path $grphDir
}

function validateBoxesAndCombos(){
     $checkPassword=$mntrPassTxtBx.Text
     if(!($checkPassword.length -gt 8) -and !($checkPassword –cmatch '[^a-zA-Z0-9]') -and !($checkPassword -cmatch " "))
     {
       $result = [System.Windows.Forms.MessageBox]::Show('Please provide strong password', 'Alert', 'OK', 'Warning')
     }
}

$chkWinrm=([String](& cmd /c "`"winrm get winrm/config/client/auth`"")).Trim().Replace(' ','')
if($chkWinrm -notmatch 'Basic=true'){
    Write-Host 'WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE...' -ForegroundColor Red
    O365-WriteLog -writString ("WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE..."+$chkWinrm) -LogPath $logFile -ReportingName 'ERROR'
    exit
}
    ######***GUI  form ****#######
    $code = @"
[DllImport("user32.dll", CharSet = CharSet.Unicode)]
public static extern IntPtr SendMessage(IntPtr hWnd, 
    int msg, IntPtr wParam, string lParam);  
public const int EM_SETCUEBANER = 0x1501;
"@
$Win32Helpers = Add-Type -MemberDefinition $code -Name "Win32Helpers" -PassThru
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing") 
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms")

$form = New-Object System.Windows.Forms.Form
$flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
$buttonOK = New-Object System.Windows.Forms.Button
       
$prxyDtlsLbl=New-Object System.Windows.Forms.Label
$prxyHostLbl=New-Object System.Windows.Forms.Label
$prxyPortLbl=New-Object System.Windows.Forms.Label
$prxyUsrLbl=New-Object System.Windows.Forms.Label
$prxyPassLbl=New-Object System.Windows.Forms.Label
$prxyHostTxtBx=New-Object System.Windows.Forms.TextBox
$prxyPortTxtBx=New-Object System.Windows.Forms.TextBox
$prxyUsrTxtBx=New-Object System.Windows.Forms.TextBox
$prxyPassTxtBx=New-Object System.Windows.Forms.TextBox

$pfxDtlsLbl=New-Object System.Windows.Forms.Label
$pfxPassLbl=New-Object System.Windows.Forms.Label
$pfxPassTxtBx=New-Object System.Windows.Forms.TextBox

$monitorlabel=New-Object System.Windows.Forms.Label
$RadioButton1 = New-Object System.Windows.Forms.RadioButton
$RadioButton2 = New-Object System.Windows.Forms.RadioButton
$mntrUsrLbl=New-Object System.Windows.Forms.Label
$mntrUsrTxtBx=New-Object System.Windows.Forms.TextBox    
$mntrPassLbl=New-Object System.Windows.Forms.Label
$mntrPassTxtBx=New-Object System.Windows.Forms.TextBox
$infoLabel=New-Object System.Windows.Forms.Label
$infoLabel1=New-Object System.Windows.Forms.Label
$infoLabel2=New-Object System.Windows.Forms.Label
  
$formsize = 360

$form.Controls.Add($prxyDtlsLbl)
$form.Controls.Add($prxyHostLbl)
$form.Controls.Add($prxyHostTxtBx)
$form.Controls.Add($prxyPortLbl)
$form.Controls.Add($prxyPortTxtBx)
$form.Controls.Add($prxyUsrLbl)
$form.Controls.Add($prxyUsrTxtBx)
$form.Controls.Add($prxyPassLbl)
$form.Controls.Add($prxyPassTxtBx)

$form.Controls.Add($pfxDtlsLbl)
$form.Controls.Add($pfxPassLbl)
$form.Controls.Add($pfxPassTxtBx)

$form.Controls.Add($RadioButton1)
$form.Controls.Add($RadioButton2)

$form.Controls.Add($monitorlabel)
$form.Controls.Add($mntrUsrLbl)
$form.Controls.Add($mntrUsrTxtBx)
$form.Controls.Add($mntrPassLbl)
$form.Controls.Add($mntrPassTxtBx)
$form.Controls.Add($infoLabel)
$form.Controls.Add($infoLabel1)

$form.Controls.Add($buttonOK)

$form.AcceptButton = $buttonOK
$form.AutoScaleDimensions = '8, 17'
$form.AutoScaleMode = 'Font'
$form.ClientSize = "438 , $formsize"
$form.FormBorderStyle = 'FixedDialog'
$form.Margin = '5, 5, 5, 5'
$form.MaximizeBox = $False
$form.MinimizeBox = $False
$form.Name = 'form1'
$form.StartPosition = 'CenterScreen'
$form.Text = 'O365 Cert Based Authentiacation'
$form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D

$prxyDtlsLbl.Location="38,15"
$prxyDtlsLbl.Anchor="Bottom, Left"
$prxyDtlsLbl.Text="&Proxy Details :"
$prxyDtlsLbl.Size="100,20"
$prxyHostLbl.Location="58,38"
$prxyHostLbl.Anchor="Bottom, Left"
$prxyHostLbl.Text="&Host IP"
$prxyHostLbl.Size="115,20"
$prxyHostTxtBx.Location="175,38"
$prxyHostTxtBx.Name="ProxyHost"
$prxyHostTxtBx.Size="120,20"
$prxyHostTxtBx.Text="none"
$prxyPortLbl.Location="298,39"
$prxyPortLbl.Anchor="Bottom, Left"
$prxyPortLbl.Text="&Port"
$prxyPortLbl.Size="25,20"
$prxyPortTxtBx.Location="325,38"
$prxyPortTxtBx.Name="Port"
$prxyPortTxtBx.Size="50,20"
$prxyPortTxtBx.Text="none"
$prxyUsrLbl.Location="58,65"
$prxyUsrLbl.Anchor="Bottom, Left"
$prxyUsrLbl.Text="&Username"
$prxyUsrLbl.Size="115,20"
$prxyUsrTxtBx.Location="175,65"
$prxyUsrTxtBx.Name="ProxyUser"
$prxyUsrTxtBx.Size="200,20"
$prxyUsrTxtBx.Text="none"
$prxyPassLbl.Location="58,93"
$prxyPassLbl.Anchor="Bottom, Left"
$prxyPassLbl.Text="&Password"
$prxyPassLbl.Size="115,20"
$prxyPassTxtBx.Location="175,93"
$prxyPassTxtBx.Name="ProxyPass"
$prxyPassTxtBx.Size="200,20"
$prxyPassTxtBx.Text="none"
$prxyPassTxtBx.PasswordChar='*'

$pfxDtlsLbl.Location="38,118"
$pfxDtlsLbl.Anchor="Bottom, Left"
$pfxDtlsLbl.Text="&Others:"
$pfxDtlsLbl.Size="230,20"
$pfxPassLbl.Location="58,140"
$pfxPassLbl.Anchor="Bottom, Left"
$pfxPassLbl.Text="&PFX File Password"
$pfxPassLbl.Size="115,20"
$pfxPassTxtBx.Location="175,140"
$pfxPassTxtBx.Name="O365Pass"
$pfxPassTxtBx.Size="200,20"
$pfxPassTxtBx.Text=""
$pfxPassTxtBx.PasswordChar='*'

#<#
$monitorlabel.Location="38,171"  
$monitorlabel.Anchor="Bottom, Left"
$monitorlabel.Text="&eG Monitor User Credentails:"
$monitorlabel.Size="200,20"

$RadioButton1.Location ="58,195"
$RadioButton1.Size ="115,20"
$RadioButton1.Checked = $true
$RadioButton1.text = "New User"
$RadioButton2.Location ="175,195"
$RadioButton2.Size ="115,20"
$RadioButton2.Checked = $false
$RadioButton2.text = "Existing User"

$RadioButton1.Add_Click({
    $mntrPassLbl.Enabled=$true
    $mntrPassTxtBx.Enabled=$true
    $mntrUsrTxtBx.Text=""
    $infoLabel.Location="58,279"
    $infoLabel.Anchor="Bottom, Left"
    $infoLabel.Text="&*"
    $infoLabel.Font=New-Object System.Drawing.Font("Lucida Console",13,[System.Drawing.FontStyle]::Regular)
    $infoLabel.Size="17,10"
    $infoLabel.ForeColor='Red'
    $infoLabel1.Location="72,279"
    $infoLabel1.Anchor="Bottom, Left"
    $infoLabel1.Text="&New user and MSGraph App will be created with the required roles/permissions"#
    $infoLabel1.Size="375,25"
    $infoLabel1.ForeColor='blue'
})
$RadioButton2.Add_Click({
    $mntrPassLbl.Enabled=$false
    $mntrPassTxtBx.Enabled=$false
    $mntrUsrTxtBx.Text=""
    $infoLabel.Location="58,279"
    $infoLabel.Anchor="Bottom, Left"
    $infoLabel.Text="&*"
    $infoLabel.Font=New-Object System.Drawing.Font("Lucida Console",13,[System.Drawing.FontStyle]::Regular)
    $infoLabel.Size="17,10"
    $infoLabel.ForeColor='Red'
    $infoLabel1.Location="72,279"
    $infoLabel1.Anchor="Bottom, Left"
    $infoLabel1.Text="&Existing user and MSGraph App will be provided the required roles/permissions"
    $infoLabel1.Size="375,25"
    $infoLabel1.ForeColor='blue'
})

$mntrUsrLbl.Location="58,222"  
$mntrUsrLbl.Anchor="Bottom, Left"
$mntrUsrLbl.Text="&Monitoring User:"
$mntrUsrLbl.Size="115,20"
$mntrUsrTxtBx.Location="175,222"  
$mntrUsrTxtBx.Name="monitorUser"
$mntrUsrTxtBx.Size="200,20"
$mntrUsrTxtBx.Text=""
$mntrPassLbl.Location="58,250" 
$mntrPassLbl.Anchor="Bottom, Left"
$mntrPassLbl.Text="&Monitoring Password:"
$mntrPassLbl.Size="115,20"
$mntrPassTxtBx.Location="175,250"
$mntrPassTxtBx.Name="monitorPassword"
$mntrPassTxtBx.Size="200,20"
$mntrPassTxtBx.Text=""
$mntrPassTxtBx.PasswordChar='*'
$mntrPassTxtBx.MaxLength = 16
$mntrPassTxtBx.Add_Leave({validateBoxesAndCombos})
$mntrUsrTxtBx.add_HandleCreated({
    $Win32Helpers::SendMessage($mntrUsrTxtBx.Handle,$Win32Helpers::EM_SETCUEBANER,[IntPtr]0, "username@domain.com")
})

$infoLabel.Location="58,279"
$infoLabel.Anchor="Bottom, Left"
$infoLabel.Text="&*"
$infoLabel.Font=New-Object System.Drawing.Font("Lucida Console",13,[System.Drawing.FontStyle]::Regular)
$infoLabel.Size="17,10"
$infoLabel.ForeColor='Red'
$infoLabel1.Location="72,279"
$infoLabel1.Anchor="Bottom, Left"
$infoLabel1.Text="&New user and MSGraph App will be created with the required roles/permissions"
$infoLabel1.Size="375,25"
$infoLabel1.ForeColor='blue'
#>

$buttonOK.Anchor = 'Bottom, Right'
$buttonOK.DialogResult = 'OK'
$buttonOK.Location = "175, 312"
$buttonOK.Margin = '4, 4, 4, 4'
$buttonOK.Name = 'buttonOK'
$buttonOK.Size = '100, 30'
$buttonOK.TabIndex = 0
$buttonOK.Text = '&OK'
$frmDialog=$form.ShowDialog()
$isExistingUsr=$False
if($frmDialog -eq 'OK' ){
    $proxyHost=$prxyHostTxtBx.Text
    $proxyPort=$prxyPortTxtBx.Text
    $proxyUsr=$prxyUsrTxtBx.Text
    $proxyPass=$prxyPassTxtBx.Text
    $pfxPass=$pfxPassTxtBx.Text
    $monitorUsrNam=$mntrUsrTxtBx.Text
    $monitorPass=$mntrPassTxtBx.Text
    if($RadioButton2.Checked -eq $true){
        $isExistingUsr=$true
    }
    
    if($proxyHost -eq "" -or $proxyport -eq "" -or $proxyUsr -eq "" -or $pfxPass -eq ""){
        Write-Host "Re-run the script with all the inputs." -ForegroundColor Red 
        O365-WriteLog -writString  "Re-run the script with all the inputs." -LogPath $logFile -ReportingName 'ERROR'
        exit
    }

}else{
    Write-Host 'Exiting...'
    exit
}

$sessionOption = New-PSSessionOption -SkipRevocationCheck
$proxyserverip=$proxyHost+':'+$proxyPort
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred =New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
    }
}
Write-host "Cert Based Authentication - Prerequisites configuration started"
O365-WriteLog -writString  "CBA - Prerequisites configuration started" -LogPath $logFile -ReportingName 'INFO'

$dupAppName=''
$grph_DupAppName=''
$srchStrArr=@()
$reqPermissionArr=@()
$grph_srchStrArr=@()
$grph_reqPermissionArr=@()

$apiHash=@{}
$permissionHash=@{}
$aadRoleArr=@()
$usrRoleArr=@()
$aadEnv=''

$azureAD=Connect-AzureAD
$iniDomainDtls=Get-AzureADDomain | Where-Object{$_.IsInitial -eq 'True'} | select *
$orgNam=$iniDomainDtls.Name
$adminUsrNam=($azureAD.Account).ToString()
$tenantId=$azureAD.TenantId

#######
$graphAppStr=''
$chkGrphDir=$egurkhaPath+'\agent\O365\MsGraph'
if(Test-Path -Path $chkGrphDir){
    $chkKeyPath=$chkGrphDir+'\GraphDetailsKey.dat'
    $chkGrphDatFile=$chkGrphDir+'\GraphDetails.dat'
    if(Test-Path -Path $chkGrphDatFile -PathType Leaf){
        $kvalue=Get-Content -Path $chkKeyPath
        Unprotect-File $chkGrphDatFile -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
        $grphDtlTxtFile=$chkGrphDir+'\GraphDetails.txt'
        if(Test-Path $grphDtlTxtFile -PathType Leaf){
            $txtLines=Get-Content -Path $grphDtlTxtFile
            foreach($txtLine in $txtLines){
                $chkEndsWith=$orgNam+']'
                if($txtLine.EndsWith($chkEndsWith)){
                    $graphAppStr=([String]$txtLine.Split('-')[0]).Replace('[','').Trim()
                }
            }
            Remove-Item -Path $grphDtlTxtFile
        }
    }
}
if($graphAppStr -ne ''){
    $chkConfigFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
    $chkLines=get-content -Path $chkConfigFile
    $isChkExist=$false
    $FileModified = @()
    foreach ($line in $chkLines){
        if($isChkExist -and $line.StartsWith('Graph_APP_Name')){
            $FileModified +=('Graph_APP_Name='+$graphAppStr)
            continue
        }
        if($line.StartsWith('[O365EnableCertBasedAuthentication')){
            $isChkExist=$true
        }
        $FileModified += $line
    }
    $FileModified | Out-File $chkConfigFile
}
########

$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExist=$false
$isO365MailSR='false'
foreach($line in $lines){  
    if($isExist){
        if($line.StartsWith('APP_Name')){
            $dupAppName=$line.Replace('APP_Name=','')
            $dupAppName=$dupAppName+'_CBA'
        }
        if($line.StartsWith('APIs')){
            $apiStr=$line.Replace('APIs=','')
            $apiStr=$apiStr.Split('~')
            foreach($apiArr in $apiStr){
                $srchStrArr+=$apiArr
            }
        }
        if($line.StartsWith('Permissions')){
            $reqPerStr=$line.Replace('Permissions=','')
            $reqPerStr=$reqPerStr.Split('~')
            foreach($reqPerArr in $reqPerStr){
                $reqPermissionArr+=$reqPerArr
            }
        }
        if($line.StartsWith('Monitor_O365_Mail_Sender_Receiver')){
           $isO365MailSR=$line.Replace('Monitor_O365_Mail_Sender_Receiver=','')
        }
        if($line.StartsWith('O365_MailFlow_Graph_Permissions') -and $isO365MailSR -eq 'true'){
            $o365MailSRPer=$line.Replace('O365_MailFlow_Graph_Permissions=','')
            $o365MailSRPer=$o365MailSRPer.Split('~')
            foreach($reqPerSRArr in $o365MailSRPer){
                $grph_reqPermissionArr+=$reqPerSRArr
            }
        }
        if($line.StartsWith('Graph_APP_Name')){
            $grph_DupAppName=$line.Replace('Graph_APP_Name=','')
            $grph_DupAppName=$grph_DupAppName+'_MsGraph'
        }
        if($line.StartsWith('Graph_APIs')){
            $apiStr=$line.Replace('Graph_APIs=','')
            $apiStr=$apiStr.Split('~')
            foreach($apiArr in $apiStr){
                $grph_srchStrArr+=$apiArr
            }
        }
        if($line.StartsWith('Graph_Permissions')){
            $reqPerStr=$line.Replace('Graph_Permissions=','')
            $reqPerStr=$reqPerStr.Split('~')
            foreach($reqPerArr in $reqPerStr){
                $grph_reqPermissionArr+=$reqPerArr
            }
        }
        if($line.StartsWith('AAD_Roles')){
            $aadRolStr=$line.Replace('AAD_Roles=','')
            $aadRoleArr=$aadRolStr.Split('~')
        }
        if($line.StartsWith('User_Roles')){
            $usrRolStr=$line.Replace('User_Roles=','')
            $usrRoleArr=$usrRolStr.Split('~')
        }
        if($line.StartsWith('AAD_Env')){
            $aadEnv=$line.Replace('AAD_Env=','')
            break;
        }
    }
    if($line.StartsWith('[O365EnableCertBasedAuthentication')){
        $isExist=$true
    }
}

$apiHash.Add($dupAppName,$srchStrArr)
$apiHash.Add($grph_DupAppName,$grph_srchStrArr)
$permissionHash.Add($dupAppName,$reqPermissionArr)
$permissionHash.Add($grph_DupAppName,$grph_reqPermissionArr)

$cbaClientId=''
$cbaOrgNam=''
$cbaThumbPrint=''


foreach($dupAppName in $apiHash.Keys){
    $appName=''
    $srchStrArr=$apiHash[$dupAppName]
    $reqPermissionArr=$permissionHash[$dupAppName]

    if($dupAppName.EndsWith('_CBA')){
        $appName=$dupAppName.Substring(0,$dupAppName.LastIndexOf('_CBA'))
    }
    if($dupAppName.EndsWith('_MsGraph')){
        $appName=$dupAppName.Substring(0,$dupAppName.LastIndexOf('_MsGraph'))
    }

    Write-host "APP Name -->> $appName"
    O365-WriteLog -writString  "APP Name -->> $appName" -LogPath $logFile -ReportingName 'INFO'

    $existingapp = $null
    $existingapp = get-azureadapplication -Filter "DisplayName eq '$appName'"
    if ($existingapp) {
        Write-host "Existing AzureAD application Removed"
        O365-WriteLog -writString  "Existing AzureAD application Removed" -LogPath $logFile -ReportingName 'INFO'
        Remove-Azureadapplication -ObjectId $existingApp.objectId
    }

    $spArr=[System.Collections.ArrayList]@()
    $requiredResourcesAccess = New-Object System.Collections.Generic.List[Microsoft.Open.AzureAD.Model.RequiredResourceAccess]
    foreach($str in $srchStrArr){
        $srchStr=$str -split('#')
        $appArray = [System.Collections.ArrayList]@()
        $delArray = [System.Collections.ArrayList]@()
        $svcPrincipal=Get-AzureADServicePrincipal -SearchString $srchStr[1] | Where-Object {$_.DisplayName -eq $srchStr[1]}

        $spArr.Add($svcPrincipal)
        for($i=0;$i -lt $reqPermissionArr.Length;$i++ ){
            if($reqPermissionArr[$i].StartsWith($srchStr[0])){
                $grStr=$srchStr[0].ToString().Length
                $tmpnam=$srchStr[0]
                while($true){
                    if($reqPermissionArr[$i].StartsWith($tmpnam) -and $reqPermissionArr[$i].EndsWith('App')){
                        $displayNam=$reqPermissionArr[$i].Substring($grStr)
                        $appIdx=$displayNam.Length-3
                        $displayNam=$displayNam.Substring(0,$appIdx)
                        $appArray.Add($displayNam) 
                        if($i -lt $reqPermissionArr.Length-1){
                            $i++
                        }else{break;}
                    }else{
                        break;
                    }
                }
                while($true){
                    if($reqPermissionArr[$i].StartsWith($tmpnam) -and $reqPermissionArr[$i].EndsWith('Del')){     
                        $displayNam=$reqPermissionArr[$i].Substring($grStr)
                        $appIdx=$displayNam.Length-3
                        $displayNam=$displayNam.Substring(0,$appIdx)
                        $delArray.Add($displayNam)
                        if($i -lt $reqPermissionArr.Length-1){
                            $i++
                        }else{break;}
                    }else{
                        break;
                    }
                }
                $appValue=$svcPrincipal.AppRoles | Where-Object{$_.DisplayName -in $appArray}
                $delValue=$svcPrincipal.Oauth2Permissions | Where-Object{$_.AdminConsentDisplayName -in $delArray}
                $azureAppPermissions = GetRequiredPermissions -reqsp $svcPrincipal -requiredApplicationPermissions $appValue -requiredDelegatedPermissions $delValue
                $requiredResourcesAccess.Add($azureAppPermissions)
            }
        }
    }
    $startDate = (Get-Date)
    $endDate = $startDate.AddYears(2)
    $KeyDesc='SecreteG'
    Try{
        $aadApplication = New-AzureADApplication -DisplayName $appName -RequiredResourceAccess $requiredResourcesAccess
        Write-host "New AzureAD application created"
        O365-WriteLog -writString  "New AzureAD application created" -LogPath $logFile -ReportingName 'INFO'

        if($dupAppName.EndsWith('_MsGraph')){
            $tmpCreVal=New-AzureADApplicationPasswordCredential -ObjectId $aadApplication.ObjectId -StartDate $startDate -EndDate $endDate -CustomKeyIdentifier $KeyDesc
            Write-host "Secret key generated"
            O365-WriteLog -writString  "Secret key generated" -LogPath $logFile -ReportingName 'INFO'
        }

        $servicePrincipal = New-AzureADServicePrincipal -AppId $aadApplication.AppId      
        foreach ($app in $requiredResourcesAccess){   
            $reqAppSP = $spArr | Where-Object {$_.appid -contains $app.ResourceAppId}  
            foreach ($resource in $app.ResourceAccess) {
                if ($resource.Type -match "Role") {
                    New-AzureADServiceAppRoleAssignment -ObjectId $serviceprincipal.ObjectId -PrincipalId $serviceprincipal.ObjectId -ResourceId $reqAppSP.ObjectId -Id $resource.Id
                }
            }      
        }
        Write-host "permissions are configured to App.."
        O365-WriteLog -writString  "permissions are configured to App.." -LogPath $logFile -ReportingName 'INFO'
        Get-AzureADOAuth2PermissionGrant -All $true
        Write-host "Admin consent granted to permissions"
        O365-WriteLog -writString  "Admin consent granted to permissions" -LogPath $logFile -ReportingName 'INFO'
    }
    Catch{
        $message= $_.Exception.Message + $_.ScriptStackTrace 
        Write-host "[App Permissions] Exception Occurred - $message."
        O365-WriteLog -writString  "[App Permissions] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
    }

    $appId=$aadApplication.AppId

    if($dupAppName.EndsWith('_CBA')){

         ######### CERTIFICATE UPLOAD ##########
        Try{
            Write-host "Cert upload started"
            O365-WriteLog -writString  "Cert upload started" -LogPath $logFile -ReportingName 'INFO'
            $cerFile=$certDir+'\eGCBACert.cer'
            if(Test-Path -Path $cerFile -PathType Leaf){
                Remove-Item -Path $cerFile -Force
            }
            $cerPfxFile=$certDir+'\eGCBApfxCert.pfx'
            #$pfxPass='e6M0nlt0rn@'
            if($pfxPass -ne $null -and $pfxPass -ne ''){
                $encPfxPass=O365-Enc -str $pfxPass
                O365-WriteLog -writString  $encPfxPass -LogPath $logFile -ReportingName 'INFO'
            }
            if(Test-Path -Path $cerPfxFile -PathType Leaf){
                Remove-Item -Path $cerPfxFile -Force
            }
            $cert = New-SelfSignedCertificate -Subject "CN={eGCBACert}" -CertStoreLocation "Cert:\CurrentUser\My" -KeyExportPolicy Exportable -KeySpec Signature -KeyLength 2048 -KeyAlgorithm RSA -HashAlgorithm SHA256 -NotBefore (Get-Date).AddDays(-1) -NotAfter (Get-Date).AddYears(2)
            Export-Certificate -Cert $cert -FilePath $cerFile
            $cert | Export-PfxCertificate -FilePath $cerPfxFile -Password $(ConvertTo-SecureString -String $pfxPass -AsPlainText -Force)
            $cer = New-Object System.Security.Cryptography.X509Certificates.X509Certificate2
            $cer.Import($cerFile)
            $crtTPrnt=$cer.Thumbprint
            $rawData = $cer.GetRawCertData()
            $base64Value = [System.Convert]::ToBase64String($rawData)
            New-AzureADApplicationKeyCredential -ObjectId $aadApplication.ObjectId -CustomKeyIdentifier $appName -Type AsymmetricX509Cert -Usage Verify -Value $base64Value -StartDate $cer.NotBefore -EndDate $cer.NotAfter
            Write-host "Certificate uploaded successfully"
            O365-WriteLog -writString  "Certificate uploaded successfully" -LogPath $logFile -ReportingName 'INFO'

            Import-PfxCertificate -FilePath $cerPfxFile -CertStoreLocation Cert:\LocalMachine\My -Password $(ConvertTo-SecureString -String $pfxPass -AsPlainText -Force)
        }
        Catch{
            $message= $_.Exception.Message + $_.ScriptStackTrace 
            Write-host "[Cert upload] Exception Occurred - $message."
            O365-WriteLog -writString  "[Cert upload] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
        }

        Start-Sleep -Seconds 10
        $cbaClientId=$appId
        $cbaOrgNam=$orgNam
        $cbaThumbPrint=$crtTPrnt

        #Write-Host 'cbaClientId -->> ' $cbaClientId ' -- ' $cbaOrgNam ' -- ' $cbaThumbPrint

              ######## ROLE ASSIGNMENT #########         
        Try{ 
            Write-host "Role assignment started"
            O365-WriteLog -writString  "Role assignment started" -LogPath $logFile -ReportingName 'INFO'
            $azSrvcPrinc = Get-AzureADServicePrincipal -All $true| Where-Object{$_.DisplayName -eq $appName}
            $principalId=$azSrvcPrinc.ObjectId
            $count=0
            if($principalId -eq $null -or $principalId -eq ''){
                while($true){
                    O365-WriteLog -writString  "start to Sleep 60 seconds for getting PrincipalId" -LogPath $logFile -ReportingName 'INFO'
                    Write-Host 'start to Sleep 60 seconds for getting PrincipalId'
                    Start-sleep -Seconds 60
                    $azSrvcPrinc = Get-AzureADServicePrincipal -All $true| Where-Object{$_.DisplayName -eq $appName}
                    $principalId=$azSrvcPrinc.ObjectId
                    $count++
                    if($count -gt 3 -or ($principalId -ne $null -and $principalId -ne '')){
                        Write-Host 'Failed to get the PrincipalId'
                        O365-WriteLog -writString  "Failed to get the PrincipalId" -LogPath $logFile -ReportingName 'INFO'
                        break
                    }
                }
            }
            if($principalId -ne $null -and $principalId -ne ''){
                foreach($aadRole in $aadRoleArr){
                    $roleDefinition = Get-AzureADMSRoleDefinition |Where-Object {$_.DisplayName -eq $aadRole}
                    New-AzureADMSRoleAssignment -DirectoryScopeId '/' -RoleDefinitionId $roleDefinition.Id -PrincipalId $azSrvcPrinc.ObjectId
                    Write-host "Role assignment is done successfully"
                    O365-WriteLog -writString  "$aadRole - Role assignment is done successfully" -LogPath $logFile -ReportingName 'INFO'
                }
            }else{
                Write-host "Role assignment is not done successfully"
                O365-WriteLog -writString  "Role assignment is not done successfully" -LogPath $logFile -ReportingName 'INFO'
            }
        }
        Catch{
            $message= $_.Exception.Message + $_.ScriptStackTrace 
            Write-host "[Role assignment] Exception Occurred - $message."
            O365-WriteLog -writString  "[Role assignment] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
        }


        Try{
            $keyPath=$certDir+'\AppKey.dat'
            $unProtFile=$certDir+'\AppDetails.dat'
            if(Test-Path $unProtFile -PathType Leaf){
                $unProtPath=$certDir+'\AppDetails.dat'
                $kvalue=Get-Content -Path $keyPath
                Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
            }
            $certDtlPath=$certDir+'\AppDetails.txt'
            if(Test-Path $certDtlPath -PathType Leaf){
                $lines=Get-Content -Path $certDtlPath
                $wpath1=$certDir+'\AppDetails1.txt'  
                $orgChk='-'+$orgNam
                $isExist=$False
                for($i=0;$i -lt $lines.Length;$i++){
                    if($lines[$i] -match $orgChk){
                        $isExist=$true
                        $null='['+$appName+'-'+$orgNam+']'| Add-Content $wpath1 -PassThru
                        $null='app_Id~'+$appId| Add-Content $wpath1 -PassThru
                        $null='org_Name~'+$orgNam| Add-Content $wpath1 -PassThru
                        $null='cer_ThumbPrint~'+$crtTPrnt| Add-Content $wpath1 -PassThru
                        ""| Add-Content $wpath1
                        $i=$i+4
                        continue
                    }
                    Add-Content -Path $wpath1 -Value $lines[$i]
                }
                if(!$isExist){
                    $null='['+$appName+'-'+$orgNam+']'| Add-Content $wpath1 -PassThru
                    $null='app_Id~'+$appId| Add-Content $wpath1 -PassThru
                    $null='org_Name~'+$orgNam| Add-Content $wpath1 -PassThru
                    $null='cer_ThumbPrint~'+$crtTPrnt| Add-Content $wpath1 -PassThru
                    ""| Add-Content $wpath1
                }
                Remove-Item $certDtlPath
                if(Test-Path $wpath1 -PathType Leaf){
                    Rename-Item $wpath1 'AppDetails.txt'
                } 
            }else{
                $null='['+$appName+'-'+$orgNam+']'| Add-Content $certDtlPath
                $null='app_Id~'+$appId| Add-Content $certDtlPath
                $null='org_Name~'+$orgNam| Add-Content $certDtlPath
                $null='cer_ThumbPrint~'+$crtTPrnt| Add-Content $certDtlPath
                ""| Add-Content $certDtlPath
            }

            $key=Get-CryptoKey -FileDir $certDir -FileName '\AppKey.dat'
            $null=Protect-File $certDtlPath -Algorithm AES -KeyAsPlainText $key -RemoveSource
        }
        Catch{
            $message= $_.Exception.Message + $_.ScriptStackTrace 
            Write-host "Exception Occurred in writing file - $message."
            O365-WriteLog -writString  "Exception Occurred in writing file - $message." -LogPath $logFile -ReportingName 'ERROR'
        }
    }
    else{
        $client_secret=$tmpCreVal.Value
        $authority = "https://login.microsoftonline.com/"
        $resource = "https://graph.microsoft.com"
        Try{
            $grphDir=$egurkhaPath+'\agent\O365\MsGraph'
            $keyPath=$grphDir+'\GraphDetailsKey.dat'
            $unProtFile=$grphDir+'\GraphDetails.dat'
            if(Test-Path $unProtFile -PathType Leaf){
                $unProtPath=$grphDir+'\GraphDetails.dat'
                $kvalue=Get-Content -Path $keyPath
                Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
            }
            $grphDtlPath=$grphDir+'\GraphDetails.txt'
            if(Test-Path $grphDtlPath -PathType Leaf){
                $lines=Get-Content -Path $grphDtlPath
                $wpath1=$grphDir+'\GraphDetails1.txt'  
                $orgChk='-'+$orgNam
                $isExist=$False
                for($i=0;$i -lt $lines.Length;$i++){
                    if($lines[$i] -match $orgChk){
                        $isExist=$true
                        $null='['+$appName+'-'+$orgNam+']'| Add-Content $wpath1 -PassThru
                        $null='client_id~'+$appId| Add-Content $wpath1 -PassThru
                        $null='client_secret~'+$client_secret| Add-Content $wpath1 -PassThru
                        $null='TenantName~'+$orgNam| Add-Content $wpath1 -PassThru
                        $null='Authority~'+$authority| Add-Content $wpath1 -PassThru
                        $null='Resource~'+$resource| Add-Content $wpath1 -PassThru
                        $null='TenantId~'+$tenantId| Add-Content $wpath1 -PassThru
                        ""| Add-Content $wpath1
                        $i=$i+7
                        continue
                    }
                    Add-Content -Path $wpath1 -Value $lines[$i]
                }
                if(!$isExist){
                    $null='['+$appName+'-'+$orgNam+']'| Add-Content $wpath1 -PassThru
                    $null='client_id~'+$appId| Add-Content $wpath1 -PassThru
                    $null='client_secret~'+$client_secret| Add-Content $wpath1 -PassThru
                    $null='TenantName~'+$orgNam| Add-Content $wpath1 -PassThru
                    $null='Authority~'+$authority| Add-Content $wpath1 -PassThru
                    $null='Resource~'+$resource| Add-Content $wpath1 -PassThru
                    $null='TenantId~'+$tenantId| Add-Content $wpath1 -PassThru
                    ""| Add-Content $wpath1
                }
                Remove-Item $grphDtlPath
                if(Test-Path $wpath1 -PathType Leaf){
                    Rename-Item $wpath1 'GraphDetails.txt'
                } 
            }else{
                $null='['+$appName+'-'+$orgNam+']'| Add-Content $grphDtlPath
                $null='client_id~'+$appId| Add-Content $grphDtlPath
                $null='client_secret~'+$client_secret| Add-Content $grphDtlPath
                $null='TenantName~'+$orgNam| Add-Content $grphDtlPath
                $null='Authority~'+$authority| Add-Content $grphDtlPath
                $null='Resource~'+$resource| Add-Content $grphDtlPath
                $null='TenantId~'+$tenantId| Add-Content $grphDtlPath
                ""| Add-Content $grphDtlPath
            }

            $key=Get-CryptoKey -FileDir $grphDir -FileName '\GraphDetailsKey.dat'
            $null=Protect-File $grphDtlPath -Algorithm AES -KeyAsPlainText $key -RemoveSource
        }
        Catch{
            $message= $_.Exception.Message + $_.ScriptStackTrace 
            Write-host "Exception Occurred in Graph API writing file - $message."
            O365-WriteLog -writString  "Exception Occurred in Graph API writing file - $message." -LogPath $logFile -ReportingName 'ERROR'
        }
    }
}         

       ######## CREATE USER AND ASSIGN LICENSE ########
Try{
    $userdetais=''
    if($isExistingUsr){
        $userdetais=Get-AzureADUser -ObjectId $monitorUsrNam |select *
		if($userdetais -eq ''){
            $isRunLicense=$False
			Write-host "User not found - `"$monitorUsrNam`"" -ForegroundColor Red
        	O365-WriteLog -writString  "User not found - `"$monitorUsrNam`"" -LogPath $logFile -ReportingName 'INFO'
		}
    }
    else{
        $displayname=$monitorUsrNam.Split('@')[0] 
		$UsageLocation=(Get-AzureADUser -ObjectId $adminUsrNam | select UsageLocation).UsageLocation
        Write-host "creating `"$monitorUsrNam`" user..."
        O365-WriteLog -writString  "creating `"$monitorUsrNam`" user..." -LogPath $logFile -ReportingName 'INFO'
        $PasswordProfile = New-Object -TypeName Microsoft.Open.AzureAD.Model.PasswordProfile
        $PasswordProfile.Password = $monitorPass
        $PasswordProfile.ForceChangePasswordNextLogin=$False
        $userdetais=New-AzureADUser -DisplayName $displayname -PasswordProfile $PasswordProfile -UserPrincipalName $monitorUsrNam -AccountEnabled $true -MailNickName $displayname -UsageLocation $UsageLocation
        #$userdetais=New-MsolUser -UserPrincipalName $monitorUsrNam -Password $monitorPass -DisplayName $displayname -FirstName $displayname -UsageLocation $UsageLocation -ForceChangePassword $false
        if($userdetais.ObjectId -ne $null -and $userdetais.ObjectId -ne ''){
            Write-host "$monitorUsrNam - user created"
            O365-WriteLog -writString  "$monitorUsrNam - user created" -LogPath $logFile -ReportingName 'INFO'
        }
    }

    if($userdetais){
        Try{
            $skus=Get-AzureADSubscribedSku
            $skuStr=''
            foreach($sku in $skus){
                $skuStr+=$sku.SkuPartNumber+'~'
            }

            #load licenses
            $skuConfig=$egurkhaPath+'\agent\config\eg_tests.ini'
            $skuLines=get-content -Path $skuConfig
            $isO365Sub=$false
            $clientSKUsHash=@{}
            $skuUINamArr=@()
            foreach($line in $skuLines){
                if($line.StartsWith('[') -and $isO365Sub){
                    break;
                }
                if($isO365Sub){
                    $skuNams=$line.Split('=')
                    if($skuStr -match ($skuNams[0]+'~')){
                        if($clientSKUsHash.ContainsKey($skuNams[1])){
                            $clientSKUsHash.Remove($skuNams[1])
                            $clientSKUsHash.Add($skuNams[1],$skuNams[0])
                        }else{
                            $clientSKUsHash.Add($skuNams[1],$skuNams[0])
                        }
                        $skuUINamArr+=$skuNams[1]
                    }  
                }
                if($line.StartsWith('[O365_Subscriptions')){
                    $isO365Sub=$true
                }  
            }
            if($skuUINamArr.Count -gt 0){
                [void] [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms")
                [void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing") 

                #region to draw the background form
                $skuForm = New-Object System.Windows.Forms.Form
                $skuForm.Text = "O365 Cert Based Authentication"
                $skuForm.Size = New-Object System.Drawing.Size(360,140)
                $skuForm.StartPosition = "CenterScreen"
                $skuForm.KeyPreview = $True
                $skuForm.MaximumSize = $skuForm.Size
                $skuForm.MinimumSize = $skuForm.Size

                $skuLbl=New-Object System.Windows.Forms.Label
                $skuLbl.Location="10,25"
                $skuLbl.Anchor="Bottom, Left"
                $skuLbl.Text="&Assign license to user"
                $skuLbl.Size="115,20"
                $skuForm.Controls.Add($skuLbl)

                <#
                #begin to draw text box
                $skuTxtbox = New-Object System.Windows.Forms.TextBox
                $skuTxtbox.Location = New-Object System.Drawing.Size(20,48)
                $skuTxtbox.Size = New-Object System.Drawing.Size(240,20)
                $skuTxtbox.Height = 80
                $skuTxtbox.Name = 'TextBox_UserName' 
                $skuTxtbox.AutoCompleteSource = 'CustomSource' 
                $skuTxtbox.AutoCompleteMode='SuggestAppend' 
                $skuUINamArr | % { $skuTxtbox.AutoCompleteCustomSource.AddRange($_) } 
                $skuForm.Controls.Add($skuTxtbox)
                #>

                $skuListBox = New-Object system.Windows.Forms.ComboBox
                $skuListBox.Location = New-Object System.Drawing.Point(20,48)
                $skuListBox.Size = New-Object System.Drawing.Size(240,20)
                $skuListBox.Height = 80
                $skuUINamArr | ForEach-Object {[void] $skuListBox.Items.Add($_)}
                $skuForm.Controls.Add($skuListBox)
 
                #begin to draw an OK button
                $OKButton = New-Object System.Windows.Forms.Button
                $OKButton.Location = New-Object System.Drawing.Size(268,46)
                $OKButton.Size = New-Object System.Drawing.Size(40,25)
                $OKButton.Text = "OK"
                $OKButton.Add_Click({$xdept=$ListBox.SelectedItem;$xname=$skuTxtbox.Text;$xfname=$TextBoxfName.Text;$skuForm.Close()})
                $skuForm.Controls.Add($OKButton)
 
                #Make our form topmost, then show it
                $skuForm.Topmost = $True
                $skuForm.Add_Shown({$skuForm.Activate()})
                [void] $skuForm.ShowDialog()

                $skuInternlNam=''
                $skuUINam=$skuListBox.SelectedItem
                $skuInternlNam=$clientSKUsHash[$skuUINam]

                if($skuInternlNam -ne $null -and $skuInternlNam -ne ''){
                    Write-host "Started to assign license for $monitorUsrNam ..."
                    O365-WriteLog -writString "Started to assign license for $monitorUsrNam ..." -LogPath $logFile -ReportingName 'INFO'
                    $endCnt=10
                    while($true){
                        if($endCnt -eq 0){
                             Write-host "License is not assigned to $monitorUsrNam user"
                             O365-WriteLog -writString "License is not assigned to $monitorUsrNam user" -LogPath $logFile -ReportingName 'INFO'
                            break;
                        }
                        #$null=Connect-AzureAD -AzureEnvironmentName $azureCloudArr[0] -Credential $credential
                        if($userdetais.ObjectId -ne $null -and $userdetais.ObjectId -ne ''){
                            $sku=Get-AzureADSubscribedSku | Select * | where{$_.SkuPartNumber -eq $skuInternlNam}
                            Set-AzureADUser -ObjectId $userdetais.ObjectId -UsageLocation $userdetais.UsageLocation
                            $License = New-Object -TypeName Microsoft.Open.AzureAD.Model.AssignedLicense
                            $License.SkuId = $sku.SkuId
                            $LicensesToAssign = New-Object -TypeName Microsoft.Open.AzureAD.Model.AssignedLicenses
                            $LicensesToAssign.AddLicenses = $License
                            Set-AzureADUserLicense -ObjectId $userdetais.ObjectId -AssignedLicenses $LicensesToAssign
                            $adUserObjId=(Get-AzureADUser -ObjectId $userdetais.ObjectId).ObjectId
                            if($userdetais.ObjectId -eq $adUserObjId){
                                Write-host "`"$skuInternlNam`" - License assigned to $monitorUsrNam user"
                                O365-WriteLog -writString "`"$skuInternlNam`" - License assigned to $monitorUsrNam user" -LogPath $logFile -ReportingName 'INFO'
                            }
                            break;
                        }else{
                            Start-Sleep 10
                        }
                        $endCnt--
                    }
                }
            }
            else{
                Write-host "No license found"
                O365-WriteLog -writString "No license found" -LogPath $logFile -ReportingName 'INFO'
            }
        }
        Catch{
            $excepMsg='Exception Occured in License Assignment --  '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
            Write-Host $excepMsg
        }
	
        #USER ROLE ASSIGNMENT
        foreach($userRole in $usrRoleArr){
            $roleDefinition = Get-AzureADMSRoleDefinition |Where-Object {$_.DisplayName -eq $userRole}
            Try{
                if($isExistingUsr){
                    $roles = Get-AzureADMSRoleAssignment -All $true | Where-Object{$_.roleDefinitionId -eq $roleDefinition.Id -and $_.principalId -eq $userdetais.ObjectId}
                    if($roles.RoleDefinitionId -ne ''){
                        continue
                    }
                }
            }Catch{}
            $usrRoleAssignmnt = New-AzureADMSRoleAssignment -DirectoryScopeId '/' -RoleDefinitionId $roleDefinition.Id -PrincipalId $userdetais.ObjectId
            if($usrRoleAssignmnt -ne $null -and $usrRoleAssignmnt -ne ''){
                Write-host "`"$userRole`" user role is assigned to $monitorUsrNam successfully"
                O365-WriteLog -writString  "`"$userRole`" user role is assigned to $monitorUsrNam successfully" -LogPath $logFile -ReportingName 'INFO'
            }else{
                Write-host "`"$userRole`" user role is not assigned to $monitorUsrNam"
                O365-WriteLog -writString "`"$userRole`" user role is not assigned to $monitorUsrNam" -LogPath $logFile -ReportingName 'INFO'
            }
        }
    }
}
Catch{
    $message= $_.Exception.Message + $_.ScriptStackTrace 
    Write-host "Exception Occurred while creating user and assigning license - $message."
    O365-WriteLog -writString "Exception Occurred while creating user and assigning license - $message." -LogPath $logFile -ReportingName 'ERROR'
}
Disconnect-AzureAD
     

#dat file
Write-host "Cert Based Authentication - Prerequisites ended"
O365-WriteLog -writString  "CBA - Prerequisites ended" -LogPath $logFile -ReportingName 'INFO'

Start-Sleep -Seconds 10
Write-host ''

#TESTING
#--------
Write-host "Started to verify CBA Modules..."
O365-WriteLog -writString  "Started to verify CBA Modules..." -LogPath $logFile -ReportingName 'INFO'
$cbaOptStr=''
$cbaModOpts=$egurkhaPath+'\agent\O365\O365_prerequisites.log'
if((Test-Path -Path $cbaModOpts -PathType Leaf)){
    $lines=Get-Content -Path $cbaModOpts
    $cbaOptStr=''
    foreach($line in $lines){  
        if($line -match "CBA Module options@"){
            $optStr=$line.Substring($line.IndexOf('CBA Module options@')+19)
            $optStr=$optStr.Substring(0,($optStr.Length-1))
            $cbaOptStr=$optStr
        }
    }
    $cbaModuleOpts=$cbaOptStr.Split('~')
}
if($cbaOptStr -eq ''){
    $cbaModuleOpts=@('O365','EXO','SPO')
}
$cbaTenantDomain=''
foreach($modules in $cbaModuleOpts){
    if($modules -eq 'O365'){
        Try{
            $cbaAAD=Connect-AzureAD -CertificateThumbprint $cbaThumbPrint -ApplicationId $cbaClientId -TenantId $cbaOrgNam
            $cbaIniDomainDtls=Get-AzureADDomain | Where-Object{$_.IsInitial -eq 'True'} | select *
            $cbaTenantDomain=$cbaIniDomainDtls.Name
            Disconnect-AzureAD
            Write-host "`"Connect-AzureAD`" - O365 connected successfully"
            O365-WriteLog -writString  "`"Connect-AzureAD`" - O365 connected successfully" -LogPath $logFile -ReportingName 'INFO'
        }catch{
            Write-host "Failed - Unable to connect to office 365 - $_.Exception.Message"
            O365-WriteLog -writString  "Failed - Unable to connect to office 365 - $_.Exception.Message" -LogPath $logFile -ReportingName 'INFO'
        }
        Write-host ''
    }
    if($modules -eq 'EXO'){
        Try{
            Connect-ExchangeOnline -CertificateThumbPrint $cbaThumbPrint -AppID $cbaClientId -Organization $cbaOrgNam -PSSessionOption $sessionOption -ShowBanner:$false -WarningAction SilentlyContinue
            $getSession=Get-PSSession -ErrorAction SilentlyContinue
            if($getSession -ne $null -and $getSession -ne ''){
	            $null=Disconnect-ExchangeOnline -Confirm:$false
            }
            Write-host "Exchange Online connected successfully"
            O365-WriteLog -writString  "Exchange Online connected successfully" -LogPath $logFile -ReportingName 'INFO'
        }Catch{
            Write-host "Failed - Unable to connect to Exchange Online - $_.Exception.Message"
            O365-WriteLog -writString  "Failed - Unable to connect to Exchange Online - $_.Exception.Message" -LogPath $logFile -ReportingName 'INFO'
        }
        Write-host ''
    }
    if($modules -eq 'SPO'){
        Try{
            if($cbaTenantDomain -eq ''){
                $cbaAAD=Connect-AzureAD -CertificateThumbprint $cbaThumbPrint -ApplicationId $cbaClientId -TenantId $cbaOrgNam
                $cbaIniDomainDtls=Get-AzureADDomain | Where-Object{$_.IsInitial -eq 'True'} | select *
                $cbaTenantDomain=$cbaIniDomainDtls.Name
                Disconnect-AzureAD
            }
            $cbaTenantDomain=$cbaTenantDomain.Split('.')[0]
            $url = 'https://'+$cbaTenantDomain+'-admin.sharepoint.com'
            Connect-PnPOnline -Thumbprint $cbaThumbPrint -url $url -clientId $cbaClientId -Tenant $cbaOrgNam
            Disconnect-PnPOnline
            Write-host "`"Connect-PnPOnline`"-SharePoint Online connected successfully"
            O365-WriteLog -writString  "`"Connect-PnPOnline`"-SharePoint Online connected successfully" -LogPath $logFile -ReportingName 'INFO'
        }Catch{
            Write-host "Failed - Unable to connect to SharePoint Online - $_.Exception.Message"
            O365-WriteLog -writString  "Failed - Unable to connect to SharePoint Online - $_.Exception.Message" -LogPath $logFile -ReportingName 'INFO'
        }
        Write-host ''
    }
    <#
    if($modules -eq 'MTM'){
        try{
            $ConneTeams=Connect-MicrosoftTeams
            if($ConneTeams.Account -ne $null){
                Write-Host 'Microsoft Teams connected successfully'
            }else{
                Write-Host 'Failed to connect Microsoft Teams '
                O365-WriteLog -writString  "Failed - Unable to connect Microsoft Teams" -LogPath $logFile -ReportingName 'INFO'
            }
            Disconnect-MicrosoftTeams
        }catch{
            Write-Host 'Exception Occured in  Connect-MicrosoftTeams - ' $_.Exception.Message -ForegroundColor Red
            Disconnect-MicrosoftTeams
        }
    }
    #>
}
if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}

Write-host "CBA - Modules verification completed"
O365-WriteLog -writString  "CBA - Modules verification completed" -LogPath $logFile -ReportingName 'INFO'
