﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear

$Options=@()
$totModulues=''
$totAADRoles=''
$graph_DelHash=@{}
$graph_AppHash=@{}
$CBA_DelHash=@{}
$CBA_AppHash=@{}

$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExist=$false
foreach($line in $lines){  
    if($isExist){
        if($line.StartsWith('CBA_Options')){
            $totOptions=$line.Replace('CBA_Options=','')
            $Options=$totOptions.Split('~')
        }
        if($line.StartsWith('CBA_Modules')){
            $totModulues=$line.Replace('CBA_Modules=','')
        }
        if($line.StartsWith('CBA_AAD_Roles')){
            $totAADRoles=$line.Replace('CBA_AAD_Roles=','')
        }
        if($line.StartsWith('Graph_App_permissions')){
            $totAppPermisn=$line.Replace('Graph_App_permissions=','')
            if($totAppPermisn -ne 'none'){
                $arrStr=$totAppPermisn.Split('~')
                foreach($perStr in $arrStr){
                    $arr=[String]$perStr -split '#'
                    $graph_AppHash.Add($arr[0],$arr[1])
                }
            }
        }
        if($line.StartsWith('Graph_Del_permissions')){
            $totDelPermisn=$line.Replace('Graph_Del_permissions=','')
            if($totDelPermisn -ne 'none'){
                $arrStr=$totDelPermisn.Split('~')
                foreach($perStr in $arrStr){   
                    $arr=[String]$perStr -split '#'
                    $graph_DelHash.Add($arr[0],$arr[1])
                }
            }
        }
        if($line.StartsWith('CBA_App_permissions')){
            $totAppPermisn=$line.Replace('CBA_App_permissions=','')
            if($totAppPermisn -ne 'none'){
                $arrStr=$totAppPermisn.Split('~')
                foreach($perStr in $arrStr){
                    $arr=[String]$perStr -split '#'
                    $CBA_AppHash.Add($arr[0],$arr[1])
                }
            }
        }
        if($line.StartsWith('CBA_Del_permissions')){
            $totDelPermisn=$line.Replace('CBA_Del_permissions=','')
            if($totDelPermisn -ne 'none'){
                $arrStr=$totDelPermisn.Split('~')
                foreach($perStr in $arrStr){
                    $arr=[String]$perStr -split '#'
                    $CBA_DelHash.Add($arr[0],$arr[1])
                }
            }
            break;
        }
    }
    if($line.StartsWith('[O365CheckCBAPrerequisites')){
        $isExist=$true
    }
}

$aadAppName=''
$cbaAppName=''
$isExist=$false
foreach($line in $lines){
    if($isExist){
        if($line.StartsWith('APP_Name')){
            $cbaAppName=$line.Replace('APP_Name=','')
        }
        if($line.StartsWith('Graph_APP_Name')){
            $aadAppName=$line.Replace('Graph_APP_Name=','')
            break;
        }
    }
    if($line.StartsWith('[O365EnableCertBasedAuthentication')){
        $isExist=$true
    }
}

$logDir=$egurkhaPath+'\agent\O365'
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$WriteLog=$true
$LogFile = $logDir+"\Check_CBA_O365Prerequisites.log"
$LogFile1 = $logDir+"\Check_CBA_O365Prerequisites1.log"
$isFrstTimLog=$true

# Writes output to a log file with a time date stamp
Function Write-Log {
	Param ([string]$string)
	[string]$date = Get-Date -Format G
    if ($WriteLog) {
        ( "[" + $date + "] -  [O365]  -  " + $string ) | Out-File -FilePath $LogFile -Append } 
    if($isFrstTimLog){     
        if ($WriteLog -eq $true){ #if flag is true 
            if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $LogFile1 
                } 
                Rename-Item $LogFile $LogFile1 
            }
        }
        $isFrstTimLog=$false
    }
}

function CacheObject ($Object) {
    if ($Object) {
        if (-not $script:ObjectByObjectClassId.ContainsKey($Object.ObjectType)) {
            $script:ObjectByObjectClassId[$Object.ObjectType] = @{}
        }
        $script:ObjectByObjectClassId[$Object.ObjectType][$Object.ObjectId] = $Object
        $script:ObjectByObjectId[$Object.ObjectId] = $Object
    }
}


function GetObjectByObjectId ($ObjectId) {
    if (-not $script:ObjectByObjectId.ContainsKey($ObjectId)) {
        Write-Verbose ("Querying Azure AD for object '{0}'" -f $ObjectId)
        try {
            $object = Get-AzureADObjectByObjectId -ObjectId $ObjectId
            CacheObject -Object $object
        } catch {
            Write-Verbose "Object not found."
        }
    }
    return $script:ObjectByObjectId[$ObjectId]
}


function GetOAuth2PermissionGrants ([switch]$FastMode) {
    if ($FastMode) {
        Get-AzureADOAuth2PermissionGrant -All $true
    } else {
        $script:ObjectByObjectClassId['ServicePrincipal'].GetEnumerator() | ForEach-Object { $i = 0 } {
            if ($ShowProgress) {
                Write-Progress -Activity "Retrieving delegated permissions..." `
                                -Status ("Checked {0}/{1} apps" -f $i++, $servicePrincipalCount) `
                                -PercentComplete (($i / $servicePrincipalCount) * 100)
            }

            $client = $_.Value
            Get-AzureADServicePrincipalOAuth2PermissionGrant -ObjectId $client.ObjectId
        }
    }
}


Function Get-AssignedPermissions{
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$ApplicationNam,
        [Parameter(Mandatory=$true, Position=2)]
        [hashtable]$AppHash,
        [Parameter(Mandatory=$true, Position=3)]
        [hashtable]$DelHash,
        [switch] $DelegatedPermissions,
        [switch] $ApplicationPermissions,
        [string[]] $UserProperties = @("DisplayName"),
        [string[]] $ServicePrincipalProperties = @("DisplayName"),
        [switch] $ShowProgress,
        [int] $PrecacheSize = 999
    )
    
    $err_delHash=@{}
    $err_AppHash=@{}
    $err_DelStat=''
    $err_AppStat=''


    foreach($key in $DelHash.Keys){
        $val=[String]$DelHash[$key]+','
        $err_delHash.Add($key,$val)
    }
    foreach($key in $AppHash.Keys){
        $val=[String]$AppHash[$key]+','
        $err_AppHash.Add($key,$val)
    }

    try {
        $tenant_details = Get-AzureADTenantDetail
    } catch {
        throw "You must call Connect-AzureAD before running this script."
    }
    Write-Verbose ("TenantId: {0}, InitialDomain: {1}" -f `
                    $tenant_details.ObjectId, `
                    ($tenant_details.VerifiedDomains | Where-Object { $_.Initial }).Name)

    $script:ObjectByObjectId = @{}
    $script:ObjectByObjectClassId = @{}

    $empty = @{} # Used later to avoid null checks

    Write-Verbose "Retrieving all ServicePrincipal objects..."
    Get-AzureADServicePrincipal -All $true | ForEach-Object {
        CacheObject -Object $_
    }
    $servicePrincipalCount = $script:ObjectByObjectClassId['ServicePrincipal'].Count

    if ($DelegatedPermissions -or (-not ($DelegatedPermissions -or $ApplicationPermissions))) {
        Write-Verbose ("Retrieving up to {0} User objects..." -f $PrecacheSize)
        Get-AzureADUser -Top $PrecacheSize | Where-Object {
            CacheObject -Object $_
        }
        Write-Verbose "Testing for OAuth2PermissionGrants bug before querying..."
        $fastQueryMode = $false
        try {
            $null = Get-AzureADOAuth2PermissionGrant -Top 999
            $fastQueryMode = $true
        } catch {
            if ($_.Exception.Message -and $_.Exception.Message.StartsWith("Unexpected end when deserializing array.")) {
                Write-Verbose ("Fast query for delegated permissions failed, using slow method...")
            } else {
                throw $_
            }
        }

        if($DelHash.Count -gt 0){
            $DelAssignedPermissn=GetOAuth2PermissionGrants -FastMode:$fastQueryMode | ForEach-Object {
                $grant = $_
                if ($grant.Scope) {
                    $grant.Scope.Split(" ") | Where-Object { $_ } | ForEach-Object {

                        $scope = $_

                        $grantDetails =  [ordered]@{
                                "PermissionType" = "Delegated"
                                "ClientObjectId" = $grant.ClientId
                                "ResourceObjectId" = $grant.ResourceId
                                "Permission" = $scope
                                "ConsentType" = $grant.ConsentType
                                "PrincipalObjectId" = $grant.PrincipalId
                            }

                        if ($ServicePrincipalProperties.Count -gt 0) {

                            $client = GetObjectByObjectId -ObjectId $grant.ClientId
                            $resource = GetObjectByObjectId -ObjectId $grant.ResourceId
                    

                            $insertAtClient = 2
                            $insertAtResource = 3
                            foreach ($propertyName in $ServicePrincipalProperties) {
                                $grantDetails.Insert($insertAtClient++, "Client$propertyName", $client.$propertyName)
                                $insertAtResource++
                                $grantDetails.Insert($insertAtResource, "Resource$propertyName", $resource.$propertyName)
                                $insertAtResource ++
                            }
                        }

                        if ($UserProperties.Count -gt 0) {

                            $principal = $empty
                            if ($grant.PrincipalId) {
                                $principal = GetObjectByObjectId -ObjectId $grant.PrincipalId
                            }

                            foreach ($propertyName in $UserProperties) {
                                $grantDetails["Principal$propertyName"] = $principal.$propertyName
                            }
                        }

                        if($grantDetails.ClientDisplayName -eq $ApplicationNam){
                                New-Object PSObject -Property $grantDetails
                        }
 
                    }
                }
            }

            if($DelAssignedPermissn -ne $null -and $DelAssignedPermissn -ne ''){
                Write-Host "Delegated Permissions" -ForegroundColor White
                Write-Log("Delegated Permissions")
                Write-Host "---------------------" -ForegroundColor White
                Write-Log("-----------------------")
                foreach($key in $DelHash.Keys){
                    foreach($delPermissin in $DelAssignedPermissn){             
                        if([String]$DelHash[$key] -match $delPermissin.Permission){
                            $delStr=$delPermissin.ResourceDisplayName+' -- '+$delPermissin.Permission
                            Write-Host $delStr -ForegroundColor Green
                            Write-Log($delStr)
                            $removStr=$delPermissin.Permission+','
                            $val=$err_delHash[$key].ToString().Replace($removStr,'')
                            $err_delHash.Remove($key)
                            $err_delHash.Add($key,$val)
                        
                        }
                    }
                }
            }else{
                $err_DelStat='There is No Graph Delegated Roles and Permission added'
            }
        }
    }
    Write-Host ''
    Write-Log("")
    $assignedAppPermissn=@()
    $isAppExist=$false
    if($AppHash.Count -gt 0){
        if ($ApplicationPermissions -or (-not ($DelegatedPermissions -or $ApplicationPermissions))) {
            Write-Host "Application Permissions" -ForegroundColor White
            Write-Log("Application Permissions")
            Write-Host "-----------------------" -ForegroundColor White
            Write-Log("-----------------------")
            $script:ObjectByObjectClassId['ServicePrincipal'].GetEnumerator() | ForEach-Object { $i = 0 } {
                if ($ShowProgress) {
                    Write-Progress -Activity "Retrieving application permissions..." `
                                -Status ("Checked {0}/{1} apps" -f $i++, $servicePrincipalCount) `
                                -PercentComplete (($i / $servicePrincipalCount) * 100)
                }

                $sp = $_.Value

                $assignedAppPermissn=Get-AzureADServiceAppRoleAssignedTo -ObjectId $sp.ObjectId -All $true `
                | Where-Object { $_.PrincipalType -eq "ServicePrincipal" } | ForEach-Object {
                    $assignment = $_

                    $resource = GetObjectByObjectId -ObjectId $assignment.ResourceId
                    $appRole = $resource.AppRoles | Where-Object { $_.Id -eq $assignment.Id }

                    $grantDetails = [ordered]@{
                        "PermissionType" = "Application"
                        "ClientObjectId" = $assignment.PrincipalId
                        "ResourceObjectId" = $assignment.ResourceId
                        "Permission" = $appRole.Value
                    }

                    if ($ServicePrincipalProperties.Count -gt 0) {
                        $client = GetObjectByObjectId -ObjectId $assignment.PrincipalId
                        $insertAtClient = 2
                        $insertAtResource = 3
                        foreach ($propertyName in $ServicePrincipalProperties) {
                            $grantDetails.Insert($insertAtClient++, "Client$propertyName", $client.$propertyName)
                            $insertAtResource++
                            $grantDetails.Insert($insertAtResource, "Resource$propertyName", $resource.$propertyName)
                            $insertAtResource ++
                        }
                    }

                    if($grantDetails.ClientDisplayName -eq $ApplicationNam){
                        New-Object PSObject -Property $grantDetails
                    }
                    #New-Object PSObject -Property $grantDetails
                }

                if($assignedAppPermissn -ne $null -and $assignedAppPermissn -ne ''){
                    foreach($key in $AppHash.Keys){   
                        foreach($appPermission in $assignedAppPermissn){             
                            if([String]$AppHash[$key] -match $appPermission.Permission){
                                $isAppExist=$true
                                $appStr=$appPermission.ResourceDisplayName+' -- '+$appPermission.Permission
                                Write-Host $appStr -ForegroundColor Green
                                Write-Log($appStr)
                                $removStr=$appPermission.Permission+','
                                $val=$err_AppHash[$key].ToString().Replace($removStr,'')
                                $err_AppHash.Remove($key)
                                $err_AppHash.Add($key,$val)
                            }
                        }
                    }
                }
            }
        }
        if(!$isAppExist){
            $err_AppStat='There is No Graph Application Roles and Permission added'
        }
    }
    $outArr=@($err_DelStat,$err_delHash,$err_AppStat,$err_AppHash)
    return $outArr
}

$chexkBoxStr=''
######***GUI  form ****#######
    $code = @"
[DllImport("user32.dll", CharSet = CharSet.Unicode)]
public static extern IntPtr SendMessage(IntPtr hWnd, 
    int msg, IntPtr wParam, string lParam);  
public const int EM_SETCUEBANER = 0x1501;
"@
$Win32Helpers = Add-Type -MemberDefinition $code -Name "Win32Helpers" -PassThru
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing") 
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms")

$form = New-Object System.Windows.Forms.Form
$flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
$buttonOK = New-Object System.Windows.Forms.Button

$O365DtlsLbl=New-Object System.Windows.Forms.Label
$O365TntLbl=New-Object System.Windows.Forms.Label
$O365TntTxtBx=New-Object System.Windows.Forms.TextBox
    
$prxyDtlsLbl=New-Object System.Windows.Forms.Label
$prxyHostLbl=New-Object System.Windows.Forms.Label
$prxyPortLbl=New-Object System.Windows.Forms.Label
$prxyUsrLbl=New-Object System.Windows.Forms.Label
$prxyPassLbl=New-Object System.Windows.Forms.Label
$prxyHostTxtBx=New-Object System.Windows.Forms.TextBox
$prxyPortTxtBx=New-Object System.Windows.Forms.TextBox
$prxyUsrTxtBx=New-Object System.Windows.Forms.TextBox
$prxyPassTxtBx=New-Object System.Windows.Forms.TextBox

$otherDtlsLbl=New-Object System.Windows.Forms.Label
$adAppNamLbl=New-Object System.Windows.Forms.Label
$adAppNamTxtBx=New-Object System.Windows.Forms.TextBox
$cbaAppNamLbl=New-Object System.Windows.Forms.Label
$cbaAppNamTxtBx=New-Object System.Windows.Forms.TextBox

$licUsrNamLbl=New-Object System.Windows.Forms.Label
$licUsrNamTxtBx=New-Object System.Windows.Forms.TextBox

$toChkLbl=New-Object System.Windows.Forms.Label

$totalvalues = ($Options.count)

$formsize = 381 + (30 * $totalvalues)
$flowlayoutsize = 10 + (30 * $totalvalues)
$buttonplacement = 329 + (30 * $totalvalues)

$script:CheckBoxArray = @()

$form_Load = {
    foreach($opt in $Options){
        $DynamicCheckBox = New-object System.Windows.Forms.CheckBox
        $DynamicCheckBox.Margin = '12, 8, 0, 0'
        $DynamicCheckBox.Name = $opt
        $DynamicCheckBox.Size = '210, 22'
        $DynamicCheckBox.Text = "" + $opt
        $DynamicCheckBox.TextAlign = 'MiddleLeft'
        $DynamicCheckBox.Checked=$true
        $flowlayoutpanel.Controls.Add($DynamicCheckBox)
        $script:CheckBoxArray += $DynamicCheckBox
    }       
}

#$formsize = 495
$form.Controls.Add($O365DtlsLbl)
$form.Controls.Add($O365TntLbl)
$form.Controls.Add($O365TntTxtBx)

$form.Controls.Add($prxyDtlsLbl)
$form.Controls.Add($prxyHostLbl)
$form.Controls.Add($prxyHostTxtBx)
$form.Controls.Add($prxyPortLbl)
$form.Controls.Add($prxyPortTxtBx)
$form.Controls.Add($prxyUsrLbl)
$form.Controls.Add($prxyUsrTxtBx)
$form.Controls.Add($prxyPassLbl)
$form.Controls.Add($prxyPassTxtBx)
$form.Controls.Add($otherDtlsLbl)
$form.Controls.Add($adAppNamLbl)
$form.Controls.Add($adAppNamTxtBx)
$form.Controls.Add($cbaAppNamLbl)
$form.Controls.Add($cbaAppNamTxtBx)
$form.Controls.Add($licUsrNamLbl)
$form.Controls.Add($licUsrNamTxtBx)
$form.Controls.Add($infoLabel)
$form.Controls.Add($infoLabel1)
$form.Controls.Add($toChkLbl)
$form.Controls.Add($flowlayoutpanel)
$form.Controls.Add($buttonOK)

$form.AcceptButton = $buttonOK
$form.AutoScaleDimensions = '8, 17'
$form.AutoScaleMode = 'Font'
$form.ClientSize = "428 , $formsize"
$form.FormBorderStyle = 'FixedDialog'
$form.Margin = '5, 5, 5, 5'
$form.MaximizeBox = $False
$form.MinimizeBox = $False
$form.Name = 'form1'
$form.StartPosition = 'CenterScreen'
$form.Text = 'O365 CBA check prerequisites'
$form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D
$form.add_Load($($form_Load))

$flowlayoutpanel.BorderStyle = 'FixedSingle'
$flowlayoutpanel.Location = '58, 303'
$flowlayoutpanel.Margin = '4, 4, 4, 4'
$flowlayoutpanel.Name = 'flowlayoutpanel1'
$flowlayoutpanel.AccessibleName = 'flowlayoutpanel1'
$flowlayoutpanel.Size = "316, $flowlayoutsize"
$flowlayoutpanel.TabIndex = 1

$O365DtlsLbl.Location="38,15"
$O365DtlsLbl.Anchor="Bottom, Left"
$O365DtlsLbl.Text="&O365 Details:"
$O365DtlsLbl.Size="200,20"
$O365TntLbl.Location="58,38"
$O365TntLbl.Anchor="Bottom, Left"
$O365TntLbl.Text="&Tenant Name"
$O365TntLbl.Size="115,20"
$O365TntTxtBx.Location="175,38"
$O365TntTxtBx.Name="O365User"
$O365TntTxtBx.Size="200,20"
$O365TntTxtBx.Text=""

$prxyDtlsLbl.Location="38,70"
$prxyDtlsLbl.Anchor="Bottom, Left"
$prxyDtlsLbl.Text="&Proxy Details :"
$prxyDtlsLbl.Size="100,20"
$prxyHostLbl.Location="58,95" 
$prxyHostLbl.Anchor="Bottom, Left"
$prxyHostLbl.Text="&Host IP"
$prxyHostLbl.Size="115,20"
$prxyHostTxtBx.Location="175,95"
$prxyHostTxtBx.Name="ProxyHost"
$prxyHostTxtBx.Size="120,20"
$prxyHostTxtBx.Text="none"
$prxyPortLbl.Location="298,96"
$prxyPortLbl.Anchor="Bottom, Left"
$prxyPortLbl.Text="&Port"
$prxyPortLbl.Size="25,20"
$prxyPortTxtBx.Location="325,95"
$prxyPortTxtBx.Name="Port"
$prxyPortTxtBx.Size="50,20"
$prxyPortTxtBx.Text="none"
$prxyUsrLbl.Location="58,120"
$prxyUsrLbl.Anchor="Bottom, Left"
$prxyUsrLbl.Text="&Username"
$prxyUsrLbl.Size="115,20"
$prxyUsrTxtBx.Location="175,120"
$prxyUsrTxtBx.Name="ProxyUser"
$prxyUsrTxtBx.Size="200,20"
$prxyUsrTxtBx.Text="none"
$prxyPassLbl.Location="58,145"
$prxyPassLbl.Anchor="Bottom, Left"
$prxyPassLbl.Text="&Password"
$prxyPassLbl.Size="115,20"
$prxyPassTxtBx.Location="175,145"
$prxyPassTxtBx.Name="ProxyPass"
$prxyPassTxtBx.Size="200,20"
$prxyPassTxtBx.Text="none"
$prxyPassTxtBx.PasswordChar='*'

$otherDtlsLbl.Location="38,175"
$otherDtlsLbl.Anchor="Bottom, Left"
$otherDtlsLbl.Text="&Other Details :"
$otherDtlsLbl.Size="100,20"
$adAppNamLbl.Location="58,200"
$adAppNamLbl.Anchor="Bottom, Left"
$adAppNamLbl.Text="&AAD App Name"
$adAppNamLbl.Size="115,20"
$adAppNamTxtBx.Location="175,200"
$adAppNamTxtBx.Name="adAppNam"
$adAppNamTxtBx.Size="200,20"
$adAppNamTxtBx.Text=$aadAppName

$cbaAppNamLbl.Location="58,226"
$cbaAppNamLbl.Anchor="Bottom, Left"
$cbaAppNamLbl.Text="&CBA App Name"
$cbaAppNamLbl.Size="115,20"
$cbaAppNamTxtBx.Location="175,226"
$cbaAppNamTxtBx.Name="cbaAppNam"
$cbaAppNamTxtBx.Size="200,20"
$cbaAppNamTxtBx.Text=$cbaAppName

$licUsrNamLbl.Location="58,252"
$licUsrNamLbl.Anchor="Bottom, Left"
$licUsrNamLbl.Text="&Licensed user Name"
$licUsrNamLbl.Size="115,20"
$licUsrNamTxtBx.Location="175,252"
$licUsrNamTxtBx.Name="licUsrNam"
$licUsrNamTxtBx.Size="200,20"
$licUsrNamTxtBx.Text=""
$licUsrNamTxtBx.add_HandleCreated({
    $Win32Helpers::SendMessage($licUsrNamTxtBx.Handle,$Win32Helpers::EM_SETCUEBANER,[IntPtr]0, "username@domain.com")
})

$toChkLbl.Location="38,280"
$toChkLbl.Anchor="Bottom, Left"
$toChkLbl.Text="&To Check :"
$toChkLbl.Size="100,20"
    
$buttonOK.Anchor = 'Bottom, Right'
$buttonOK.DialogResult = 'OK'
$buttonOK.Location = "175, $buttonplacement"
$buttonOK.Margin = '4, 4, 4, 4'
$buttonOK.Name = 'buttonOK'
$buttonOK.Size = '100, 30'
$buttonOK.TabIndex = 0
$buttonOK.Text = '&OK'

$frmDialog=$form.ShowDialog()
if($frmDialog -eq 'OK' ){
    $tenantNam=$O365TntTxtBx.Text
    $proxyHost=$prxyHostTxtBx.Text
    $proxyPort=$prxyPortTxtBx.Text
    $proxyUsr=$prxyUsrTxtBx.Text
    $proxyPass=$prxyPassTxtBx.Text
    $adAppNam=$adAppNamTxtBx.Text
    $cbaAppNam=$cbaAppNamTxtBx.Text
    $licUserNam=$licUsrNamTxtBx.Text
    
    $chkusrLic=$false
    foreach($cbox in $CheckBoxArray){
        if($cbox.CheckState -eq 'Checked'){
            $cStr=($cbox.Name).ToString()
            $chexkBoxStr+='~'+$cStr
            if($cStr -eq 'Verify User License'){
                $chkusrLic=$true
            }
        }   
    }
    if($proxyHost -eq "" -or $proxyport -eq "" -or $proxyUsr -eq "" -or $tenantNam -eq ""){
        Write-Host "Re-run the script with all the inputs...." -ForegroundColor Red
        Exit
    }
    if($chkusrLic -and $licUserNam -eq ''){
        Write-Host "Please enter `"License user Name`" for getting the license of user...." -ForegroundColor Red
        Exit
    }
}
else{
    Write-Host 'Exiting...'
    exit
}


[string]$strtDate = Get-Date -Format G
Write-Host "****** Start at $strtDate *******"
Write-Log("****** Start at $strtDate *******")

$cn=@('AzureChinaCloud','https://partner.outlook.cn/PowerShell','smtp.partner.outlook.cn','https://login.chinacloudapi.cn','O365China')
$com=@('AzureCloud','https://outlook.office365.com/powershell-liveid/','smtp.office365.com','https://login.microsoftonline.com','O365Default')
$de=@('AzureGermanyCloud','https://outlook.office.de/powershell-liveid/','outlook.office.de','https://login.microsoftonline.de','O365GermanyCloud')
$us=@('USGovernment','None','outlook.office365.us','https://login.microsoftonline.us','O365USGovDoD')

$azureCloud=$tenantNam.Substring($tenantNam.LastIndexOf('.')+1) 
$azureCloudArr=@()

if($azureCloud -eq 'com'){$azureEnvArr=$com}
elseif($azureCloud -eq 'cn'){$azureEnvArr=$cn}
elseif($azureCloud -eq 'de'){$azureEnvArr=$de}
elseif($azureCloud -eq 'us'){$azureEnvArr=$us}  
else{$azureEnvArr=$com}

$sessionOption = New-PSSessionOption -SkipRevocationCheck
$proxyserverip=$proxyHost+':'+$proxyPort
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred =New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
    }
}

$appInfoDir=$egurkhaPath+'\agent\O365\AppInfo'
$appInfoKey=$appInfoDir+'\AppKey.dat'
$appInfoDatFile=$appInfoDir+'\AppDetails.dat'
$appInfotxt=$appInfoDir+'\AppDetails.txt'
$appkey=(Get-Content -Path $appInfoKey).Trim()

$null=Unprotect-File -FileName $appInfoDatFile -Algorithm AES -KeyAsPlainText $appkey -DstSuffix '.txt'
$appDtlsArr=Get-Content -Path $appInfotxt
Remove-Item $appInfotxt
$isAppExist=$false
foreach($appDtls in $appDtlsArr){
    if($isAppExist){
        if($appDtls.StartsWith('app_Id')){
            $clientId=([String]$appDtls.Replace('app_Id~','')).Trim()
        }
        if($appDtls.StartsWith('org_Name')){
            $tenantName=([String]$appDtls.Replace('org_Name~','')).Trim()
        }
        if($appDtls.StartsWith('cer_ThumbPrint')){
            $thumbPrint=([String]$appDtls.Replace('cer_ThumbPrint~','')).Trim()
            break;
        }
    }
    if($appDtls.ToLower().StartsWith(("[$cbaAppNam-$tenantNam").ToLower())){
        $isAppExist=$true
    }
}

<#
#User Details
$displayNam=''
#Connect-MsolService -Credential $Credential -AzureEnvironment $azureEnvArr[0]
#$usrDtls=Get-MsolUser -UserPrincipalName $userName |select DisplayName,SignInName,IsLicensed
Write-Host 'DisplayName -- SignInName -- IsLicensed' -ForegroundColor White
Write-Log("DisplayName -- SignInName -- IsLicensed")
Write-Host '---------------------------------------' -ForegroundColor White
Write-Log("---------------------------------------")
$displayNam=$usrDtls.DisplayName
$usrDtlsStr=$usrDtls.DisplayName+' -- '+$usrDtls.SignInName+' -- '+$usrDtls.IsLicensed
Write-Host $usrDtlsStr -ForegroundColor Green
Write-Log($usrDtlsStr)
Write-Host ''
Write-Log("")
#>

## Date and Time, TimeFormat Details
Write-Host 'Date and Time,Hour format Details' -ForegroundColor White
Write-Log("Date and Time,Hour format Details")
Write-Host '----------------------------------' -ForegroundColor White
Write-Log("----------------------------------")
$CultureDateTimeFormat = (Get-Culture).DateTimeFormat
$DateFormat = $CultureDateTimeFormat.ShortDatePattern
$TimeFormat = $CultureDateTimeFormat.LongTimePattern
$DateTimeFormat = "$DateFormat $TimeFormat"
Write-Host 'DateTimeFormat -->>'$DateTimeFormat -ForegroundColor Green
$datFrmtim=Get-Date -Format $DateTimeFormat
$datFrmtim12=[DateTime]::Now.AddHours(12).ToString($DateTimeFormat)
Write-Host $datFrmtim -ForegroundColor Green
Write-Host $datFrmtim12 -ForegroundColor Green
Write-Log("DateTimeFormat -->>"+$DateTimeFormat)
Write-Log($datFrmtim)
Write-Log($datFrmtim12)
Write-Host ''
Write-Log("")
Write-Host 'Date-LongDatePattern -->> '$CultureDateTimeFormat.LongDatePattern -ForegroundColor Green
Write-Log("Date-LongDatePattern -->>"+$CultureDateTimeFormat.LongDatePattern)
Write-Host 'Date-ShortDatePattern -->> '$CultureDateTimeFormat.ShortDatePattern -ForegroundColor Green
Write-Log("Date-ShortDatePattern -->>"+$CultureDateTimeFormat.ShortDatePattern)
Write-Host 'Time-LongTimePattern -->> '$CultureDateTimeFormat.LongTimePattern -ForegroundColor Green
Write-Log("Time-LongTimePattern -->>"+$CultureDateTimeFormat.LongTimePattern)
Write-Host 'Time-ShortTimePattern -->> '$CultureDateTimeFormat.ShortTimePattern -ForegroundColor Green
Write-Log("Time-ShortTimePattern -->>"+$CultureDateTimeFormat.ShortTimePattern)
Write-Host ''
Write-Log("")

Write-Host 'Hour format' -ForegroundColor White
Write-Log("Hour format")
Write-Host '------------' -ForegroundColor White
Write-Log("------------")
$format1=(Get-Date).ToString('tt')
$format2=(Get-Date).AddHours(12).ToString('tt')
Write-Host $format1 -ForegroundColor Green
Write-Log($format1)
Write-Host $format2 -ForegroundColor Green
Write-Log($format2)
Write-Host ''
Write-Log("")

## Check WINRM client -auth basic
$winrmStat=''
$chkWinrm=([String](& cmd /c "`"winrm get winrm/config/client/auth`"")).Trim().Replace(' ','')
Write-Host 'WINRM - Basic Authentication' -ForegroundColor White
Write-Log("WINRM - Basic Authentication")
Write-Host '-----------------------------' -ForegroundColor White
Write-Log("-----------------------------")
if($chkWinrm -match 'Basic=true'){
    Write-Host 'WINRM basic authentication is enabled' -ForegroundColor Green
    Write-Log("WINRM basic authentication is enabled")
}else{
    $winrmStat='WINRM basic authentication is not enabled'
    Write-Host 'WINRM basic authentication is not enabled' -ForegroundColor Red
    Write-Log("WINRM basic authentication is not enabled")
}
Write-Host ''
Write-Log("")


## Get Installed Package
$missedMod=@()
$errModules=''
Try{
    if($chexkBoxStr -match 'Modules'){
        Write-Host 'Installed Modules' -ForegroundColor White
        Write-Log("Installed Modules")
        Write-Host '-----------------' -ForegroundColor White
        Write-Log("-----------------")
        (Get-InstalledModule).Name |%{Write-Host $_ -ForegroundColor Green;Write-Log($_);$presentModStr+='~'+$_}
        $modulesArr=$totModulues.Split('~')
        foreach($module in $modulesArr){
            if($presentModStr -notmatch $module){
                $missedMod+=$module
            }       
        }
        Write-Host ''
        Write-Log("")
    }
}Catch{
    $errModules='Exception occurred while getting modules - '+$_.Exception.Message
}

#AAD Roles
$errAADRoles=''
$missedAADRoles=@()
Try{
    if($chexkBoxStr -match 'AAD Roles'){
        Write-Host 'Role Assignments for CBA App' -ForegroundColor White
        Write-Log("Role Assignments for CBA App")
        Write-Host '----------------------------' -ForegroundColor White
        Write-Log("------------------------------")
        $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
        $aadRolesArr=$totAADRoles.Split('~')
        foreach($aadRole in $aadRolesArr){
            $azSrvcPrinc = Get-AzureADServicePrincipal -All $true | Where-Object{$_.DisplayName -eq $cbaAppNam}
            $principalId=$azSrvcPrinc.ObjectId
            $roleDefinition = Get-AzureADMSRoleDefinition |Where-Object {$_.DisplayName -eq $aadRole}
            $roleDefinitionId=$roleDefinition.Id
            $roleAssignmnts=Get-AzureADMSRoleAssignment -Filter "roleDefinitionId eq '$roleDefinitionId'"
            $isRolExist=$false
            foreach($roleAssignmnt in $roleAssignmnts){
                if($roleAssignmnt.PrincipalId -eq $principalId){
                    Write-Host "`"$aadRole`" role is added to `"$cbaAppNam`"" -ForegroundColor Green
                    Write-Log("`"$aadRole`" role is added to `"$cbaAppNam`"")
                    $isRolExist=$true
                }
            }
            if(!$isRolExist){
                Write-Host "`"$aadRole`" role is not added to `"$cbaAppNam`"" -ForegroundColor Red
                Write-Log("`"$aadRole`" role is not added to `"$cbaAppNam`"")
                $missedAADRoles+=$aadRole
            }
        }
        Disconnect-AzureAD
        Write-Host ''
        Write-Log("")
    }
}
Catch{
    $errAADRoles='Exception occurred while getting AAD Roles - '+$_.Exception.Message
}


## AUDIT LOG
$auditLogStat=''
Try{
    Connect-ExchangeOnline -CertificateThumbPrint $thumbPrint -AppID $clientId -Organization $tenantName -PSSessionOption $sessionOption -ShowBanner:$false -WarningAction SilentlyContinue
    $isEnabled=Get-AdminAuditLogConfig |select *
    Write-Host 'AuditLog' -ForegroundColor White
    Write-Log("AuditLog")
    Write-Host '--------' -ForegroundColor White
    Write-Log("--------")
    if($isEnabled.UnifiedAuditLogIngestionEnabled){
        Write-Host 'AuditLog is enabled' -ForegroundColor Green
        Write-Log("AuditLog is enabled")
    }else{
        $auditLogStat='AuditLog is not enabled'
        Write-Host 'AuditLog is not enabled' -ForegroundColor Red
        Write-Log("AuditLog is not enabled")
    }
    $getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
	    $null=Disconnect-ExchangeOnline -Confirm:$false -WarningAction SilentlyContinue -InformationAction SilentlyContinue
    }  
}Catch{
    $auditLogStat='Exception occurred while checking if auditlog is enabled - '+$_.Exception.Message
}
Write-Host ''
Write-Log("")


$errGraphPermisn=''
Try{
    if($chexkBoxStr -match 'Graph Permissions'){
        Write-Host 'O365 GraphAPI Permissions' -ForegroundColor White
        Write-Log("O365 GraphAPI Permissions")
        Write-Host '-------------------------' -ForegroundColor White
        Write-Log("-------------------------")

        $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
        
        $resArr=Get-AssignedPermissions -ApplicationNam $adAppNam -AppHash $graph_AppHash -DelHash $graph_DelHash
        $errDelSt=[String]$resArr[0]
        $errDelHsh=[Hashtable]$resArr[1]
        $errAppSt=[String]$resArr[2]
        $errAppHsh=[Hashtable]$resArr[3]

        Disconnect-AzureAD
        Write-Log("")
    }
}
Catch{
    $errGraphPermisn='Exception occurred while getting graph permissions - '+$_.Exception.Message
}
Write-Host ''
Write-Log("")

$errCBAPermisn=''
Try{
    if($chexkBoxStr -match 'CBA Permissions'){
        Write-Host 'O365 CBA Permissions' -ForegroundColor White
        Write-Log("O365 CBA Permissions")
        Write-Host '-------------------------' -ForegroundColor White
        Write-Log("-------------------------")

        $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
        
        $resCBAArr=Get-AssignedPermissions -ApplicationNam $cbaAppNam -AppHash $CBA_AppHash -DelHash $CBA_DelHash
        $errCBADelSt=[String]$resCBAArr[0]
        $errCBADelHsh=[Hashtable]$resCBAArr[1]
        $errCBAAppSt=[String]$resCBAArr[2]
        $errCBAAppHsh=[Hashtable]$resCBAArr[3]

        Disconnect-AzureAD
        Write-Log("")
    }
}
Catch{
    $errCBAPermisn='Exception occurred while getting CBA permissions - '+$_.Exception.Message
}
Write-Host ''
Write-Log("")

#veryfy user license
$errVerifyLic=''
$null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
Write-Host 'Verify User License' -ForegroundColor White
Write-Log("Verify User License")
Write-Host '-------------------------' -ForegroundColor White
Write-Log("-------------------------")
Try{
    $userdetails=Get-AzureADUser -ObjectId $licUserNam |select *
    if($userdetails){
        $licenseDtls=Get-AzureADUserLicenseDetail -ObjectId $userdetails.ObjectId |select *
        if($licenseDtls){
            $licInternalNam=$licenseDtls.SkuPartNumber
            Write-Host "License Name - $licInternalNam" -ForegroundColor Green
            Write-Log("License Name - $licInternalNam")
            Write-Host 
            foreach($servPlans in $licenseDtls.ServicePlans){
                $servplanNam=$servPlans.ServicePlanName
                $servAppliesTo=$servPlans.AppliesTo
                $servProvStat=$servPlans.ProvisioningStatus
                Write-Host "$servplanNam -- $servAppliesTo -- $servProvStat" -ForegroundColor Green
                Write-Log("$servplanNam -- $servAppliesTo -- $servProvStat")
            }
        }else{
            Write-Host "License is not provided to `"$licUserNam`" user"
            Write-Log("License is not provided to `"$licUserNam`" user")
            $errVerifyLic="License is not provided to `"$licUserNam`" user"
        }
    }else{
        Write-Host "Given `"$licUserNam`" user is not created in O365"
        Write-Log("Given `"$licUserNam`" user is not created in O365")
        $errVerifyLic="Given `"$licUserNam`" user is not created in O365"
    }
}Catch{
    $errVerifyLic='Exception occurred while getting License to user - '+$_.Exception.Message
}
Disconnect-AzureAD
Write-Host ''
Write-Log("")

[string]$endDate = Get-Date -Format G
Write-Host "**** End at $endDate*****"
Write-Log("**** End at $endDate*****")
Write-Log("")



################# Missing prerequisites ########################

Write-Host ''
Write-Log("")
Write-Host '************** Missing prerequisites *******************'
Write-Log("************ Missing prerequisites ************")

if($winrmStat -ne ''){
    Write-Host 'WINRM - Basic Authentication'
    Write-Log("WINRM - Basic Authentication")
    Write-Host '----------------------------'
    Write-Log("----------------------------")
    Write-Host 'WINRM basic authentication is not enabled' -ForegroundColor Red
    Write-Log("WINRM basic authentication is not enabled")
    Write-Host ''
    Write-Log("")
}

if($chexkBoxStr -match 'Modules'){
    Write-Host 'Modules'
    Write-Log("Modules")
    Write-Host '-------'
    Write-Log("-------")
    if($errModules -ne ''){
        Write-Host $errModules
        Write-Log($errModules)
        Write-Host ''
        Write-Log("")
    }else{
        foreach($module in $missedMod){
            Write-Host $module -ForegroundColor Red
            Write-Log($module)
            Write-Host ''
            Write-Log("")
        }
    }
}

if($chexkBoxStr -match 'AAD Roles'){
    Write-Host 'AAD Roles'
    Write-Log("AAD Roles")
    Write-Host '---------'
    Write-Log("---------")
    if($errAADRoles -ne ''){
        Write-Host $errAADRoles
        Write-Log($errAADRoles)
        Write-Host ''
        Write-Log("")
    }else{
        foreach($aadRol in $missedAADRoles){
            Write-Host $aadRol -ForegroundColor Red
            Write-Log($aadRol)
            Write-Host ''
            Write-Log("")
        }
    }
}

if($auditLogStat -ne ''){
    Write-Host 'AuditLog'
    Write-Log("AuditLog")
    Write-Host '--------'
    Write-Log("--------")
    Write-Host 'AuditLog is not enabled' -ForegroundColor Red
    Write-Log("AuditLog is not enabled")
    Write-Host ''
    Write-Log("")
}


if($chexkBoxStr -match 'Graph Permissions'){
    Write-Host 'Graph Permissions' -ForegroundColor White
    Write-Host '-----------------' -ForegroundColor White
    if($errGraphPermisn -ne ''){
        Write-Host $errGraphPermisn
        Write-Log($errGraphPermisn)
        Write-Host ''
        Write-Log("")
    }

    if($graph_AppHash.Count -gt 0){
        if($errAppSt.Length -gt 0){
            Write-Host 'Application Permissions'
            Write-Host '-----------------------'
            Write-Log("Application Permissions")
            Write-Log("-----------------------")
            Write-Host $errAppSt -ForegroundColor Red
            Write-Log($errAppSt)
            Write-Host ''
            Write-Log("")
        }else{
            if($errAppHsh.Count -ne 0){
                Write-Host 'Application Permissions'
                Write-Host '-----------------------'
                Write-Log("Application Permissions")
                Write-Log("-----------------------")
                foreach($key in $errAppHsh.Keys){
                    if($errAppHsh[$key] -ne $null -and $errAppHsh[$key] -ne ''){
                        $valStr=$errAppHsh[$key].Substring(0,$errAppHsh[$key].LastIndexOf(','))
                        Write-Host $key ' -- ' $valStr -ForegroundColor Red
                        Write-Log($key+' -- '+$valStr)
                    }
                }
                Write-Host ''
                Write-Log("")
            }
        }
    }

    if($graph_DelHash.Count -gt 0){
        if($errDelSt.Length -gt 0){
            Write-Host 'Delegated Permissions'
            Write-Host '---------------------'
            Write-Log("Delegated Permissions")
            Write-Log("---------------------")
            Write-Host $errDelSt -ForegroundColor Red
            Write-Log($errDelSt)
            Write-Host ''
            Write-Log("")

        }else{
            if($errDelHsh.Count -ne 0){
                Write-Host 'Delegated Permissions'
                Write-Host '---------------------'
                Write-Log("Delegated Permissions")
                Write-Log("---------------------")
                foreach($key in $errDelHsh.Keys){
                    if($errDelHsh[$key] -ne $null -and $errDelHsh[$key] -ne ''){
                        $valStr=$errDelHsh[$key].Substring(0,$errDelHsh[$key].LastIndexOf(','))
                        Write-Host $key ' -- ' $valStr -ForegroundColor Red
                        Write-Log($key+' -- '+$valStr)
                    }
                }
                Write-Host ''
                Write-Log("")
            }
        }
    }
}

if($chexkBoxStr -match 'CBA Permissions'){
    Write-Host 'CBA Permissions' -ForegroundColor White
    Write-Host '---------------' -ForegroundColor White
    if($errCBAPermisn -ne ''){
        Write-Host $errCBAPermisn
        Write-Log($errCBAPermisn)
        Write-Host ''
        Write-Log("")
    }

    if($CBA_AppHash.Count -gt 0){
        if($errCBAAppSt.Length -gt 0){
            Write-Host 'Application Permissions'
            Write-Host '-----------------------'
            Write-Log("Application Permissions")
            Write-Log("-----------------------")
            Write-Host $errCBAAppSt -ForegroundColor Red
            Write-Log($errCBAAppSt)
            Write-Host ''
            Write-Log("")
        }else{
            if($errCBAAppHsh.Count -ne 0){
                Write-Host 'Application Permissions'
                Write-Host '-----------------------'
                Write-Log("Application Permissions")
                Write-Log("-----------------------")
                foreach($key in $errCBAAppHsh.Keys){
                    if($errCBAAppHsh[$key] -ne $null -and $errCBAAppHsh[$key] -ne ''){
                        $valStr=$errCBAAppHsh[$key].Substring(0,$errCBAAppHsh[$key].LastIndexOf(','))
                        Write-Host $key ' -- ' $valStr -ForegroundColor Red
                        Write-Log($key+' -- '+$valStr)
                    }
                }
                Write-Host ''
                Write-Log("")
            }
        }
    }

    if($CBA_DelHash.Count -gt 0){
        if($errCBADelSt.Length -gt 0){
            Write-Host 'Delegated Permissions'
            Write-Host '---------------------'
            Write-Log("Delegated Permissions")
            Write-Log("---------------------")
            Write-Host $errCBADelSt -ForegroundColor Red
            Write-Log($errCBADelSt)
            Write-Host ''
            Write-Log("")

        }else{
            if($errCBADelHsh.Count -ne 0){
                Write-Host 'Delegated Permissions'
                Write-Host '---------------------'
                Write-Log("Delegated Permissions")
                Write-Log("---------------------")
                foreach($key in $errCBADelHsh.Keys){
                    if($errCBADelHsh[$key] -ne $null -and $errCBADelHsh[$key] -ne ''){
                        $valStr=$errCBADelHsh[$key].Substring(0,$errCBADelHsh[$key].LastIndexOf(','))
                        Write-Host $key ' -- ' $valStr -ForegroundColor Red
                        Write-Log($key+' -- '+$valStr)
                    }
                }
                Write-Host ''
                Write-Log("")
            }
        }
    }
}

if($chexkBoxStr -match 'Verify User License'){  
    Write-Host 'Verify User License'
    Write-Log("Verify User License")
    Write-Host '------------------'
    Write-Log("-------------------")
    if($errVerifyLic -ne ''){
        Write-Host 'License is not provided' -ForegroundColor Red
        Write-Log("License is not provided")
        Write-Host $errVerifyLic -ForegroundColor Red
        Write-Log($errVerifyLic)
        Write-Host ''
        Write-Log("")
    }
}

if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}
