﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$proxyserver=$TestInputs[0]
$proxyUser=$TestInputs[1]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[2]
$appNames=$TestInputs[3]
$grphCertDtls=$TestInputs[4]
if($grphCertDtls -and $grphCertDtls -ne 'none'){
    $certDtlsArr=($grphCertDtls).ToString() -Split ("~!~")
    $clientId=$certDtlsArr[0]
    $tenantId=$certDtlsArr[1]
    $thumbPrint=$certDtlsArr[2]
}
#>

if($proxyUser.toString().toLower().Trim() -eq 'none') { $proxyUser=$proxyUser.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserver.toString().toLower().Trim().Contains('none')) { $proxyserver=$proxyserver.toString().toLower().Trim() }
if(!$proxyserver.Contains('none')){
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUser -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUser, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$appNamesArr=@()
if($appNames -eq 'none'){
    $certDir=$egurkhaPath+'\agent\O365\AppInfo'
    $keyPath=$certDir+'\AppKey.dat'
    $certDatFile=$certDir+'\AppDetails.dat'
    if(Test-Path $certDatFile -PathType Leaf){
        $kvalue=Get-Content -Path $keyPath
        $null=Unprotect-File $certDatFile -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
        $certDtlPath=$certDir+'\AppDetails.txt'
        if(Test-Path $certDtlPath -PathType Leaf){
            $lines=Get-Content -Path $certDtlPath
            foreach($line in $lines){
                if($line.ToLower().EndsWith(($tenantId+']'))){
                    $appStr=$line.Split('-')[0]
                    $appStr=$appStr.Replace('[','')
                    $appNamesArr+=$appStr
                    break
                }
            }
        }
        if([System.IO.File]::Exists($certDtlPath) -eq 'True'){
            Remove-Item $certDtlPath
        }
    }
    $secretDir=$egurkhaPath+'\agent\O365\MsGraph'
    $srtKeyPath=$secretDir+'\GraphDetailsKey.dat'
    $secretDatFile=$secretDir+'\GraphDetails.dat'
    if(Test-Path $secretDatFile -PathType Leaf){
        $kvalue=Get-Content -Path $srtKeyPath
        $null=Unprotect-File $secretDatFile -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
        $srtDtlPath=$secretDir+'\GraphDetails.txt'
        if(Test-Path $srtDtlPath -PathType Leaf){
            $lines=Get-Content -Path $srtDtlPath
            foreach($line in $lines){
                if($line.ToLower().EndsWith(($tenantId+']'))){
                    $srtAppStr=$line.Split('-')[0]
                    $srtAppStr=$srtAppStr.Replace('[','')
                    $appNamesArr+=$srtAppStr
                    break
                }
            }
        }
        if([System.IO.File]::Exists($srtDtlPath) -eq 'True'){
            Remove-Item $srtDtlPath
        }
    }
}else{
    $appNamesArr=$appNames.Split(',')
}

$culture = Get-Culture
$shortDatFrmt=$culture.DateTimeFormat.ShortDatePattern
$longTimFrmt=$culture.DateTimeFormat.LongTimePattern
$DateTimeFormat="$shortDatFrmt $longTimFrmt"
$hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt')
if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}
$todayDat=(Get-Date).ToString($shortDatFrmt)

$null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantId

$Applications = Get-AzureADApplication -all $true
foreach($appName in $appNamesArr){
    foreach ($app in $Applications) {
        if($appName -eq $app.DisplayName){
            $existApp = $app.DisplayName
            $certDaysDiff='none'
            $secretDaysDiff='none'
            if($app.KeyCredentials){
                $certDtls=$app.KeyCredentials
                $isFrstcrt=$true
                foreach($certDtl in $certDtls){
                    $crtDtTimStr=([DateTime]$certDtl.EndDate).ToString()
                    $certExpiryDat=(Eg-ParseExact -dateStr $crtDtTimStr -DateTimeFormat $DateTimeFormat -TimeFormat $longTimFrmt -HourFrmt $hrfrmt).ToString($shortDatFrmt)
                    $certDaysDiffTmp = (New-TimeSpan -Start $todayDat -End $certExpiryDat).Days
                    if($isFrstcrt){
                        $isFrstcrt=$false
                        $certDaysDiff=$certDaysDiffTmp
                    }
                    else{
                        if($certDaysDiff -lt $certDaysDiffTmp){
                            $certDaysDiff=$certDaysDiffTmp
                        }
                    }
                }
            }
            if($app.PasswordCredentials){
                $secretDtls=$app.PasswordCredentials
                $isFrstsec=$true
                foreach($secretDtl in $secretDtls){
                    $dttimStr=([DateTime]$secretDtl.EndDate).ToString()
                    $secretExpiryDat=(Eg-ParseExact -dateStr $dttimStr -DateTimeFormat $DateTimeFormat -TimeFormat $longTimFrmt -HourFrmt $hrfrmt).ToString($shortDatFrmt)
                    $secretDaysDiffTmp = (New-TimeSpan -Start $todayDat -End $secretExpiryDat).Days
                    if($isFrstsec){
                        $isFrstsec=$false
                        $secretDaysDiff=$secretDaysDiffTmp
                    }else{
                        if($secretDaysDiff -lt $secretDaysDiffTmp){
                            $secretDaysDiff=$secretDaysDiffTmp
                        }
                    }
                }    
            }
            if($certDaysDiff -eq $null -or $certDaysDiff -eq ''){$certDaysDiff='none'}
            if($secretDaysDiff -eq $null -or $secretDaysDiff -eq ''){$secretDaysDiff='none'}
            $measureStr='measures~'+$existApp+'~'+$certDaysDiff+'~'+$secretDaysDiff
            Write-Host $measureStr
            if($existApp -match 'CBA' -and $certDaysDiff -ne $null -and $certDaysDiff -ne 'none'){
                $certDD='certDD#'+$existApp+'#'+$tenantId+'~!~'+$existApp+'~!~'+$certExpiryDat+'~!~'+'CBA'
                Write-Host $certDD
            }
            elseif($existApp -match 'MsGraph' -and $certDaysDiff -ne $null -and $certDaysDiff -ne 'none'){
                $certDD='certDD#'+$existApp+'#'+$tenantId+'~!~'+$existApp+'~!~'+$certExpiryDat+'~!~'+'MsGraph'
                Write-Host $certDD
            }

            if($existApp -match 'MsGraph' -and $secretDaysDiff -ne $null -and $secretDaysDiff -ne 'none'){
                $secretDD='secretDD#'+$existApp+'#'+$tenantId+'~!~'+$existApp+'~!~'+$secretExpiryDat+'~!~'+'MsGraph'
                Write-Host $secretDD
            }elseif($existApp -match 'CBA' -and $secretDaysDiff -ne $null -and $secretDaysDiff -ne 'none'){
                $secretDD='secretDD#'+$existApp+'#'+$tenantId+'~!~'+$existApp+'~!~'+$secretExpiryDat+'~!~'+'CBA'
                Write-Host $secretDD
            }
            break
        }
    }
}

Disconnect-AzureAD

