$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
$dbs = Get-MailboxDatabase -Server $env:computername -Status
foreach($db in $dbs)
{
	$mxbs = Get-Mailbox -Database $db.name -resultsize unlimited
    if($mxbs -ne $null)
    {
        foreach($mxb in $mxbs)
        {
            $stats = Get-MailboxStatistics -Identity $mxb.Name
            if($stats -ne $null)
            {
                $dbName = $stats.DatabaseName
                $Name = $stats.DisplayName
                $Itemcount = $stats.ItemCount
                $TotalItemSize = $stats.TotalItemSize
                $DeletedItemCount = $stats.DeletedItemCount
                $DeletedItemSize = $stats.TotalDeletedItemSize
                $IsQuarantined = $stats.IsQuarantined
                $DisconnectDate = $stats.DisconnectDate
                if($DisconnectDate -ne $null)
                {
                    $isDisconnected = "True"
                    $DisconnectReason = $stats.DisconnectReason
                }
                else
                {
                    $isDisconnected = "False"
                    $DisconnectReason = "-"
                    $DisconnectDate = "-"
                }
                $LastLogonTime = $stats.LastLogonTime
		if($LastLogonTime -eq $null)
		{
			$LastLogonTime = "-"
		}
                $LastLogoffTime = $stats.LastLogoffTime
		if($LastLogoffTime -eq $null)
		{
			$LastLogoffTime = "-"
		}
                $TotalItemSize=[math]::Round(($TotalItemSize.ToString().Split("(")[1].Split(" ")[0].Replace(",","")/1MB),2)
                $DeletedItemSize=[math]::Round(($DeletedItemSize.ToString().Split("(")[1].Split(" ")[0].Replace(",","")/1MB),2)
                $DatabaseIssueWarningQuota = [math]::Round(($stats.DatabaseIssueWarningQuota.ToString().Split("(")[1].Split(" ")[0].Replace(",","")/1MB),2)
                $DatabaseProhibitSendQuota = [math]::Round(($stats.DatabaseProhibitSendQuota.ToString().Split("(")[1].Split(" ")[0].Replace(",","")/1MB),2)
                $DatabaseProhibitSendReceiveQuota = [math]::Round(($stats.DatabaseProhibitSendReceiveQuota.ToString().Split("(")[1].Split(" ")[0].Replace(",","")/1MB),2)

                Write-Host($dbName,$Name,$ItemCount,$TotalItemSize,$DeletedItemCount,$DeletedItemSize,$IsQuarantined,$isDisconnected,$DisconnectDate,$DisconnectReason,$LastLogonTime,$LastLogoffTime,$DatabaseIssueWarningQuota,$DatabaseProhibitSendQuota,$DatabaseProhibitSendReceiveQuota) -Separator ";"
            }



        }
    }
}

