﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear
#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
#$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$tmpEdTim=$mperiodAndIsTeam[2].Trim()
if($mperiodAndIsTeam[3]-ne $null -and $mperiodAndIsTeam[3] -ne ''){$tmpFrstUpn=$mperiodAndIsTeam[3].Trim()}else{$tmpFrstUpn=''}
if($mperiodAndIsTeam[4] -ne $null -and $mperiodAndIsTeam[4] -ne ''){$tmpSecUpn=$mperiodAndIsTeam[4].Trim()}else{$tmpSecUpn=''}
$rptTimNUPN=$tmpEdTim+'#'+$tmpFrstUpn+'#'+$tmpSecUpn
$rptNam=$TestInputs[3].Trim()
$prxyCrds=$TestInputs[4].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[5]).ToString().trim()
$showPoorStreams=$TestInputs[6]
$showGoodStreams=$TestInputs[7]
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }
$dir=$egurkhaPath +'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $dir )){
    $null=New-Item -ItemType directory -Path $dir
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$RecVDOPath=$dir+'\videoStrms'+ $timenow +".csv"
$measures='Measures.Video Stream Count','Measures.Video Poor Due To VideoPostFecplr Count','Measures.Video Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.Video Poor Due To VideoFrameRateAvg Count','Measures.Video Poor Stream Count','Measures.Video Good Stream Count','Measures.Video Unclassified Stream Count','Measures.Video Poor Percentage','Measures.Avg Video Post FECPLR','Measures.Avg Video Local Frame Loss Percentage','Measures.Avg Video Recv Frame Rate Average','Measures.Avg Video Low Frame Rate Call Percent','Measures.Avg Video Packet Loss Rate','Measures.Avg Video Frame Rate','Measures.Avg Video Dynamic Capability Percent'
$Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Is Teams','AllStreams.Media Type','AllStreams.ClassifiedPoorCall','AllStreams.First UPN','AllStreams.Second UPN'
#$VideoStms=Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object { $_.'Media Type' -eq 'Video' -and ($_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled)} | Sort-Object -Property 'End Time' -Descending
Try{
    Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object { $_.'Media Type' -eq 'Video' -and ($_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled)} | Sort-Object -Property 'End Time' | Export-Csv  $RecVDOPath -Encoding $encTyp #-Descending
}
Catch{
    $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
    Write-Host $ExcepMsg
}
[System.GC]::GetTotalMemory($true) | out-null

$VideoStms= import-csv $RecVDOPath -Encoding $encTyp
if($RecVDOPath -ne $null -and $RecVDOPath -ne ''){
    if(Test-Path -Path $RecVDOPath -PathType Leaf){
        Remove-Item $RecVDOPath -Force
    }
}
$writPath=$dir+'\MTMVideoStrms'+ $timenow +".csv"
$iswrite=$false

$strmsVCnt=0
$gdStmsVCnt=0
$unclsfyStrmsVCnt=0
$FECPLR=0
$FrmLosPercn=0
$RvFrmRat=0
$LwFrmRatPercnt=0
$PcktLosRat=0
$DynCapbltyPercnt=0

$FECPLRCnt=0;$FrmLosPerCnt=0;$LwFrmRatPerCunt=0;$PcktLosRatCnt=0;

$obj=$VideoStms| select -Last 1
$rptEdTimNUPN=([String]$obj.'End Time').Trim()+'#'+([String]$obj.'First UPN').Trim()+'#'+([String]$obj.'Second UPN').Trim()
if($showGoodStreams -eq 'none'){
    if($rptTimNUPN -ne 'none'){
        $isChkTim=$true
        foreach($strms in $VideoStms){
            if($iswrite){
                $stmStr=([String]$strms.'Video Stream Count').Trim()
                if($stmStr -ne $null -and $stmStr -ne '' -and $stmStr -ne 'NaN'){$strmsVCnt+=[int]$stmStr}
                $stmGdStr=([String]$strms.'Video Good Stream Count').Trim()
                if($stmGdStr -ne $null -and $stmGdStr -ne '' -and $stmGdStr -ne 'NaN'){$gdStmsVCnt+=[int]$stmGdStr}
                $stmUnClsStr=([String]$strms.'Video Unclassified Stream Count').Trim()
                if($stmUnClsStr -ne $null -and $stmUnClsStr -ne '' -and $stmUnClsStr -ne 'NaN'){$unclsfyStrmsVCnt+=[int]$stmUnClsStr}   
                $FECPLRStr=([String]$strms.'Avg Video Post FECPLR').Trim()
                if($FECPLRStr -ne $null -and $FECPLRStr -ne '' -and $FECPLRStr -ne 'NaN' -and $FECPLR -ne '0'){$FECPLRCnt++;$FECPLR+=[int]$FECPLRStr}
                $FrmLosPercnStr=([String]$strms.'Avg Video Local Frame Loss Percentage').Trim()
                if($FrmLosPercnStr -ne $null -and $FrmLosPercnStr -ne '' -and $FrmLosPercnStr -ne 'NaN' -and $FrmLosPercnStr -ne '0'){$FrmLosPerCnt++;$FrmLosPercn+=[int]$FrmLosPercnStr}
                $RvFrmRatStr=([String]$strms.'Avg Video Recv Frame Rate Average').Trim()
                if($RvFrmRatStr -ne $null -and $RvFrmRatStr -ne '' -and $RvFrmRatStr -ne 'NaN'){$RvFrmRat+=[int]$RvFrmRatStr}
                $LwFrmRatPercntStr=([String]$strms.'Avg Video Low Frame Rate Call Percent').Trim()
                if($LwFrmRatPercntStr -ne $null -and $LwFrmRatPercntStr -ne '' -and $LwFrmRatPercntStr -ne 'NaN' -and $LwFrmRatPercnt -ne '0'){$LwFrmRatPerCunt++ ;$LwFrmRatPercnt+=[int]$LwFrmRatPercntStr}
                $PcktLosRatStr=([String]$strms.'Avg Video Packet Loss Rate').Trim()
                if($PcktLosRatStr -ne $null -and $PcktLosRatStr -ne '' -and $PcktLosRatStr -ne 'NaN' -and $PcktLosRat -ne '0'){$PcktLosRatCnt++;$PcktLosRat+=[int]$PcktLosRatStr}
                $DynCapbltyPercntStr=([String]$strms.'Avg Video Dynamic Capability Percent').Trim()
                if($DynCapbltyPercntStr -ne $null -and $DynCapbltyPercntStr -ne '' -and $DynCapbltyPercntStr -ne 'NaN'){$DynCapbltyPercnt+=[int]$DynCapbltyPercntStr}
                $stmPrStr=([String]$strms.'Video Poor Stream Count').Trim()
                if($stmPrStr -ne $null -and $stmPrStr -ne '' -and $stmPrStr -ne 'NaN' -and [int]$stmPrStr -gt 0){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append 
                }
            }
            if($isChkTim){
                $chktimNam=([String]$strms.'End Time').Trim()+'#'+([String]$strms.'First UPN').Trim()+'#'+([String]$strms.'Second UPN').Trim()
                if($rptTimNUPN -eq $chktimNam){
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $VideoStms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $stmStr=([String]$strms.'Video Stream Count').Trim()
                    if($stmStr -ne $null -and $stmStr -ne '' -and $stmStr -ne 'NaN'){$strmsVCnt+=[int]$stmStr}
                    $stmGdStr=([String]$strms.'Video Good Stream Count').Trim()
                    if($stmGdStr -ne $null -and $stmGdStr -ne '' -and $stmGdStr -ne 'NaN'){$gdStmsVCnt+=[int]$stmGdStr}
                    $stmUnClsStr=([String]$strms.'Video Unclassified Stream Count').Trim()
                    if($stmUnClsStr -ne $null -and $stmUnClsStr -ne '' -and $stmUnClsStr -ne 'NaN'){$unclsfyStrmsVCnt+=[int]$stmUnClsStr}   
                    $FECPLRStr=([String]$strms.'Avg Video Post FECPLR').Trim()
                    if($FECPLRStr -ne $null -and $FECPLRStr -ne '' -and $FECPLRStr -ne 'NaN' -and $FECPLR -ne '0'){$FECPLRCnt++;$FECPLR+=[int]$FECPLRStr}
                    $FrmLosPercnStr=([String]$strms.'Avg Video Local Frame Loss Percentage').Trim()
                    if($FrmLosPercnStr -ne $null -and $FrmLosPercnStr -ne '' -and $FrmLosPercnStr -ne 'NaN' -and $FrmLosPercn -ne '0'){$FrmLosPerCnt++;$FrmLosPercn+=[int]$FrmLosPercnStr}
                    $RvFrmRatStr=([String]$strms.'Avg Video Recv Frame Rate Average').Trim()
                    if($RvFrmRatStr -ne $null -and $RvFrmRatStr -ne '' -and $RvFrmRatStr -ne 'NaN'){$RvFrmRat+=[int]$RvFrmRatStr}
                    $LwFrmRatPercntStr=([String]$strms.'Avg Video Low Frame Rate Call Percent').Trim()
                    if($LwFrmRatPercntStr -ne $null -and $LwFrmRatPercntStr -ne '' -and $LwFrmRatPercntStr -ne 'NaN' -and $LwFrmRatPercnt -ne '0'){$LwFrmRatPerCunt++;$LwFrmRatPercnt+=[int]$LwFrmRatPercntStr}
                    $PcktLosRatStr=([String]$strms.'Avg Video Packet Loss Rate').Trim()
                    if($PcktLosRatStr -ne $null -and $PcktLosRatStr -ne '' -and $PcktLosRatStr -ne 'NaN' -and $PcktLosRat -ne '0'){$PcktLosRatCnt++;$PcktLosRat+=[int]$PcktLosRatStr}
                    $DynCapbltyPercntStr=([String]$strms.'Avg Video Dynamic Capability Percent').Trim()
                    if($DynCapbltyPercntStr -ne $null -and $DynCapbltyPercntStr -ne '' -and $DynCapbltyPercntStr -ne 'NaN'){$DynCapbltyPercnt+=[int]$DynCapbltyPercntStr}
                    $stmPrStr=([String]$strms.'Video Poor Stream Count').Trim()
                    if($stmPrStr -ne $null -and $stmPrStr -ne '' -and $stmPrStr -ne 'NaN' -and [int]$stmPrStr -gt 0){
                        $strms| Export-Csv $writPath -Encoding $encTyp -Append 
                    }
                }
            }
        }
    }

}else{
    if($rptTimNUPN -ne 'none'){
        $isChkTim=$true
        foreach($strms in $VideoStms){
            if($iswrite){
                $strms| Export-Csv $writPath -Encoding $encTyp -Append
            }
            if($isChkTim){
                $chktimNam=([String]$strms.'End Time').Trim()+'#'+([String]$strms.'First UPN').Trim()+'#'+([String]$strms.'Second UPN').Trim()
                if($rptTimNUPN -eq $chktimNam){
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $VideoStms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append  
                }
            }
        }
    }
}

if($FECPLRCnt -ne 0){$FECPLR=($FECPLR/$FECPLRCnt)}else{$FECPLR=0}
if($FrmLosPerCnt -ne 0){$FrmLosPercn=($FrmLosPercn/$FrmLosPerCnt)}else{$FrmLosPercn=0}
if($LwFrmRatPerCunt -ne 0){$LwFrmRatPercnt=($LwFrmRatPercnt/$LwFrmRatPerCunt)}else{$LwFrmRatPercnt=0}
if($PcktLosRatCnt -ne 0){$PcktLosRat=($PcktLosRat/$PcktLosRatCnt)}else{$PcktLosRat=0}


$strcnt='StreamsCnt#'+$strmsVCnt+'~'+$gdStmsVCnt+'~'+$unclsfyStrmsVCnt+'~'+$FECPLR+'~'+$FrmLosPercn+'~'+$RvFrmRat+'~'+$LwFrmRatPercnt+'~'+$PcktLosRat+'~'+$DynCapbltyPercnt+'~'+$rptEdTimNUPN
Write-Host $strcnt
Write-Host 'LastReporting WritePath#'$writPath
[System.GC]::GetTotalMemory($true) | out-null