﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$rptNMea=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$rptNMea[0].Trim()
$rptNam=$rptNMea[1].Trim()
$lastRptConfId=$TestInputs[3]
$prxyDtls=$TestInputs[4].ToString().Split('#')
$proxyUsr=$prxyDtls[0].Trim()
$proxyPass=Eg-O365Dcr -EncStr $prxyDtls[1]
$proxyserverip=$prxyDtls[2].Trim()
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

$dir=$egurkhaPath +'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $dir )){
    $null=New-Item -ItemType directory -Path $dir
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$poorStmsPath=$dir+'\poorStrms'+ $timenow +".csv"

$measures='Measures.Audio Poor Stream Count','Measures.Audio Poor Due To Jitter Count','Measures.Audio Poor Due To PacketLoss Count','Measures.Audio Poor Due To Degradation Count','Measures.Audio Poor Due To RoundTrip Count','Measures.Audio Poor Due To ConcealedRatio Count','Measures.Video Poor Stream Count','Measures.Avg Video Post FECPLR','Measures.Avg Video Local Frame Loss Percentage','Measures.Avg Video Frame Rate','Measures.VBSS Poor Stream Count','Measures.VBSS Poor Due To VideoPostFecplr Count','Measures.VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.VBSS Poor Due To VideoFrameRateAvg Count'
$Dimentions='AllStreams.Is Teams','AllStreams.Poor','AllStreams.Unclassified','AllStreams.Start Time','AllStreams.End Time','AllStreams.First UPN','AllStreams.Second UPN','AllStreams.Organizer UPN','AllStreams.Duration (Minutes)','AllStreams.Media Type','AllStreams.Poor Reason','AllStreams.Conference Id','AllStreams.First Inside Corp','AllStreams.Second Inside Corp','AllStreams.First Network Connection Detail','AllStreams.Second Network Connection Detail','AllStreams.First VPN','AllStreams.Second VPN','AllStreams.Transport','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.First Reflexive Local IP','AllStreams.Second Reflexive Local IP','AllStreams.First Feedback Rating','AllStreams.Second Feedback Rating','AllStreams.First Capture Dev Name','AllStreams.Second Capture Dev Name','AllStreams.First Render Dev Name','AllStreams.Second Render Dev Name','AllStreams.First User Agent','AllStreams.Second User Agent','AllStreams.First CPU Name','AllStreams.Second CPU Name','AllStreams.First OS','AllStreams.Second OS','AllStreams.First Virtualization Flag','AllStreams.Second Virtualization Flag','AllStreams.First Capture Dev','AllStreams.Second Capture Dev','AllStreams.First Capture Dev Driver','AllStreams.Second Capture Dev Driver','AllStreams.First Render Dev','AllStreams.Second Render Dev','AllStreams.First Render Dev Driver','AllStreams.Second Render Dev Driver','AllStreams.First MAC Address','AllStreams.Second MAC Address','AllStreams.First Client Endpoint Name','AllStreams.Second Client Endpoint Name','AllStreams.First ASN Country','AllStreams.Second ASN Country','AllStreams.First ASN City','AllStreams.Second ASN City','AllStreams.First ASN State','AllStreams.Second ASN State','AllStreams.Region','AllStreams.First Connectivity Ice','AllStreams.Second Connectivity Ice','AllStreams.First Link Speed','AllStreams.Second Link Speed','AllStreams.Bandwidth Est','AllStreams.Inside Corp Pair','AllStreams.First Tenant Id','AllStreams.Second Tenant Id','AllStreams.Is Federated','AllStreams.First Is Caller','AllStreams.Stream Direction','AllStreams.Audio and Video Call','AllStreams.First Domain','AllStreams.Second Domain','AllStreams.Conference Type','AllStreams.First Client App Version','AllStreams.Second Client App Version','AllStreams.Meeting Id','AllStreams.Error Report Sender','AllStreams.Is Media Error','AllStreams.Media Failure Type','AllStreams.Call Setup Failure Reason','AllStreams.Session Type','AllStreams.CDR Response Reason','AllStreams.First Video Duration Seconds','AllStreams.Second Video Duration Seconds','AllStreams.Audio Degradation Avg','AllStreams.Jitter','AllStreams.Packet Loss Rate','AllStreams.Send Listen MOS','AllStreams.Overall Avg Network MOS','AllStreams.Ratio Concealed Samples Avg','AllStreams.Ratio Stretched Samples Avg','AllStreams.Round Trip','AllStreams.Packet Utilization','AllStreams.Jitter Buffer Size Avg','AllStreams.Relative OneWay Gap Duration','AllStreams.Audio Post FECPLR','AllStreams.Network Jitter Avg','AllStreams.Video Post FECPLR','AllStreams.Video Local Frame Loss Percentage Avg','AllStreams.Recv Frame Rate Average','AllStreams.Low Frame Rate Call Percent','AllStreams.Video Packet Loss Rate','AllStreams.Video Frame Rate Avg','AllStreams.Dynamic Capability Percent','AllStreams.Spoiled Tile Percent Total','AllStreams.First Network Bandwidth Low Event Ratio','AllStreams.Second Network Bandwidth Low Event Ratio','AllStreams.Video Poor Due to Freeze','AllStreams.Video Poor Due To VideoPostFecplr','AllStreams.Video Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.Video Poor Due To VideoFrameRateAvg','AllStreams.VBSS Poor Due To VideoPostFecplr','AllStreams.VBSS Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.VBSS Poor Due To VideoFrameRateAvg','AllStreams.AppSharing Poor Due To SpoiledTilePercentTotal','AllStreams.AppSharing Poor Due To RelativeOneWayAverage','AllStreams.AppSharing Poor Due To RDPTileProcessingLatencyAverage','AllStreams.Audio Poor Due To Jitter','AllStreams.Audio Poor Due To RoundTrip','AllStreams.Audio Poor Due To PacketLoss','AllStreams.Audio Poor Due To Degradation','AllStreams.Audio Poor Due To ConcealedRatio','AllStreams.First Feedback Tokens','AllStreams.Second Feedback Tokens','AllStreams.First Feedback Has Audio Issue','AllStreams.Second Feedback Has Audio Issue','AllStreams.First Feedback Has Video Issue','AllStreams.Second Feedback Has Video Issue','AllStreams.First Feedback Has AppSharing Issue','AllStreams.Second Feedback Has AppSharing Issue','AllStreams.First Feedback Text','AllStreams.Second Feedback Text'
Try{
    Get-CQDData -Measures $measures -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat -OutPutType DataTable -username $username -password $password -CQDVer V3 | Export-Csv $poorStmsPath -Encoding $encTyp #-Descending
}
Catch{
    $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
    Write-Host $ExcepMsg
}
[System.GC]::GetTotalMemory($true) | out-null


$allStrms= import-csv $poorStmsPath -Encoding $encTyp
if($poorStmsPath -ne $null -and $poorStmsPath -ne ''){
    if(Test-Path -Path $poorStmsPath -PathType Leaf){
        Remove-Item $poorStmsPath -Force
    }
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$mdifyStmsPath=$dir+'\MdifyStrms'+ $timenow +".csv"
foreach($strms in $allStrms){
    $strmsHash =[ordered] @{}
    $isOccur=$false;$isFirst=$true
    foreach( $property in $strms.psobject.properties.name)
    {
        if($property -eq 'First CPU Name'){$isOccur=$true}
        if($property -eq 'Audio Poor Stream Count'){$isOccur=$false}
        if($isOccur -and $isFirst){
            $isFirst=$false
            $sysDtls=$strms.'First CPU Name'+'~#~'+$strms.'Second CPU Name'+'~#~'+$strms.'First OS'+'~#~'+$strms.'Second OS'+'~#~'+$strms.'First Virtualization Flag'+'~#~'+$strms.'Second Virtualization Flag'+'~#~'+$strms.'First Capture Dev'+'~#~'+$strms.'Second Capture Dev'+'~#~'+$strms.'First Capture Dev Driver'+'~#~'+$strms.'Second Capture Dev Driver'+'~#~'+$strms.'First Render Dev'+'~#~'+$strms.'Second Render Dev'+'~#~'+$strms.'First Render Dev Driver'+'~#~'+$strms.'Second Render Dev Driver'+'~#~'+$strms.'First MAC Address'+'~#~'+$strms.'Second MAC Address'+'~#~'+$strms.'First Client Endpoint Name'+'~#~'+$strms.'Second Client Endpoint Name'
            $netWrkDtls=$strms.'First ASN Country'+'~#~'+$strms.'Second ASN Country'+'~#~'+$strms.'First ASN City'+'~#~'+$strms.'Second ASN City'+'~#~'+$strms.'First ASN State'+'~#~'+$strms.'Second ASN State'+'~#~'+$strms.'Region'+'~#~'+$strms.'First Connectivity Ice'+'~#~'+$strms.'Second Connectivity Ice'+'~#~'+$strms.'First Link Speed'+'~#~'+$strms.'Second Link Speed'+'~#~'+$strms.'Bandwidth Est'+'~#~'+$strms.'Inside Corp Pair'
            $callDtls=$strms.'First Tenant Id'+'~#~'+$strms.'Second Tenant Id'+'~#~'+$strms.'Is Federated'+'~#~'+$strms.'First Is Caller'+'~#~'+$strms.'Stream Direction'+'~#~'+$strms.'Audio and Video Call'+'~#~'+$strms.'First Domain'+'~#~'+$strms.'Second Domain'+'~#~'+$strms.'Conference Type'+'~#~'+$strms.'First Client App Version'+'~#~'+$strms.'Second Client App Version'+'~#~'+$strms.'Meeting Id'+'~#~'+$strms.'Error Report Sender'+'~#~'+$strms.'Is Media Error'+'~#~'+$strms.'Media Failure Type'+'~#~'+$strms.'Call Setup Failure Reason'+'~#~'+$strms.'Session Type'+'~#~'+$strms.'CDR Response Reason'+'~#~'+$strms.'First Video Duration Seconds'+'~#~'+$strms.'Second Video Duration Seconds'
            $metricsDtls=$strms.'Audio Degradation Avg'+'~#~'+$strms.'Jitter'+'~#~'+$strms.'Packet Loss Rate'+'~#~'+$strms.'Send Listen MOS'+'~#~'+$strms.'Overall Avg Network MOS'+'~#~'+$strms.'Ratio Concealed Samples Avg'+'~#~'+$strms.'Ratio Stretched Samples Avg'+'~#~'+$strms.'Round Trip'+'~#~'+$strms.'Packet Utilization'+'~#~'+$strms.'Jitter Buffer Size Avg'+'~#~'+$strms.'Relative OneWay Gap Duration'+'~#~'+$strms.'Audio Post FECPLR'+'~#~'+$strms.'Network Jitter Avg'+'~#~'+$strms.'Video Post FECPLR'+'~#~'+$strms.'Video Local Frame Loss Percentage Avg'+'~#~'+$strms.'Recv Frame Rate Average'+'~#~'+$strms.'Low Frame Rate Call Percent'+'~#~'+$strms.'Video Packet Loss Rate'+'~#~'+$strms.'Video Frame Rate Avg'+'~#~'+$strms.'Dynamic Capability Percent'+'~#~'+$strms.'Spoiled Tile Percent Total'+'~#~'+$strms.'First Network Bandwidth Low Event Ratio'+'~#~'+$strms.'Second Network Bandwidth Low Event Ratio'+'~#~'+$strms.'Video Poor Due to Freeze'+'~#~'+$strms.'Video Poor Due To VideoPostFecplr'+'~#~'+$strms.'Video Poor Due To VideoLocalFrameLossPercentageAvg'+'~#~'+$strms.'Video Poor Due To VideoFrameRateAvg'+'~#~'+$strms.'VBSS Poor Due To VideoPostFecplr'+'~#~'+$strms.'VBSS Poor Due To VideoLocalFrameLossPercentageAvg'+'~#~'+$strms.'VBSS Poor Due To VideoFrameRateAvg'+'~#~'+$strms.'AppSharing Poor Due To SpoiledTilePercentTotal'+'~#~'+$strms.'AppSharing Poor Due To RelativeOneWayAverage'+'~#~'+$strms.'AppSharing Poor Due To RDPTileProcessingLatencyAverage'+'~#~'+$strms.'Audio Poor Due To Jitter'+'~#~'+$strms.'Audio Poor Due To RoundTrip'+'~#~'+$strms.'Audio Poor Due To PacketLoss'+'~#~'+$strms.'Audio Poor Due To Degradation'+'~#~'+$strms.'Audio Poor Due To ConcealedRatio'
            $feedBackDtls=$strms.'First Feedback Tokens'+'~#~'+$strms.'Second Feedback Tokens'+'~#~'+$strms.'First Feedback Has Audio Issue'+'~#~'+$strms.'Second Feedback Has Audio Issue'+'~#~'+$strms.'First Feedback Has Video Issue'+'~#~'+$strms.'Second Feedback Has Video Issue'+'~#~'+$strms.'First Feedback Has AppSharing Issue'+'~#~'+$strms.'Second Feedback Has AppSharing Issue'+'~#~'+$strms.'First Feedback Text'+'~#~'+$strms.'Second Feedback Text'
            
            $strmsHash.Add('Video Frame Rate Avg',$strms.'Video Frame Rate Avg')
            $strmsHash.Add('First Transport Protocol',$strms.'First Transport Protocol')
            $strmsHash.Add('Second Transport Protocol',$strms.'Second Transport Protocol')
            $strmsHash.Add('Session Type',$strms.'Session Type')
            $strmsHash.Add('Stream Direction',$strms.'Stream Direction')
            $strmsHash.Add('Jitter',$strms.'Jitter')
            $strmsHash.Add('Packet Loss Rate',$strms.'Packet Loss Rate')
            $strmsHash.Add('Round Trip',$strms.'Round Trip')

            $strmsHash.Add('System Details',$sysDtls)
            $strmsHash.Add('Network Details',$netWrkDtls)
            $strmsHash.Add('Call Details',$callDtls)
            $strmsHash.Add('Metrics Details',$metricsDtls)
            $strmsHash.Add('Feedback Details',$feedBackDtls)

        }
        if(!$isOccur){
            $strmsHash.Add($property,$strms.$property)
        } 
    }
    [pscustomobject]$strmsHash | Export-Csv $mdifyStmsPath -Encoding $encTyp -Append 
}


$poorStrms= import-csv $mdifyStmsPath -Encoding $encTyp | Sort-Object -Property 'End Time'
if($mdifyStmsPath -ne $null -and $mdifyStmsPath -ne ''){
    if(Test-Path -Path $mdifyStmsPath -PathType Leaf){
        Remove-Item $mdifyStmsPath -Force
    }
}
if($poorStrms.Count -gt 0){
    $writPath=$dir+'\MTMStrms'+ $timenow +".csv"
    $iswrite=$false
    $obj=$poorStrms| select -Last 1
    #$rptEdTimNUPN=([String]$obj.'End Time').Trim()+'#'+([String]$obj.'First UPN').Trim()+'#'+([String]$obj.'Second UPN').Trim()
    $rptLastConfID=([String]$obj.'Conference Id').Trim()

    if($lastRptConfId -ne 'none'){
        $isChkTim=$true
        foreach($strms in $poorStrms){
            if($iswrite){
                $strms| Export-Csv $writPath -Encoding $encTyp -Append
            }
            if($isChkTim){
                $chkConfIdNam=([String]$strms.'Conference Id').Trim()
                if($lastRptConfId -eq $chkConfIdNam){
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $poorStrms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append  
                }
            }
        }
    }

    $confIdStr='LastConferenceID#'+$rptLastConfID
    Write-Host $confIdStr
    Write-Host 'LastReporting WritePath#'$writPath

    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')
    $credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    $azureAD=Connect-AzureAD  -AzureEnvironmentName $azureEnvArr[0] -Credential $credential |select *
    $iniDomainDtls=Get-AzureADDomain | select *
    Write-Host 'TenantDomains#'$iniDomainDtls.Name
    Disconnect-AzureAD

}

[System.GC]::GetTotalMemory($true) | out-null











