﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$testargs=$args
$Rptcrds=$testargs[0].split("#")
$reportingname='MTM/'+$Rptcrds[0]
$testFrequency=$Rptcrds[1]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

try{
    $readFilePath=$egurkhaPath+'/agent/'+$reportingname+'/'
    if(!(Test-Path -Path $readFilePath )){
       $null =  New-Item -ItemType directory -Path $readFilePath -WarningAction SilentlyContinue
    }
    $fileRead=Get-ChildItem -Path $readFilePath |Where-Object {$_.Name -like 'MTDAuditOper*.dat'}| Sort-Object LastWriteTime -Descending | Select-Object -first 1|Select Name
    if($fileRead){
	    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "MTDAuditOper" -keyFileName "kMTDAuditOper" -EgPath $egurkhaPath
        if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
    	    $datafile=$readfiles[1] -replace (".csv",".dat") 
    	    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    	    $usractivites= import-csv $csvfile -Encoding $encTyp
    	    Remove-Item $csvfile       
    	    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'MTDAuditOper' -InputFile $readfiles[3]
    	    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kMTDAuditOper' -InputFile $readfiles[4]
	        Write-Host "ReadFile:"$readfiles[3]
        }
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
[System.GC]::GetTotalMemory($true) | out-null
$MemAdtions=0
$MemRolCnged=0
$TemSetngsCnged=0
$teamdeletecnt=0
$MemberRemovedCnt=0
$ChnlStngsCngCnt=0
$TmtentStngsCngCnt=0

    foreach($input in $usractivites)
    {
        $operation=$input.Operations
        $auditdata=$input.AuditData | ConvertFrom-Json
        $auditdata.CreationTime=($auditdata.CreationTime).Replace("T"," ")
        $usertype=[int]$auditdata.UserType
        if($usertype -eq 0) { $auditdata.UserType ="Regular user" }
        if($usertype -eq 2) { $auditdata.UserType ="Administrator" }
        if($usertype -eq 3) { $auditdata.UserType ="Microsoft datacenter administrator" }
        if($usertype -eq 4) { $auditdata.UserType ="System Account" }
        if($usertype -eq 5) { $auditdata.UserType ="An Application" }
        if($usertype -eq 6) { $auditdata.UserType ="Service principal" }
        if($usertype -eq 7) { $auditdata.UserType ="Custom policy" }
        if($usertype -eq 8) { $auditdata.UserType ="System policy" }

        if($operation -eq 'MemberAdded')
        {      
      #  Creation Time, Team Name, Members (UPN Value – Role, The values should be comma separated when there are more than one member}, Team GUID, Creator (UserID)
            $memAddStr=$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.Members+'~!~'+$empty+'~!~'+$empty+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid
            write-host 'MemberAddedDD#' $memAddStr
            $MemAdtions++
        }
        if($operation -eq 'MemberRoleChanged')
        {

    # “MemberRoleChanged” - Log Time, UserID, UserTpe, DisplayName, Role, UPN, TeamName, TeamGUID

      # {@{DisplayName=Sri Devi; Role=2; UPN=sridevi@egteam.onmicrosoft.com}}
            foreach($keyvalue in $auditdata.ExtraProperties)
            {
                $DisplayName = $keyvalue.DisplayName
                $Role = ([String]$keyvalue.Role).Trim()
                $UPN = $keyvalue.UPN
            }
            if($Role.Length -gt 1999){
                $Role=$Role.Substring(0,1995)+'...'
            }
            $mrolChngStr=$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$DisplayName+'~!~'+$Role+'~!~'+$UPN+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid
            write-host 'MemberRoleChangedDD#' $mrolChngStr
            $MemRolCnged++
        } 
        
        
        if($operation -eq 'TeamSettingChanged')
        {
        # “TeamSettingChanged” - LogTime, UserID, TeamGUID, TeamName, Name, New value, Old value
            $newVal=([string]$auditdata.NewValue).Trim()
            if($newVal.Length -gt 1999){
                $newVal=$newVal.Substring(0,1995)+'...'
            }
            $tmSetChngStr=$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.Name+'~!~'+$newVal+'~!~'+$auditdata.OldValue+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid 
            write-host 'TeamSettingChangedDD#' $tmSetChngStr
            $TemSetngsCnged++
        }                                    
            
        if($operation -eq 'TeamDeleted')
        {
       # Log Time, Deleted by (UserId), Team Name, Team GUID 
            $tmDelStr=$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+'-5'+'~!~'+'-5'+'~!~'+'-5'+'~!~'+$auditdata.UserId+'~!~'+'-5'+'~!~'+$auditdata.TeamGuid
             write-host 'TeamDeletedDD#' $tmDelStr
            $teamdeletecnt++
        }
        
        if($operation -eq 'MemberRemoved')
        {
            $memRmvStr=$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.Members+'~!~'+'-5'+'~!~'+'-5'+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid 
            write-host 'MemberRemoved#' $memRmvStr
            $MemberRemovedCnt++
        }

        if($operation -eq 'ChannelSettingChanged')
        {
            $newVal=([string]$auditdata.NewValue).Trim()
            if($newVal.Length -gt 1999){
                $newVal=$newVal.Substring(0,1995)+'...'
            }
            $chnlchngStr=$auditdata.CreationTime+'~!~'+$auditdata.TeamName+'~!~'+$auditdata.Name+'~!~'+$newVal+'~!~'+$auditdata.OldValue+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$auditdata.TeamGuid+'~!~'+$auditdata.ChannelGuid 
            write-host 'ChannelSettingChangedDD#' $chnlchngStr
            $ChnlStngsCngCnt++
        }

         if($operation -eq 'TeamsTenantSettingChanged')
        {
            
            $usrKey=([string]$auditdata.UserKey).Trim()
            if($usrKey.Length -gt 1999){
                $usrKey=$usrKey.Substring(0,1995)+'...'
            }
            $tmtntChngStr=$auditdata.CreationTime+'~!~'+$auditdata.UserId+'~!~'+$auditdata.UserType+'~!~'+$usrKey+'~!~'+$auditdata.ExtraProperties+'~!~'+$auditdata.Name+'~!~'+$auditdata.NewValue
            write-host 'TeamsTenantSettingChangedDD#' $tmtntChngStr
            $TmtentStngsCngCnt++
        }                        
                
    }

    Write-host 'measures' $MemAdtions ~ $MemRolCnged ~ $TemSetngsCnged ~ $teamdeletecnt ~ $MemberRemovedCnt ~ $ChnlStngsCngCnt ~ $TmtentStngsCngCnt 

    [System.GC]::GetTotalMemory($true) | out-null
