# Get all Java Process running on the server then find and kill the agent processes if more than one running.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ProcessName = "java.exe"
$JavaProcesses = Get-WmiObject Win32_Process -Filter "name = '$ProcessName'" | Select-Object ProcessId,CommandLine
if ($JavaProcesses -ne $null)
{
	foreach ($jProcess in $JavaProcesses)  
	{
		Write-Host($jProcess.ProcessId, $jProcess.CommandLine) -Separator "#~#"
	}
}


