﻿# Hyper-V VM Snapshots
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"

$VMs = Get-VM
if($VMs -ne $null)
{
    $VMSnapshots = Get-VMSnapshot -VM $VMs
    if($VMSnapshots -ne $null)
    {
        foreach ($VMSnapshot in $VMSnapshots)
        {
           $SnapshotType = $VMSnapshot.SnapshotType
           $VMId = $VMSnapshot.VMId
           $VMName = $VMSnapshot.VMName
           $IsDeleted = $VMSnapshot.IsDeleted
           $Name = $VMSnapshot.Name
           $Notes = $VMSnapshot.Notes
           $Path = $VMSnapshot.Path
           $CreationDate = $VMSnapshot.CreationTime.ToString("MMddyyyy HH:mm")
           $CreationTime = $VMSnapshot.CreationTime.toString("G")
           $IsClustered = $VMSnapshot.IsClustered
           $SizeOfSystemFiles = $VMSnapshot.SizeOfSystemFiles
           $ParentSnapshotName = $VMSnapshot.ParentSnapshotName
           if ($Notes -eq $null -or $Notes.length -eq 0)
           {
                $Notes = "-"
           }

           if ($ParentSnapshotName -eq $null -or $ParentSnapshotName.length -eq 0)
           {
                $ParentSnapshotName = $VMName
           }

           Write-Host ($VMId,$VMName,$Name,$SnapshotType,$CreationTime,$Path,$SizeOfSystemFiles,
                       $IsDeleted,$IsClustered,$ParentSnapshotName,$Notes,$CreationDate) -Separator ";"

        }
    }
}


