$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply Admin Server"
	break
}

$adminServer = $args[0]
$Global:ErrorActionPreference="SilentlyContinue"
$adminConn = New-XdAdminConnection -Name $adminServer
Write-Host "Desktop Groups"
Write-Host "---------------"
$dgroups = Get-XdDesktopGroup 
if($dgroups -ne $null)
{
	foreach ($i in $dgroups)
	{
		$hs = $i.HostingSettings.HostingServer
		Write-Host($i.Name,$i.Enabled,$hs.Address,$hs.User,$hs.Provider) -Separator ";" 
	}
}


Disconnect-XdAdminConnection -AdminConnection $adminConn