$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

write-host "ThinApp source starts"
$LDAPPath = 'LDAP://localhost:389/OU=Package Source,OU=Properties,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry
$Selector.Filter = "(objectClass=pae-ThinAppApplicationSource)"
$Selector.PageSize = 1000
$Selector.SearchScope = "Subtree"
$thinAppSources = $Selector.FindAll()
if($thinAppSources -ne $null)
{
	foreach($thinAppSource in $thinAppSources)
	{
		$attribute = $thinAppSource.Properties
		$displayname = $attribute.'pae-displayname'
		$sharepath = $attribute.'pae-uncpath'
		$name = $attribute.'name'
		write-host($name,$displayname,$sharepath) -separator "^^"
	}
}	
$LDAPEntry.Close()
write-host "ThinApp source ends"
write-host "ThinApp packges starts"
$LDAPPath = 'LDAP://localhost:389/OU=Packages,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry
$Selector.Filter = "(objectClass=pae-PackageBase)"
$Selector.PageSize = 1000
$Selector.SearchScope = "Subtree"
$packages = $Selector.FindAll()
if($packages -ne $null)
{
	foreach($package in $packages)
	{
		$attribute = $package.Properties
		$displayname = $attribute.'pae-displayname'
		$thinappmsipath = $attribute.'pae-thinappmsipath'
		$type = $attribute.'pae-thinapptype'
		$psource = $attribute.'pae-thinappmsiprimarycontainerpath'
		$dn = $attribute.'distinguishedname'
		write-host($psource,$displayname,$thinappmsipath,$type,$dn) -separator "^^"
	}	
}
$LDAPEntry.Close()
write-host "ThinApp packges ends"
write-host "Thinapp packages hosted starts"
$LDAPPath = 'LDAP://localhost:389/OU=Applications,DC=vdi,DC=vmware,DC=int'
$LDAPEntry = New-Object DirectoryServices.DirectoryEntry $LDAPPath
$Selector = New-Object DirectoryServices.DirectorySearcher
$Selector.SearchRoot = $LDAPEntry
$Selector.Filter = "(objectClass=pae-ThinAppApplication)"
$Selector.PageSize = 1000
$Selector.SearchScope = "Subtree"
$Applications = $Selector.FindAll()
if($Applications -ne $null)
{
	foreach($Application in $Applications)
	{
		$attribute = $Application.Properties
		$displayname = $attribute.'pae-displayname'
		$type = $attribute.'pae-thinapppresentationtype'
		$package = $attribute.'pae-packages'
		if($type -eq "stream")
		{
			$servers = $attribute.'pae-serversthinappstreaminstall'
		}
		elseif($type -eq "full")
		{
			$servers = $attribute.'pae-servers'
		}
		$servers = $servers -join ";"
		write-host($displayname,$servers,$package) -separator "^^"
	}
}
write-host "Thinapp packages hosted ends"
$LDAPEntry.Close()

	