$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010
$SRVSettings = Get-ADServerSettings
if ($SRVSettings.ViewEntireForest -eq "False")
{
	Set-ADServerSettings -ViewEntireForest $true
}

$computer = $env:computername

Write-Host "Hub Transport Server Rollup Details"
Write-Host "---------------------------------------"
$Exch = Get-ExchangeServer -identity $computer  | where {$_.ServerRole -ne "Edge"} 
if($Exch)
{
	# Check for exchange server admin version
	if($Exch.AdminDisplayVersion.major -eq "8")
	{
		$E2K7 = $true
	}
	if($Exch.AdminDisplayVersion.major -eq "14")
	{
		$E2K = $true
	}
	Write-Host "Server Name: " $computer
	Write-Host "Server Role: " $Exch.ServerRole
	Write-Host "Exchange Version: " $Exch.AdminDisplayVersion
	
	#Get Exchange server version
	$MsxVersion = $Exch.ExchangeVersion		
		
	$Srv = $Exch.Name
		
	if($E2K -eq $true)
	{
		$key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\AE1D439464EB1B8488741FFA028E291C\Patches\"
	}
		
	if($E2K7 -eq $true)
	{
		$key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products\461C2B4266EDEF444B864AD6D9E5B613\Patches\"
	}
		
	$type = [Microsoft.Win32.RegistryHive]::LocalMachine
	$regKey = [Microsoft.Win32.RegistryKey]::OpenRemoteBaseKey($type, $Srv)
	$regKey = $regKey.OpenSubKey($key)
		
	if ($regKey.SubKeyCount -eq 0)
	{
		$DetailRollup+= "No Patches installed"
	}
	else
	{
		#Loop each of the subkeys (Patches) and gather the Installed date and Displayname of the Exchange patch
		$ErrorActionPreference = "SilentlyContinue"
		ForEach($sub in $regKey.GetSubKeyNames())
		{
			$SUBkey = $key + $Sub
			$SUBregKey = [Microsoft.Win32.RegistryKey]::OpenRemoteBaseKey($type, $Srv)
			$SUBregKey = $SUBregKey.OpenSubKey($SUBkey)
			ForEach($SubX in $SUBRegkey.GetValueNames())
			{
				# Display Installed date and Displayname of the Exchange patch
				IF ($Subx -eq "Installed") 
				{
					$d = $SUBRegkey.GetValue($SubX)
					$d = $d.substring(4,2) + "/" + $d.substring(6,2) + "/" + $d.substring(0,4)
				}
				IF ($Subx -eq "DisplayName") 
				{
					$cd = $SUBRegkey.GetValue($SubX)
					$DetailRollup+=  "Rollup Version:  $($d) - $($cd)"
				}
			}
		}	
		$DetailRollup+=  ""
	}
	Write-Host $DetailRollup	
}


Write-Host "HUB Transport - Transport Queue Status"
Write-Host "---------------------------------------"



$queuelist= Get-Queue -server $computer
foreach($Queue in $QueueList)
{
	if ($Queue.MessageCount -ge 250)
	{
		$Global:Valid = 0
	}
	Write-Host "Server Name: " $computer
	Write-Host "Queue Name: " $Queue.Identity
	Write-Host "Message Count: " $Queue.MessageCount
	Write-Host "NextHopDomain: " $Queue.NextHopDomain 
}

Write-Host "HUB Transport - Transport Config"
Write-Host "---------------------------------------"

$HUBTCs = Get-TransportConfig 
foreach($hubtc in $hubtcs)
{
	Write-Host "ShadowRedundancyEnabled: " $hubtc.ShadowRedundancyEnabled
	Write-Host "ShadowHeartbeatTimeoutInterval: " $hubtc.ShadowHeartbeatTimeoutInterval
	Write-Host "ShadowHeartbeatRetryCount: " $hubtc.ShadowHeartbeatRetryCount
	Write-Host "ShadowMessageAutoDiscardInterval: " $hubtc.ShadowMessageAutoDiscardInterval
	Write-Host "MaxDumpsterSizePerDatabase: " $hubtc.MaxDumpsterSizePerDatabase
	Write-Host "MaxDumpsterTime: " $hubtc.MaxDumpsterTime
	Write-Host "MaxReceiveSize: " $hubtc.MaxReceiveSize
	Write-Host "MaxRecipientEnvelopeLimit: " $hubtc.MaxRecipientEnvelopeLimit
	Write-Host "MaxSendSize: " $hubtc.MaxSendSize
}

Write-Host "HUB Transport - SEND Connectors settings"
Write-Host "---------------------------------------"

$HUBSends = Get-SendConnector
foreach($HUBSend in $HUBSends)
{
	Write-Host "Identity: " $hubsend.Identity
	Write-Host "AddressSpaces: " $hubsend.AddressSpaces
	Write-Host "HomeMtaServerId: " $hubsend.HomeMtaServerId
	Write-Host "SourceTransportServers: " $hubsend.SourceTransportServers
	Write-Host "MaxMessageSize: " $hubsend.MaxMessageSize 
	Write-Host "Port: " $hubsend.Port	
	Write-Host "Enabled: " $hubsend.Enabled
}

Write-Host "HUB Transport - RECEIVE Connectors settings"
Write-Host "---------------------------------------"

$HUBReces = get-ReceiveConnector
foreach($HUBRece in $HUBReces)
{    
	Write-Host "Identity: " $hubRece.Identity
	Write-Host "Binding: " $hubRece.Bindings
	Write-Host "Server: " $hubRece.Server
	Write-Host "MaxMessageSize: " $hubRece.MaxMessageSize
	Write-Host "Enabled: " $hubRece.Enabled   
}	
Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010
	


