$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$wmi = get-service -displayname 'Windows Management Instrumentation'
if ($wmi -ne $null)
{
	$Status = $wmi.Status
	Write-Host "WMI Status =" $Status
	if ($Status -eq "Running")
	{
		$ns = get-wmiobject -namespace "root" -class "__namespace" | select name
		if($ns -ne $null)
		{
			foreach($n in $ns)
			{
				if($n.name -eq "mscluster")
				{
					$found = $true
					break
				}
			}
			if($found)
			{
				$clusterWMI = get-wmiobject mscluster_resourcegroup -computer $env:computername -namespace "ROOT\MSCluster" -EA 0
				if ($clusterWMI -ne $null)
				{
					Write-Host "MS Failover Cluser WMI Connectivity = Connected"
				}
				else
				{
					Write-Host "MS Failover Cluser WMI Connectivity = Not Connected"
				}
			}
			else
			{
				Write-Host "MS Failover Cluser WMI Connectivity = Not Installed"
			}
		}
	}
	else
	{
		Write-Host "MS Failover Cluser WMI Connectivity = Not Installed"
	}
}
else
{
	Write-Host "MS Failover Cluser WMI Connectivity = Not Installed"
}



