﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$egurkhaPath+"\lib\EGFileEncryption.psm1"
$egDatnKy=$egurkhaPath+'\lib\GetDatnKeyFiles.psm1'
Import-Module $egEncryPath,$egDatnKy
#<#
$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$DateProxyhost=($TestInputs[4]).ToString().Split("#")
$readingdate=[datetime]($DateProxyhost[0].Trim())
$proxyserverip=($DateProxyhost[1]).ToString().trim()
$graphDetails=$TestInputs[5]
if($graphDetails -and $graphDetails -ne 'none'){
    $graphDetailsArr=($graphDetails).ToString() -Split ("~!~")
    $appId=$graphDetailsArr[0]
    $appSecret=$graphDetailsArr[1]
    $authString=$graphDetailsArr[2]
    $resource=$graphDetailsArr[3]
}
#>

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$proxyserver='http://'+$proxyserverip

$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url  
    )

    Process
    {
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()

        $header = @{
            'Authorization'=$authCode
        }
        $queryRes = [System.Text.Encoding]::UTF8.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
        #$queryRes = Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url 
        $queryRes=$queryRes.Replace('ï»¿','')
	$queryRes=$queryRes.Replace('(Byte)','')
        $queryRes=$queryRes.Replace(' ','')

        $resultarray = ConvertFrom-Csv -InputObject $queryRes
        $reprts=$resultarray | ConvertTo-Json 
        $jsonRpt=@()
        $jsonRpt='{ "Usage" :['+$reprts+']}'
        $obj=ConvertFrom-Json -InputObject $jsonRpt
        return $obj.Usage
    }
}

try{
    #$UsrLyncVersn=Eg-InvokeUrl -Url "https://graph.microsoft.com/v1.0/reports/getEmailAppUsageVersionsUserCounts(period='D7')"
    $temp=Eg-InvokeUrl -Url "https://graph.microsoft.com/v1.0/reports/getEmailAppUsageVersionsUserCounts(period='D7')" | ConvertTo-Json
    $UsrLyncVersn=@{}
    (ConvertFrom-Json $temp).psobject.properties | Foreach { $UsrLyncVersn[$_.Name] = $_.Value }
}catch{
    $message= $_.Exception.Message + $_.ScriptStackTrace 
    Write-Error -Message "Error while running Eg-InvokeUrl function $message "
}
[System.GC]::GetTotalMemory($true) | out-null

if($UsrLyncVersn -and [datetime]$UsrLyncVersn.ReportRefreshDate -ge $readingdate)
{
    foreach($key in $UsrLyncVersn.keys) {
        if($key -ne 'ReportPeriod' -and $key -ne 'ReportRefreshDate'){
            if($UsrLyncVersn[$key] -ne $null -and $UsrLyncVersn[$key] -ne ''){
                $finalStr = 'UsrLyncVersn_'+$key+' '+$UsrLyncVersn[$key]
                Write-Host $finalStr;
            }else{
                $finalStr = 'UsrLyncVersn_'+$key+' '+'0'
                Write-Host $finalStr;
            }       
        }
    }
    #Write-Host 'UsrLyncVersn_Outlook2016  '  $UsrLyncVersn.Outlook2016
    #Write-Host 'UsrLyncVersn_Outlook2013  '  $UsrLyncVersn.Outlook2013
    #Write-Host 'UsrLyncVersn_Outlook2010  '  $UsrLyncVersn.Outlook2010
    #Write-Host 'UsrLyncVersn_Outlook2007  '  $UsrLyncVersn.Outlook2007
    #Write-Host 'UsrLyncVersn_Undetermined  '  $UsrLyncVersn.Undetermined
    Write-Host 'ReadedDate for the Date#'$UsrLyncVersn.ReportRefreshDate
}
else{ Write-Host 'thereIs No Data on#' $readingdate.tostring(“yyyy-MM-dd”) }
[System.GC]::GetTotalMemory($true) | out-null