﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear

$testargs=$args
$rptTopNDD=[int]$testargs[0]
$reportingname='EXO\'+$testargs[1]
$showUsrRuleMails=$testargs[2]
$userName=$testargs[3]
$startTime=$testargs[4]
$startTime=$startTime.Replace('_',' ')

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

$CultureDateTimeFormat = (Get-Culture).DateTimeFormat
$DateFormat = $CultureDateTimeFormat.ShortDatePattern
$TimeFormat = $CultureDateTimeFormat.LongTimePattern
$DateTimeFormat = "$DateFormat $TimeFormat"
$hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt')
if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}

try{
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "transportrules" -keyFileName "ktransportrules" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
        $ruledetail= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'transportrules' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'ktransportrules' -InputFile $readfiles[4]
        Write-Host 'ReadFile:'$readfiles[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
    [System.GC]::GetTotalMemory($true) | out-null
$InEvnType= @{}
$OutEvnType= @{}
$UniqSen= @{}
$UniqRec= @{}
$evntarr= New-Object System.Collections.ArrayList

	$ruledetail= $ruledetail | Sort-Object {Eg-ParseExact -dateStr $_.'Date' -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt}  -Descending
	$LastDaterule=$ruledetail|select -Property Date -First 1    
	$TotInboundSize=0
	$TotOutboundSize=0

	$reg="^\d*/\d*/[2-9]\d\d\d \d*:\d*:\d*$"

	       foreach($ruledata in $ruledetail){
            $entryflg=$false
            if($startTime -ne $null -and $startTime -ne ''){
                $ruleDataDat=([String]$ruledata.Date).Trim()
                if($ruleDataDat -ne $null -and $ruleDataDat -ne ''){
                    $ruleDate =Eg-ParseExact -dateStr $ruleDataDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                }
                $prevTime =Eg-ParseExact -dateStr $startTime -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                #$ruleDate = [DateTime]::ParseExact($ruledata.Date,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
                #$prevTime = [DateTime]::ParseExact($startTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
                if($ruleDate -gt $prevTime){
                    $entryflg=$true
                }
            }
            else{
                $entryflg=$true
            }
            if($entryflg){  
                if(!$showUsrRuleMails)
                {
                    if( ($ruledata.SenderAddress).toString().toLower().trim() -eq $userName.toString().toLower().trim() -or ($ruledata.RecipientAddress).toString().toLower().trim() -eq $userName.toString().toLower().trim() )
                    {
                        continue;
                    }
                }

		if($evntarr -notcontains ($ruledata.EventType)){
		       $evntarr.Add( $ruledata.EventType)
		   }
			$TotMsgSize=[math]::round($ruledata.MessageSize /1Kb, 4)

            $rdataMsgId=([String]$ruledata.MessageId).Trim()
            if($rdataMsgId.Length -gt 1999){
                $rdataMsgId=$rdataMsgId.Substring(0,1995)+'...'
            }

	       if($ruledata.Direction -eq 'Inbound'){
		
		    if($InEvnType.Contains($ruledata.EventType)){
		  $tmparr=$InEvnType[$ruledata.EventType]
		  $tmparr.Add(''+$ruledata.Date+'~!~'+$ruledata.Domain+'~!~'+$ruledata.TransportRule+'~!~'+$ruledata.Subject+'~!~'+$TotMsgSize.tostring("#.##").replace(',','.')+'~!~'+$ruledata.SenderAddress+'~!~'+$ruledata.RecipientAddress+'~!~'+$ruledata.Action+'~!~'+$rdataMsgId)
		    }else{
		  $tmparr= New-Object System.Collections.ArrayList
		  $tmparr.Add(''+$ruledata.Date+'~!~'+$ruledata.Domain+'~!~'+$ruledata.TransportRule+'~!~'+$ruledata.Subject+'~!~'+$TotMsgSize.tostring("#.##").replace(',','.')+'~!~'+$ruledata.SenderAddress+'~!~'+$ruledata.RecipientAddress+'~!~'+$ruledata.Action+'~!~'+$rdataMsgId)
		  $InEvnType.Add($ruledata.EventType,$tmparr)
		    }
			$TotSize=[math]::round($spamdata.MessageSize /1Gb, 4)
			$TotInboundSize+=$TotSize 
	     }else{
		if($OutEvnType.Contains($ruledata.EventType)){
		   $tmparr=$OutEvnType[$ruledata.EventType]
		   $tmparr.Add(''+$ruledata.Date+'~!~'+$ruledata.Domain+'~!~'+$ruledata.TransportRule+'~!~'+$ruledata.Subject+'~!~'+$TotMsgSize.tostring("#.##").replace(',','.')+'~!~'+$ruledata.SenderAddress+'~!~'+$ruledata.RecipientAddress+'~!~'+$ruledata.Action+'~!~'+$rdataMsgId) 
		    }else{
		   $tmparr= New-Object System.Collections.ArrayList
		   $tmparr.Add(''+$ruledata.Date+'~!~'+$ruledata.Domain+'~!~'+$ruledata.TransportRule+'~!~'+$ruledata.Subject+'~!~'+$TotMsgSize.tostring("#.##").replace(',','.')+'~!~'+$ruledata.SenderAddress+'~!~'+$ruledata.RecipientAddress+'~!~'+$ruledata.Action+'~!~'+$rdataMsgId) 
		   $OutEvnType.Add($ruledata.EventType,$tmparr)
		    }	
			$TotSize=[math]::round($spamdata.MessageSize /1Gb, 4)
			$TotOutboundSize+=$TotSize 			
		}
		if($UniqSen.Contains($ruledata.EventType)){
		   $tmpSenAdd=$UniqSen[$ruledata.EventType]
		   $tmpRecAdd=$UniqRec[$ruledata.EventType]
		   if($tmpSenAdd -notcontains ($ruledata.SenderAddress)){
		     $tmpSenAdd.Add($ruledata.SenderAddress)
		   }
		   if($tmpRecAdd -notcontains($ruledata.RecipientAddress)){
		     $tmpRecAdd.Add($ruledata.RecipientAddress)
		   }
		}
		else{
		    $SndAdd=  New-Object System.Collections.ArrayList
		    $RecAdd=  New-Object System.Collections.ArrayList
		    $SndAdd.Add($ruledata.SenderAddress)
		    $RecAdd.Add($ruledata.RecipientAddress)
		    $UniqSen.Add($ruledata.EventType,$SndAdd)
		    $UniqRec.Add($ruledata.EventType,$RecAdd)
		}
            }
	    }

	 clear
	    
	     foreach($keys in $evntarr){
                $inevncnt=0
                $outevncnt=0
				$evntlist=$InEvnType[$keys]
		        $Outevntlist=$OutEvnType[$keys]
		#$sendlist=$UniqSen[$keys]
		#$recvlist=$UniqRec[$keys]
        if($evntlist -ne $null){
            $inevncnt=$evntlist.Count
		    For ($i=0; $i -lt $rptTopNDD; $i++) {
			        $evntdata=$evntlist[$i]
			        if($evntdata -ne $null){
			         Write-Host '# DDrule In'$keys '!' $evntdata '<!>'
			        }
		    }
        }
        if($Outevntlist -ne $null){
            $outevncnt=$Outevntlist.Count
		    For ($i1=0; $i1 -lt $rptTopNDD; $i1++) {
			        $outevntdata=$Outevntlist[$i1]
			        if($outevntdata -ne $null){
			         Write-Host '# DDrule Out'$keys '!' $outevntdata '<!>'
			        }
		    }
        }
        Write-Host '#Measure' $keys '~' $inevncnt '~' $outevncnt '~' $UniqSen[$keys].Count'~'$UniqRec[$keys].Count '<!>'
		<#foreach($senddata in $sendlist){
		    Write-Host '# UniqueSend'$keys '!' $senddata '<!>'
		}
		foreach($recvdata in $recvlist){
		    Write-Host '# UniqueRecv'$keys '!' $recvdata '<!>'
		}#>
Write-Host 'LastDate:'$LastDaterule.Date.Replace(' ','_')
     }
[System.GC]::GetTotalMemory($true) | out-null
