﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

$testargs=$args

$reportingname='EXO\'  +$testargs[0]
$lastTime=$testargs[1]
$lastTime=$lastTime.Replace('_',' ')

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

$CultureDateTimeFormat = (Get-Culture).DateTimeFormat
$DateFormat = $CultureDateTimeFormat.ShortDatePattern
$TimeFormat = $CultureDateTimeFormat.LongTimePattern
$DateTimeFormat = "$DateFormat $TimeFormat"
$hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt')
if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}
try{  
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "dlpdetails" -keyFileName "kdlpdetails" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile =Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
        $alogFile= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'dlpdetails' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kdlpdetails' -InputFile $readfiles[4]
        Write-Host 'ReadFile:'$readfiles[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
    [System.GC]::GetTotalMemory($true) | out-null
    $dlphits= New-Object System.Collections.ArrayList
    $sndadd = New-Object System.Collections.ArrayList
    $recadd = New-Object System.Collections.ArrayList
    $cultInfo=(Get-Culture).Name
    #[DateTime]::ParseExact($_.'CreationDate',$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)

    $alogFile=  $alogFile  | Sort-Object {Eg-ParseExact -dateStr $_.'CreationDate' -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt }  -Descending
	$LastDatedlp=$alogFile|select -Property CreationDate -First 1   

	if($alogFile -ne $null){ 
	    foreach($log in $alogFile){
        $entryflg=$false
            if($lastTime -ne $null -and $lastTime -ne '' -and $lastTime -ne 'none'){  
                $logCreatDat=$log.CreationDate         
                $logDate =Eg-ParseExact -dateStr $logCreatDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                $prevTime =Eg-ParseExact -dateStr $lastTime -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                #$logDate = [DateTime]::ParseExact($log.CreationDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
                #$prevTime = [DateTime]::ParseExact($lastTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
                if($logDate -gt $prevTime){
                    $entryflg=$true
                }
            }
            else{
                $entryflg=$true
            }
            if($entryflg){
                $data= $log.AuditData | ConvertFrom-Json
		try{
			$dlphits.Add($data.CreationTime +'~!~'+$data.Operation  +'~!~'+$data.ExchangeMetaData.BCC +'~!~'+ $data.ExchangeMetaData.CC +'~!~'+$data.ExchangeMetaData.From+'~!~'+$data.ExchangeMetaData.To +'~!~'+$data.ExchangeMetaData.RecipientCount+'~!~'+$data.ExchangeMetaData.Sent +'~!~'+$data.ExchangeMetaData.Subject +'~!~'+$data.UserType+'~!~'+$data.PolicyDetails.PolicyName+'~!~'+$data.PolicyDetails.Rules.Actions+'~!~'+ $data.PolicyDetails.Rules.ConditionsMatched.OtherConditions.Name +'~!~'+$data.PolicyDetails.Rules.ConditionsMatched.SensitiveInformation.Confidence +'~!~'+$data.PolicyDetails.Rules.ConditionsMatched.SensitiveInformation.Count+'~!~'+$data.PolicyDetails.Rules.ConditionsMatched.SensitiveInformation.Location +'~!~'+$data.PolicyDetails.Rules.ConditionsMatched.SensitiveInformation.SensitiveType+'~!~'+$data.PolicyDetails.Rules.ConditionsMatched.SensitiveInformation.UniqueCount+'~!~'+$data.PolicyDetails.Rules.RuleMode +'~!~'+$data.PolicyDetails.Rules.RuleName +'~!~'+$data.PolicyDetails.Rules.Severity+'~!~'+$data.UserID+'~!~'+$data.ExchangeMetaData.MessageID)
		}catch{
			$dlphits.Add($data.CreationTime +'~!~'+$data.Operation  +'~!~'+$data.ExchangeMetaData.BCC +'~!~'+ $data.ExchangeMetaData.CC +'~!~'+$data.ExchangeMetaData.From+'~!~'+$data.ExchangeMetaData.To +'~!~'+$data.ExchangeMetaData.RecipientCount+'~!~'+$data.ExchangeMetaData.Sent +'~!~'+$data.ExchangeMetaData.Subject +'~!~'+$data.UserType+'~!~'+$data.PolicyDetails.PolicyName+'~!~'+$data.PolicyDetails.Rules.Actions+'~!~'+ '-' +'~!~'+'-'+'~!~'+'-'+'~!~'+'-'+'~!~'+'-'+'~!~'+'-'+'~!~'+$data.PolicyDetails.Rules.RuleMode +'~!~'+$data.PolicyDetails.Rules.RuleName +'~!~'+$data.PolicyDetails.Rules.Severity+'~!~'+$data.UserID+'~!~'+$data.ExchangeMetaData.MessageID)
		}
                $sender=$data.ExchangeMetaData.From.Split(" ")
		        $Recv  =$data.ExchangeMetaData.To.Split(" ")
		        foreach($snd in $sender){
			        if($sndadd -notcontains $snd){
			            $sndadd.Add($snd)
			        }
		        }
		        foreach($Rec in $Recv){
			        if($recadd -notcontains $Rec){
			            $recadd.Add($Rec)
			        }
		        }
            }
		    }
clear

Write-Host 'ComplianceDLPExchangecnt'$dlphits.Count '~'$sndadd.Count'~'$recadd.Count
            foreach($dlphit in $dlphits){
		           Write-Host 'DlpDetect' $dlphit
	        }		    
            foreach($snd in $sndadd){
		           Write-Host 'Send'$snd
		    }
		    foreach($rec in $recadd){
		           Write-Host 'Recv'$rec
		    }
	    Write-Host 'LastDate:'$LastDatedlp.CreationDate.Replace(' ','_')
	    }
	else
	  {
	    Write-Host 'ComplianceDLPExchangecnt0~0~0'
	  }

[System.GC]::GetTotalMemory($true) | out-null

