﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
#<#
$TestInputs=$args
$reportingname='EXO/'+$TestInputs[0]
$userName=$TestInputs[1]
$Password=Eg-O365Dcr -EncStr $TestInputs[2]
$proxyids=$TestInputs[3]
$days=$TestInputs[4]
$rptTopNDD=[int]$TestInputs[5]
$appDetails=$TestInputs[6]
#>

$prxyusrpwd=$proxyids.split("#")
$alldays=$days.split("#")
$proxyUsr=$prxyusrpwd[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyusrpwd[1]
$activeDays=$alldays[0]
$InactiveDays=$alldays[1]
$PassExpDays=$alldays[2]
$ExcludingNames=$alldays[3]
$proxyserverip=($alldays[4]).ToString().trim()

if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }

$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}
if($appDetails -and $appDetails -ne 'none'){
    $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
}else{
    Connect-MsolService  -Credential $cred -AzureEnvironment $azureEnvArr[0]
}

$readfiles=0
$readfiles1=0
$readfiles2=0
$readfiles3=0
$dmnPwdExp=@{}

try{  
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
        $measureterms= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'mailbox' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kmailbox' -InputFile $readfiles[4]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}

try{
    $readfiles1=Eg-ReadFile -ComntRptPath $reportingname -FileName "casmailboxes" -keyFileName "kcasmailboxes" -EgPath $egurkhaPath
    if($readfiles1 -ne $null -and [System.IO.File]::Exists($readfiles1[1]) -eq 'True'){
        $datafile1=$readfiles1[1] -replace (".csv",".dat") 
        $csvfile1=Unprotect-File $datafile1 -Algorithm AES -KeyAsPlainText $readfiles1[0]	
        $DDD= import-csv $csvfile1 -Encoding $encTyp
        Remove-Item $csvfile1
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'casmailboxes' -InputFile $readfiles1[3]
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'kcasmailboxes' -InputFile $readfiles1[4]
    }
}
catch{
    $errmsg1=$_.Exception.Message
    Write-Error -Message $errmsg1
}
[System.GC]::GetTotalMemory($true) | out-null

try{
    $readfiles2=Eg-ReadFile -ComntRptPath $reportingname -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
    if($readfiles2 -ne $null -and [System.IO.File]::Exists($readfiles2[1]) -eq 'True'){
        $datafile2=$readfiles2[1] -replace (".csv",".dat") 
        $csvfile2=Unprotect-File $datafile2 -Algorithm AES -KeyAsPlainText $readfiles2[0]	
        $mailboxstatistics= import-csv $csvfile2 -Encoding $encTyp
        Remove-Item $csvfile2
        Eg-DeleteFiles -FilePath $readfiles2[2] -Pattern 'statsMailbox' -InputFile $readfiles2[3]
        Eg-DeleteFiles -FilePath $readfiles2[2] -Pattern 'kstatsMailbox' -InputFile $readfiles2[4]
	    $mailStats=$mailboxstatistics | select -First 1
    }
	#$isPreviousScript=[bool]($mailStats.PSobject.Properties.name -match "PrimarySmtpAddress")
}
catch{
    $errmsg2=$_.Exception.Message
    Write-Error -Message $errmsg2
}
[System.GC]::GetTotalMemory($true) | out-null

try{
    $readfiles3=Eg-ReadFile -ComntRptPath $reportingname -FileName "RecipntPerm" -keyFileName "kRecipntPerm" -EgPath $egurkhaPath
    if($readfiles3 -ne $null -and [System.IO.File]::Exists($readfiles3[1]) -eq 'True'){
        $datafile3=$readfiles3[1] -replace (".csv",".dat") 
        $csvfile3=Unprotect-File $datafile3 -Algorithm AES -KeyAsPlainText $readfiles3[0]	
        $ReciPrmterm= import-csv $csvfile3 -Encoding $encTyp
        Remove-Item $csvfile3
        Eg-DeleteFiles -FilePath $readfiles3[2] -Pattern 'RecipntPerm' -InputFile $readfiles3[3]
        Eg-DeleteFiles -FilePath $readfiles3[2] -Pattern 'kRecipntPerm' -InputFile $readfiles3[4]
    }
}
catch{
    $errmsg3=$_.Exception.Message
    Write-Error -Message $errmsg3
}
[System.GC]::GetTotalMemory($true) | out-null

Try{
    if($appDetails -and $appDetails -ne 'none'){
        $dmUsrWArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
        Get-AzureADDomain | select * |Export-Csv $dmUsrWArr[1] -Encoding $encTyp
        $null=Protect-File  $dmUsrWArr[1] -Algorithm AES -KeyAsPlainText $dmUsrWArr[0] -RemoveSource
    }else{
        $dmUsrWArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
        Get-MSOLDomain | select * |Export-Csv $dmUsrWArr[1] -Encoding $encTyp
        $null=Protect-File  $dmUsrWArr[1] -Algorithm AES -KeyAsPlainText $dmUsrWArr[0] -RemoveSource
    }
}Catch{}
try{
    $dmUsrRArr=Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
    if($dmUsrRArr -ne $null -and [System.IO.File]::Exists($dmUsrRArr[1]) -eq 'True'){
        $uPMDomUsr=$dmUsrRArr[1] -replace (".csv",".dat") 
        $mdomusrPath=Unprotect-File $uPMDomUsr -Algorithm AES -KeyAsPlainText $dmUsrRArr[0]	
        $domain= import-csv $mdomusrPath -Encoding $encTyp
        Remove-Item $mdomusrPath
        Eg-DeleteFiles -FilePath $dmUsrRArr[2] -Pattern 'O365msolDomUsr' -InputFile $dmUsrRArr[3]
        Eg-DeleteFiles -FilePath $dmUsrRArr[2] -Pattern 'kO365msolDomUsr' -InputFile $dmUsrRArr[4]
    }
    [System.GC]::GetTotalMemory($true) | out-null
}
catch{
    $errmsg_dmUsr=$_.Exception.Message
	Write-Error -Message $errmsg_dmUsr
}
Try{
	if(!$appDetails -or $appDetails -eq 'none'){
        $passPlcyWArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolpass" -keyFileName "kO365msolpass" -EgPath $egurkhaPath   
	    foreach($dmn in $domain){
	        $valid=((Get-MsolPasswordPolicy -domain $dmn.Name -ErrorAction SilentlyContinue))| Select-Object -Property @{Name='Domain';Expression={$dmn.Name}},ValidityPeriod
	        if($valid -ne $null -and $valid -ne ''){
		        $valid|Export-Csv -Append -LiteralPath $passPlcyWArr[1] -Encoding $encTyp #-Force
	        }
	    }
	    $null=Protect-File  $passPlcyWArr[1] -Algorithm AES -KeyAsPlainText $passPlcyWArr[0] -RemoveSource
        try{
            $passPlcyRArr=Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolpass" -keyFileName "kO365msolpass" -EgPath $egurkhaPath
            if($passPlcyRArr -ne $null -and [System.IO.File]::Exists($passPlcyRArr[1]) -eq 'True'){
                $mpassPlcyUsr=$passPlcyRArr[1] -replace (".csv",".dat") 
                $passPlcyPath=Unprotect-File $mpassPlcyUsr -Algorithm AES -KeyAsPlainText $passPlcyRArr[0]	
                $msolPassword= import-csv $passPlcyPath -Encoding $encTyp
                for($j=0; $j -lt $msolPassword.Length; $j++){
                    $Domain=$msolPassword[$j].Domain.toString()
                    [int]$ValidityPeriod=$msolPassword[$j].ValidityPeriod
                    $dmnPwdExp.Add($Domain,$ValidityPeriod)
                }
                Remove-Item $passPlcyPath
                Eg-DeleteFiles -FilePath $passPlcyRArr[2] -Pattern 'O365msolpass' -InputFile $passPlcyRArr[3]
                Eg-DeleteFiles -FilePath $passPlcyRArr[2] -Pattern 'kO365msolpass' -InputFile $passPlcyRArr[4]
            }
        }
        catch{
            $errmsg_passPlcy=$_.Exception.Message
			Write-Error -Message $errmsg_passPlcy
        }
   }
}Catch{
    $egurkhaRprtPath=  $egurkhaPath+'\agent\'+$rptPath+'\'
    $fileRead=Get-ChildItem -Path $egurkhaRprtPath |Where-Object {$_.Name -like 'kO365msolpass*.dat'}| Sort-Object LastWriteTime -Descending | Select Name -First 1
    foreach($file in $fileRead){
        $fileName=([String]$file.Name).Trim()
        $chkfil=$egurkhaRprtPath+$fileName
        if([System.IO.File]::Exists($chkfil) -eq 'True'){
            Remove-Item $egurkhaRprtPath$fileName -Force
        }
    }
}
[System.GC]::GetTotalMemory($true) | out-null
    Try{
        if($appDetails -and $appDetails -ne 'none'){
            $writArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
            Get-AzureADUser -All $True| select * |Export-Csv $writArr[1] -Encoding $encTyp
            $null=Protect-File  $writArr[1] -Algorithm AES -KeyAsPlainText $writArr[0] -RemoveSource
        }else{
            $writArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
            Get-MsolUser -All| select * |Export-Csv $writArr[1] -Encoding $encTyp
            $null=Protect-File  $writArr[1] -Algorithm AES -KeyAsPlainText $writArr[0] -RemoveSource
        }
    }Catch{}

    try{
        $readArr=Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
        if($readArr -ne $null -and [System.IO.File]::Exists($readArr[1]) -eq 'True'){
            $unProtctMUsr=$readArr[1] -replace (".csv",".dat") 
            $musrPath=Unprotect-File $unProtctMUsr -Algorithm AES -KeyAsPlainText $readArr[0]	
            $usersview= import-csv $musrPath -Encoding $encTyp
            Remove-Item $musrPath
            Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'O365msolUsr' -InputFile $readArr[3]
            Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'kO365msolUsr' -InputFile $readArr[4]
        }
    }
    catch{
        $errmsg4=$_.Exception.Message
        Write-Error -Message $errmsg4
    }
    if($readfiles -ne $null){
        Write-Host 'ReadFile:'$readfiles[3]','$readfiles1[3] ','$readfiles2[3] ','$readfiles3[3] ','$readArr[3] ','$dmUsrRArr[3]
    }
	$sysDat=Get-Date
    if($appDetails -and $appDetails -ne 'none'){
	    $MsolRole = Get-AzureADDirectoryRole
    }else{
        $MsolRole = Get-MsolRole
    }
	foreach($roles in $MsolRole){
        if($appDetails -and $appDetails -ne 'none'){
            $rolemember=Get-AzureADDirectoryRoleMember -ObjectId $roles.ObjectId |Where{$_.ObjectType -eq 'User'}|select DisplayName
        }else{
	        $rolemember=Get-MsolRoleMember -RoleObjectId $roles.ObjectId |Where{$_.RoleMemberType -eq 'User'}|select DisplayName
        }
        if($rolemember -ne $null){
		    foreach($rolemembers in $rolemember ){  
                if($appDetails -and $appDetails -ne 'none'){
                    $rolesName=[String]$roles.DisplayName
                }else{
				    $rolesName=[String]$roles.Name
                }
				if($rolesName.Length -gt 200){            
					$rolesName=$rolesName.Substring(0,199)+"..."
				}
                Write-Host 'DDAdminUsers' $rolemembers.DisplayName '!' $rolesName 
		    }
	    }
	} 
    [System.GC]::GetTotalMemory($true) | out-null

    $actSync=0
	$actNonSync=0
	$ExcludingNames=$ExcludingNames.Replace("_"," ")
	$ExcludingName=$ExcludingNames.split('|')
	$DDD=$DDD |where {$ExcludingName -notcontains $_.DisplayName} | Sort-Object DisplayName 

    $CultureDateTimeFormat1 = (Get-Culture).DateTimeFormat
    $DateFormat1 = $CultureDateTimeFormat1.ShortDatePattern
    $TimeFormat1 = $CultureDateTimeFormat1.LongTimePattern
    $DateTimeFormat1 = "$DateFormat1 $TimeFormat1"
    
    $culture = Get-Culture
    $culture.DateTimeFormat.ShortDatePattern = 'yyyy-MM-dd'
    Set-Culture $culture
    $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
    $DateFormat = $CultureDateTimeFormat.ShortDatePattern
    $TimeFormat = $CultureDateTimeFormat.LongTimePattern
    $DateTimeFormat = "$DateFormat $TimeFormat"
    $hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt')
    if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}
    <#
    if($isPreviousScript){
	    foreach($Measures in $DDD){
            try{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.PrimarySmtpAddress -eq $Measures.PrimarySmtpAddress} | select LastLogonTime
                    $usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
	                Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }catch{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.PrimarySmtpAddress -eq $Measures.PrimarySmtpAddress} | select LastLogonTime
                    $usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)	            
	                Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }
        }
        $lastsyncUsers=$mailboxstatistics | Sort-Object { $_.LastLogonTime -as [DateTime] } -Descending | select -First 10
        foreach($topActiveUsers in  $lastsyncUsers  ){
            $usrLogonDat = [DateTime]::ParseExact($topActiveUsers.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
            Write-Host DDActiveSyncUsers $topActiveUsers.PrimarySmtpAddress ~!~ $usrLogonDat
        }
    }
    #>
    #else{
	    foreach($Measures in $DDD){
            try{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.UserPrincipalName -eq $Measures.PrimarySmtpAddress} | select LastActivityDate
                    $lstActDat=([String]$LastLogonTime.LastActivityDate).Trim()
                    if($lstActDat -ne $null -and $lstActDat -ne ''){
                        if($lstActDat.Length -gt 11){
                            $usrLogonDat=Eg-ParseExact -dateStr $lstActDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                        }else{
                            $usrLogonDat=Eg-ParseExact -dateStr $lstActDat -DateTimeFormat $DateFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                        }
                        #$usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
	                    Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
		            }
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }catch{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.UserPrincipalName -eq $Measures.PrimarySmtpAddress} | select LastActivityDate
                    $lstActDat=([String]$LastLogonTime.LastActivityDate).Trim()
                    if($lstActDat -ne $null -and $lstActDat -ne ''){
                        if($lstActDat.Length -gt 11){
                            $usrLogonDat=Eg-ParseExact -dateStr $lstActDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                        }else{
                            $usrLogonDat=Eg-ParseExact -dateStr $lstActDat -DateTimeFormat $DateFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                        }
                        #$usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)	            
	                Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
		}
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }
        }
        $lastsyncUsers=$mailboxstatistics | Sort-Object { $_.LastActivityDate -as [DateTime] } -Descending | select -First $rptTopNDD
        foreach($topActiveUsers in  $lastsyncUsers  ){
            $topLstActDat=([String]$topActiveUsers.LastActivityDate).Trim()
            if($topLstActDat -ne $null -and $topLstActDat -ne ''){
                if($topLstActDat.Length -gt 11){
                    $usrLogonDat=Eg-ParseExact -dateStr $topLstActDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                }else{
                    $usrLogonDat=Eg-ParseExact -dateStr $topLstActDat -DateTimeFormat $DateFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                }
                #$usrLogonDat = [DateTime]::ParseExact($topActiveUsers.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
                Write-Host DDActiveSyncUsers $topActiveUsers.UserPrincipalName ~!~ $usrLogonDat
	}
            }  
    #}
	Write-Host  SyncUsers$actSync'#'$actNonSync
    $ReciPrmterm=$ReciPrmterm | Sort-Object Identity
    foreach($mm in $ReciPrmterm){
	    if($mm -ne $null){
		    $Trustee=[String]$mm.Trustee;$identy=[String]$mm.Identity;$accCntrlTyp=[String]$mm.AccessControlType;$isInherited=[String]$mm.IsInherited;
            $inheritancTyp=[String]$mm.InheritanceType;$isVal=[String]$mm.IsValid;
            if($Trustee.Length -gt 200){ $Trustee=($Trustee.Substring(0,199))+"..." }
            if($identy.Length -gt 200){ $identy=($identy.Substring(0,199))+"..." }
            if($accCntrlTyp.Length -gt 200){ $accCntrlTyp=($accCntrlTyp.Substring(0,199))+"..." }
            if($isInherited.Length -gt 200){ $isInherited=($isInherited.Substring(0,199))+"..." }
            if($inheritancTyp.Length -gt 200){ $inheritancTyp=($inheritancTyp.Substring(0,199))+"..." }
            if($isVal.Length -gt 200){ $isVal=($isVal.Substring(0,199))+"..." }	
            $ddStr='SendAs '+$identy+'~!~'+$Trustee+'~!~'+$accCntrlTyp+'~!~'+$isInherited+'~!~'+$inheritancTyp+'~!~'+$isVal
	        write-host $ddStr
	    }
	}

	$SendOnBehalf=$measureterms |  Where-Object {$_.GrantSendOnBehalfTo -ne ''} | select DisplayName,Alias,UserPrincipalName,PrimarySmtpAddress,GrantSendOnBehalfTo,Identity | Sort-Object Identity
	foreach($mailbox in $SendOnBehalf){	
		$GrantSendOnBehalfTo=[String]$mailbox.GrantSendOnBehalfTo
        if($GrantSendOnBehalfTo.Length -gt 200){
            $GrantSendOnBehalfTo=$GrantSendOnBehalfTo.Substring(0,199)
		    $GrantSendOnBehalfTo=$GrantSendOnBehalfTo+"..."
        }
        $PrimarySmtpAddress=[String]$mailbox.PrimarySmtpAddress
        if($PrimarySmtpAddress.Length -gt 200){
            $PrimarySmtpAddress=$PrimarySmtpAddress.Substring(0,199)
		    $PrimarySmtpAddress=$PrimarySmtpAddress+"..."
        }
		Write-Host SendOnBehalf  $mailbox.DisplayName'~!~'$mailbox.UserPrincipalName'~!~'$PrimarySmtpAddress '~!~'$GrantSendOnBehalfTo'~!~-~!~-'
	}

	$Activecount=0 
	$InActivecount=0
	$neverlogcount=0
    <#
	if($isPreviousScript){
	    Foreach ($mailboxstat in $mailboxstatistics) {           
	        if($mailboxstat.LastLogonTime -eq $null -or $mailboxstat.LastLogonTime -eq "" ){
		        if($mailboxstat.DisplayName -ne "Discovery Search Mailbox"){
		            Write-Host "NeverLoggedIn~"$mailboxstat.PrimarySmtpAddress'~!~-~!~-~!~-~!~-~!~-'
		            $neverlogcount++
		        }
	        }
	        else{
	            #[datetime]$usrLogonDat=$mailboxstat.LastLogonTime
                $usrLogonDat = [DateTime]::ParseExact($mailboxstat.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
		        if($usrLogonDat -gt  $sysDat.AddDays(-$activeDays)){
				    #Write-Host "Active users~"$mailboxstat.PrimarySmtpAddress'~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
		            $Activecount++
			    }
			    elseif($usrLogonDat -lt $sysDat.AddDays(-$InactiveDays)){
				    Write-Host "Inactive users~"$mailboxstat.PrimarySmtpAddress'~!~'$usrLogonDat'~!~-~!~-~!~-~!~-'
		            $InActivecount++
			    }
	        }
	    }
    }
    #>
    #else{
        Foreach ($mailboxstat in $mailboxstatistics){           
	        if($mailboxstat.LastActivityDate -eq $null -or $mailboxstat.LastActivityDate -eq "" ){
		        if($mailboxstat.DisplayName -ne "Discovery Search Mailbox"){  
                    if($neverlogcount -lt $rptTopNDD){
		                Write-Host "NeverLoggedIn~"$mailboxstat.UserPrincipalName'~!~-~!~-~!~-~!~-~!~-'
                    }
		            $neverlogcount++
		        }
	        }
	        else{
                $mbLstActDat=([String]$mailboxstat.LastActivityDate).Trim()
                if($mbLstActDat -ne $null -and $mbLstActDat -ne ''){
                    if($mbLstActDat.Length -gt 11){
                        $usrLogonDat=Eg-ParseExact -dateStr $mbLstActDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                    }else{
                        $usrLogonDat=Eg-ParseExact -dateStr $mbLstActDat -DateTimeFormat $DateFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                    } 
                #$usrLogonDat = [DateTime]::ParseExact($mailboxstat.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
		        if ($usrLogonDat -gt  $sysDat.AddDays(-$activeDays)){
		            $Activecount++
			    }
			    elseif($usrLogonDat -lt $sysDat.AddDays(-$InactiveDays)){
				    Write-Host "Inactive users~"$mailboxstat.UserPrincipalName'~!~'$usrLogonDat'~!~-~!~-~!~-~!~-'
		            $InActivecount++
			    }
			}
	        }
	    }
    #}
    <#
    $cultureDTFrmt1 = Get-Culture
    $cultureDTFrmt1.DateTimeFormat.ShortDatePattern = 'M/d/yyyy'
    $cultureDTFrmt1.DateTimeFormat.LongTimePattern='h:mm:ss tt'
    Set-Culture $cultureDTFrmt1
    #>
    
    
	$users = $usersview |  where { $_.PasswordNeverExpires -eq $false } 
	$chkEnd=[datetime](Get-Date).AddDays(+$PassExpDays).ToUniversalTime()
	$chkStart=[datetime](Get-Date).ToUniversalTime()
	foreach($user in $users){
        $usrname = $user.UserPrincipalName
        $signname = $user.SignInName
        #[datetime]$passwordSetDate = $user.LastPasswordChangeTimestamp
        $usrPassChangTim=([String]$user.LastPasswordChangeTimestamp).Trim()
	    if($usrPassChangTim -ne $null -and $usrPassChangTim -ne ''){
            if($usrPassChangTim.Length -gt 11){
                $passwordSetDate=Eg-ParseExact -dateStr $usrPassChangTim -DateTimeFormat $DateTimeFormat1 -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            }else{
                $passwordSetDate=Eg-ParseExact -dateStr $usrPassChangTim -DateTimeFormat $DateFormat1 -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            }    
        #$passwordSetDate = [DateTime]::ParseExact($user.LastPasswordChangeTimestamp,$DateTimeFormat1,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
        $domainName= $usrname.substring($usrname.IndexOf('@')+1)
        [int]$maxPasswordAge=$dmnPwdExp[$domainName]
        try{
	        $expireson = $passwordSetDate.addDays($maxPasswordAge)
            if(($chkStart -le $expireson) -and ($chkEnd -ge $expireson)){
                $userlicAcc =  $user.Licenses.AccountSKUID
                if($userlicAcc -eq $null){
                    $userlicAcc = "-"
                }
                $userislic = $user.IsLicensed
                $usageloc = $user.UsageLocation
                if($usageloc -eq $null){
                    $usageloc = "-"
                }
                Write-Host 'userpassexpire~'$usrname'~!~'$signname'~!~'$expireson'~!~'$userlicAcc'~!~'$userislic'~!~'$usageloc
            }
        }
        catch{}
    }
}
Write-Host 'UsersCount~'$Activecount'~'$InActivecount'~'$neverlogcount
[System.GC]::GetTotalMemory($true) | out-null
