﻿Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Zones = Get-XAZone -EA 0 | sort-object ZoneName
If( $? )
{
	ForEach($Zone in $Zones)
	{
		Write-Host "Zone Name: " $Zone.ZoneName
		Write-Host "Current Data Collector: " $Zone.DataCollector
		$Servers = Get-XAServer -ZoneName $Zone.ZoneName -EA 0 | sort-object ElectionPreference, ServerName
		If( $? )
		{		
			ForEach($Server in $Servers)
			{
				Write-Host "Server Name and Preference: " $server.ServerName " " $server.ElectionPreference
			}
		}
		Else
		{
			Write-Host "Server Name and Preference: -"
		}
	}
}
Write-Host "#EG_SCRIPT_DONE#"
Remove-PSSnapin Citrix.XenApp.Commands
