Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$servers = Get-XAServer
if ($?)
{
	foreach($server in $servers)
	{
		$ServerName = $server.ServerName
		$CitrixProductName = $server.CitrixProductName
		$CitrixEdition = $server.CitrixEdition
		$CitrixEdition = ($CitrixEdition,"Edition") -join " "
		$CitrixVersion = $server.CitrixVersion
		$Hotfixes = Get-XAServerHotfix -ServerName $ServerName -EA 0 | Sort-Object HotfixName
		$Count = 0
		if($Hotfixes)
		{
			$Count = $Hotfixes.Count
		}
		Write-Host($ServerName,$CitrixProductName,$CitrixEdition,$CitrixVersion,$Count) -Separator "#~#"
	}
}
Write-Host "#EG_SCRIPT_DONE#"
Remove-PSSnapin Citrix.XenApp.Commands