$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.XenApp.Commands
$productIds = @{0 = "Unknown";
		1 = "Windows";
		3 = "Console" ;
		4 = "Text Terminals";
		7 = "MVGA Terminals";
		8 = "Java";
		10 = "EPOC";
		11 = "OS/2";
		14 = "DOS 32" ;
		81 = "UNIX/LINUX";
		82 = "MAC";
		83 = "iPhone";
		84 = "Android" ;
		85 = "Blackberry" ;
		86 = "Windows Metro" ;
		87 = "Windows Mobile";
		88 = "Blackberry Playbook";
		100 = "OEM" ;
		257 = "HTML5";
		261 = "Java" ;
		7945 = "Windows CE" ;
		32768 = "Terminal Client"
		32940 = "Windows CE - Wyse"
		32993 = "Thin OS - Wyse";
		}

$sessions = get-xasession -LocalhostOnly -full -EA 0
if($? -and $sessions)
{
	foreach($session in $sessions)
	{
		$groupName = "-"
		if($session.Protocol -eq 'Ica' -and $session.SessionId -ne "65536" -and $session.State -eq "Active")
		{
			$SessionName = $session.SessionName
			$SessionId = $session.SessionId
			$BrowserName = $session.BrowserName
			$AccountName = $session.AccountName
			$ClientName = $session.ClientName
			$ClientVersion = $session.ClientVersion
			$ClientAddress = $session.ClientAddress
			$ClientId = $session.ClientId
			$LogOnTime = $session.LogOnTime
			$ConnectTime = $session.ConnectTime
			$EncryptionLevel = $session.EncryptionLevel
			$ColorDepth = $session.ColorDepth
			$HorizontalResolution = $session.HorizontalResolution
			$VerticalResolution = $session.VerticalResolution

			$ClientProductId = $productIds.Get_Item($session.ClientProductId)

			if ($BrowserName -eq $null -or $BrowserName.length -eq 0)
			{
				$BrowserName = "-"
			}
			if ($AccountName -eq $null -or $AccountName.length -eq 0)
			{
				$AccountName = "-"
			}
			if ($ClientName -eq $null -or $ClientName.length -eq 0)
			{
				$ClientName = "-"
			}
			if ($ClientVersion -eq $null -or $ClientVersion.length -eq 0)
			{
				$ClientVersion = "-"
			}
			if ($ClientAddress -eq $null -or $ClientAddress.length -eq 0)
			{
				$ClientAddress = $session.ClientIPV4
				if ($ClientAddress -eq $null -or $ClientAddress.length -eq 0)
				{
					$ClientAddress = "-"
				}
			}
			if ($ClientId -eq $null -or $ClientId.length -eq 0)
			{
				$ClientId = "-"
			}
			if ($ClientProductId -eq $null -or $ClientProductId.length -eq 0)
			{
				$ClientProductId = "Unknown"
			}
			if ($LogOnTime -eq $null -or $LogOnTime.length -eq 0)
			{
				$LogOnTime = "-"
			}
			if ($ConnectTime -eq $null -or $ConnectTime.length -eq 0)
			{
				$ConnectTime = "-"
			}
			if ($EncryptionLevel -eq $null -or $EncryptionLevel.length -eq 0)
			{
				$EncryptionLevel = "-"
			}
			if ($ColorDepth -eq $null -or $ColorDepth.length -eq 0)
			{
				$ColorDepth = "-"
			}
			$ClientResolution = "-"
			if ($HorizontalResolution -ne $null -and $HorizontalResolution.length -gt 0 -and $VerticalResolution -ne $null -and $VerticalResolution.length -gt 0)
			{
				$ClientResolution = $HorizontalResolution + " x " + $VerticalResolution
			}

			Write-Host ($SessionName,$SessionId,$BrowserName,$AccountName,$ClientName,$ClientVersion,$ClientAddress,$ClientId,$ClientProductId,$groupName,$LogOnTime,$ConnectTime,$EncryptionLevel,$ColorDepth,$ClientResolution) -Separator ";"
		}
	}
}
Remove-pssnapin Citrix.XenApp.Commands


