$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#Import-modules
$dsInstallProp = Get-ItemProperty -Path HKLM:\SOFTWARE\Citrix\DeliveryServicesManagement
$dsInstallDir = $dsInstallProp.InstallDir
Import-Module "$dsInstallDir\Cmdlets\RoamingRecordsModule.psm1"
Import-Module "$dsInstallDir\Cmdlets\UtilsModule.psm1"


# NetScaler Gateways
Write-Host "NetScaler Gateways - starts"
$gateways = @((Get-DSGlobalGateways).Gateways)
foreach ($gateway in $gateways)
{
	$name = $gateway.Name
	$url = $gateway.Address
	Write-Host ($name, $url)  -Separator ";"
}
Write-Host "NetScaler Gateways - ends"

