﻿Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$LoadBalancingPolicies = Get-XALoadBalancingPolicy -EA 0 | sort-object PolicyName
Write-Host "###Load Balancing Policies - starts###"
If( $? -and $LoadBalancingPolicies)
{
	ForEach($LoadBalancingPolicy in $LoadBalancingPolicies)
	{
		$LoadBalancingPolicyConfiguration = Get-XALoadBalancingPolicyConfiguration -PolicyName $LoadBalancingPolicy.PolicyName
		$LoadBalancingPolicyFilter = Get-XALoadBalancingPolicyFilter -PolicyName $LoadBalancingPolicy.PolicyName 
	
		Write-Host "Load balancing policy name: " $LoadBalancingPolicy.PolicyName
		Write-Host "Load balancing policy description: " $LoadBalancingPolicy.Description
		if($LoadBalancingPolicy.Enabled)
		{
			Write-Host "Load balancing policy : Selected"
		}
		else
		{
			Write-Host "Load balancing policy : Not Selected"
		}
		Write-Host "Load balancing policy priority: " $LoadBalancingPolicy.Priority
		
		if($LoadBalancingPolicyFilter.AccessControlEnabled)
		{
			Write-Host "Filter based on Access Control : Selected"
		}
		else
		{
			Write-Host "Filter based on Access Control : Not Selected"
		}
		
		if($LoadBalancingPolicyFilter.AllowConnectionsThroughAccessGateway)
		{
			Write-Host "Apply to connections made through Access Gateway : Selected"
		}
		else
		{
			Write-Host "Apply to connections made through Access Gateway : Not Selected"
		}
		
		if($LoadBalancingPolicyFilter.ClientIPAddressEnabled)
		{
			Write-Host "Filter based on client IP address: Selected"
		}
		else
		{
			Write-Host "Filter based on client IP address: Not Selected"
		}
		if($LoadBalancingPolicyFilter.ClientNameEnabled)
		{
			Write-Host "Filter based on client name : Selected"
		}
		else
		{
			Write-Host "Filter based on client name : Not Selected"
		}	
		if($LoadBalancingPolicyFilter.AccountEnabled)
		{
			Write-Host "Filter based on user : Selected"
		}
		else
		{
			Write-Host "Filter based on user : Not Selected"
		}	
		if($LoadBalancingPolicyFilter.ApplyToAnonymousAccounts)
		{
			Write-Host "Apply to anonymous users: Selected"
		}
		else
		{
			Write-Host "Apply to anonymous users: Not Selected"
		}
		if($LoadBalancingPolicyConfiguration.WorkerGroupPreferenceAndFailoverState)
		{
			Write-Host "Configure application connection preference based on worker group : Selected"
		}	
		else
		{
			Write-Host "Configure application connection preference based on worker group : Not Selected"	
		}	
		
		If($LoadBalancingPolicyConfiguration.StreamingDeliveryProtocolState)
		{
			Write-Host "Set the delivery protocols for applications streamed to client : Selected"
			Write-Host "Streaming delivery option : " $LoadBalancingPolicyConfiguration.StreamingDeliveryOption
		}
		else
		{
			Write-Host "Set the delivery protocols for applications streamed to client : Not Selected"
			Write-Host "Steaming delivery option : -"	
		}
	}
}
Write-Host "###Load Balancing Policies - ends###"
Write-Host "#EG_SCRIPT_DONE#"
Remove-PSSnapin Citrix.XenApp.Commands
